/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class lengthofday
implements ActionListener {
    public JFrame MainFrame = new JFrame("Length of the Day General Aplication");
    JTextField GetTxtDay;
    JTextField GetTxtMonth;
    JTextField GetTxtYear;
    JTextField GetTxtLatDeg;
    JTextField GetTxtLatMin;
    JTextField GetTxtLatSec;
    JTextField GetTxtLatDir;
    JTextField GetTxtLonNum;
    JTextArea SetTxtOrto;
    JTextArea SetTxtOcaso;
    JTextArea SetTxtDuration;
    JTextArea txtError;
    JButton buttonCalc;
    JButton buttonClear;
    JButton buttonReset;
    representation mainGraph;
    static int[] lSun;
    static double[] alfaSun;
    static double[] nuSun;

    static {
        int[] nArray = new int[50];
        nArray[0] = 403406;
        nArray[1] = 195207;
        nArray[2] = 119433;
        nArray[3] = 112392;
        nArray[4] = 3891;
        nArray[5] = 2819;
        nArray[6] = 1721;
        nArray[8] = 660;
        nArray[9] = 350;
        nArray[10] = 334;
        nArray[11] = 314;
        nArray[12] = 268;
        nArray[13] = 242;
        nArray[14] = 234;
        nArray[15] = 158;
        nArray[16] = 132;
        nArray[17] = 129;
        nArray[18] = 114;
        nArray[19] = 99;
        nArray[20] = 93;
        nArray[21] = 86;
        nArray[22] = 78;
        nArray[23] = 72;
        nArray[24] = 68;
        nArray[25] = 64;
        nArray[26] = 46;
        nArray[27] = 38;
        nArray[28] = 37;
        nArray[29] = 32;
        nArray[30] = 29;
        nArray[31] = 28;
        nArray[32] = 27;
        nArray[33] = 27;
        nArray[34] = 25;
        nArray[35] = 24;
        nArray[36] = 21;
        nArray[37] = 21;
        nArray[38] = 20;
        nArray[39] = 18;
        nArray[40] = 17;
        nArray[41] = 14;
        nArray[42] = 13;
        nArray[43] = 13;
        nArray[44] = 13;
        nArray[45] = 12;
        nArray[46] = 10;
        nArray[47] = 10;
        nArray[48] = 10;
        nArray[49] = 10;
        lSun = nArray;
        alfaSun = new double[]{4.721964, 5.937458, 1.115589, 5.781616, 5.5474, 1.512, 4.1897, 1.163, 5.415, 4.315, 4.553, 5.198, 5.989, 2.911, 1.423, 0.061, 2.317, 3.193, 2.828, 0.52, 4.65, 4.35, 2.75, 4.5, 3.23, 1.22, 0.14, 3.44, 4.37, 1.14, 2.84, 5.96, 5.09, 1.72, 2.56, 1.92, 0.09, 5.98, 4.03, 4.27, 0.79, 4.24, 2.01, 2.65, 4.98, 0.93, 2.21, 3.59, 1.5, 2.55};
        nuSun = new double[]{1.621043, 62830.348067, 62830.821524, 62829.634302, 125660.5691, 125660.9845, 62832.4766, 0.813, 125659.31, 57533.85, -33.931, 777137.715, 78604.191, 5.412, 39302.098, -34.861, 115067.698, 15774.337, 5296.67, 58849.27, 5296.11, -3980.7, 52237.69, 55076.47, 261.08, 15773.85, 188491.03, -7756.55, 264.89, 117906.27, 55075.75, -7961.39, 188489.81, 2132.19, 109771.03, 54868.56, 25443.93, -55731.43, 60697.74, 2132.79, 109771.63, -7752.82, 188491.91, 207.81, 29424.63, -7.99, 46941.14, -68.29, 21463.25, 157208.4};
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                lengthofday p = new lengthofday();
            }
        });
    }

    public lengthofday() {
        this.MainFrame.setPreferredSize(new Dimension(1100, 400));
        this.MainFrame.setDefaultCloseOperation(3);
        this.CreatePanels();
        this.MainFrame.pack();
        this.MainFrame.setVisible(true);
    }

    private void CreatePanels() {
        JPanel panIzq = new JPanel(new GridLayout(11, 1, 5, 1));
        panIzq.add(this.createEmptyText());
        JPanel panDate = new JPanel();
        panDate.add(this.createText("Day: "));
        this.GetTxtDay = new JTextField("", 3);
        this.GetTxtDay.setEditable(true);
        panDate.add(this.GetTxtDay);
        panDate.add(this.createText("Month: "));
        this.GetTxtMonth = new JTextField("", 3);
        this.GetTxtMonth.setEditable(true);
        panDate.add(this.GetTxtMonth);
        panDate.add(this.createText("Year: "));
        this.GetTxtYear = new JTextField("", 5);
        this.GetTxtYear.setEditable(true);
        panDate.add(this.GetTxtYear);
        panIzq.add(panDate);
        panIzq.add(this.createEmptyText());
        JPanel panLat = new JPanel();
        panLat.add(this.createText("Latitude: "));
        JPanel lats = new JPanel();
        this.GetTxtLatDeg = new JTextField("", 2);
        this.GetTxtLatDeg.setEditable(true);
        lats.add(this.GetTxtLatDeg);
        JTextField TxtLatDeg = new JTextField("\u00ba", 1);
        TxtLatDeg.setEditable(false);
        TxtLatDeg.setBorder(BorderFactory.createEmptyBorder());
        lats.add(TxtLatDeg);
        this.GetTxtLatMin = new JTextField("", 2);
        this.GetTxtLatMin.setEditable(true);
        lats.add(this.GetTxtLatMin);
        JTextField TxtLatMin = new JTextField("'", 1);
        TxtLatMin.setEditable(false);
        TxtLatMin.setBorder(BorderFactory.createEmptyBorder());
        lats.add(TxtLatMin);
        this.GetTxtLatSec = new JTextField("", 3);
        this.GetTxtLatSec.setEditable(true);
        lats.add(this.GetTxtLatSec);
        JTextField TxtLatSec = new JTextField("''", 1);
        TxtLatSec.setEditable(false);
        TxtLatSec.setBorder(BorderFactory.createEmptyBorder());
        lats.add(TxtLatSec);
        this.GetTxtLatDir = new JTextField("", 2);
        this.GetTxtLatDir.setEditable(true);
        lats.add(this.GetTxtLatDir);
        JTextField TxtLatDir = new JTextField("(N or S)", 4);
        TxtLatDir.setEditable(false);
        TxtLatDir.setBorder(BorderFactory.createEmptyBorder());
        lats.add(TxtLatDir);
        panLat.add(lats);
        panIzq.add(panLat);
        JPanel panLon = new JPanel();
        panLon.add(this.createText("Longitude: "));
        JPanel lons = new JPanel();
        this.GetTxtLonNum = new JTextField("", 2);
        this.GetTxtLonNum.setEditable(true);
        lons.add(this.GetTxtLonNum);
        panLon.add(lons);
        panLon.add(this.createText(" GMT hour (ex: Berlin +2.0)"));
        panIzq.add(panLon);
        JPanel panError = new JPanel();
        this.txtError = new JTextArea(" ");
        Font font3 = new Font("Verdana", 2, 11);
        this.txtError.setSize(280, 200);
        this.txtError.setFont(font3);
        this.txtError.setForeground(Color.RED);
        Color c = new Color(240, 240, 240, 255);
        this.txtError.setBackground(c);
        this.txtError.setLineWrap(true);
        this.txtError.setWrapStyleWord(true);
        this.txtError.setAlignmentX(1.0f);
        this.txtError.setBorder(BorderFactory.createEmptyBorder());
        this.txtError.setEditable(false);
        panError.add(this.txtError);
        panIzq.add(panError);
        JPanel butC = new JPanel();
        this.buttonClear = new JButton("Clear values");
        this.buttonClear.addActionListener(this);
        butC.add(this.buttonClear);
        this.buttonCalc = new JButton("Calculate");
        this.buttonCalc.addActionListener(this);
        butC.add(this.buttonCalc);
        panIzq.add(butC);
        JPanel panOrto = new JPanel(new FlowLayout(1));
        panOrto.add(this.createText("Sunrise: "));
        this.SetTxtOrto = new JTextArea(" ");
        this.SetTxtOrto.setEditable(false);
        panOrto.add(this.SetTxtOrto);
        panOrto.add(this.createText(" a.m"));
        panIzq.add(panOrto);
        JPanel panOcaso = new JPanel();
        panOcaso.add(this.createText("Sunset: "));
        this.SetTxtOcaso = new JTextArea(" ");
        this.SetTxtOcaso.setEditable(false);
        panOcaso.add(this.SetTxtOcaso);
        panOcaso.add(this.createText(" p.m"));
        panIzq.add(panOcaso);
        JPanel panLength = new JPanel();
        panLength.add(this.createText("Length of Day: "));
        this.SetTxtDuration = new JTextArea(" ");
        this.SetTxtDuration.setEditable(false);
        panLength.add(this.SetTxtDuration);
        panLength.add(this.createText(" hours"));
        panIzq.add(panLength);
        JPanel buttons = new JPanel();
        this.buttonReset = new JButton("Clear Sun Paths");
        this.buttonReset.addActionListener(this);
        buttons.add(this.buttonReset);
        panIzq.add(buttons);
        this.MainFrame.add((Component)panIzq, "West");
        this.mainGraph = new representation();
        this.MainFrame.add((Component)this.mainGraph, "Center");
        this.GetTxtDay.setText("21");
        this.GetTxtMonth.setText("3");
        this.GetTxtYear.setText("2012");
        this.GetTxtLatDeg.setText("40");
        this.GetTxtLatMin.setText("0");
        this.GetTxtLatSec.setText("0");
        this.GetTxtLatDir.setText("N");
        this.GetTxtLonNum.setText("0");
    }

    private JTextField createEmptyText() {
        JTextField txtEmpty = new JTextField("");
        txtEmpty.setBorder(BorderFactory.createEmptyBorder());
        txtEmpty.setEditable(false);
        return txtEmpty;
    }

    private JTextField createText(String txt) {
        JTextField txtFill = new JTextField(txt);
        txtFill.setBorder(BorderFactory.createEmptyBorder());
        txtFill.setEditable(false);
        return txtFill;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCalc) {
            this.calculateLength();
        }
        if (e.getSource() == this.buttonClear) {
            this.GetTxtDay.setText("");
            this.GetTxtMonth.setText("");
            this.GetTxtYear.setText("");
            this.GetTxtLatDeg.setText("");
            this.GetTxtLatMin.setText("");
            this.GetTxtLatSec.setText("");
            this.GetTxtLatDir.setText("");
            this.GetTxtLonNum.setText("");
            this.SetTxtOrto.setText("");
            this.SetTxtOcaso.setText("");
            this.SetTxtDuration.setText("");
            this.txtError.setText("");
        }
        if (e.getSource() == this.buttonReset) {
            this.mainGraph.deleteRepresentations();
            this.mainGraph.repaint();
        }
    }

    public void calculateLength() {
        boolean validData = this.checkInputData();
        if (validData) {
            double sth;
            double UTsunshine;
            this.txtError.setText(" ");
            this.SetTxtOrto.setText(" ");
            this.SetTxtOcaso.setText(" ");
            this.SetTxtDuration.setText(" ");
            int day = Integer.parseInt(this.GetTxtDay.getText());
            int month = Integer.parseInt(this.GetTxtMonth.getText());
            int year = Integer.parseInt(this.GetTxtYear.getText());
            int latDeg = Integer.parseInt(this.GetTxtLatDeg.getText());
            int latMin = Integer.parseInt(this.GetTxtLatMin.getText());
            int latSeg = Integer.parseInt(this.GetTxtLatSec.getText());
            char latDir = this.GetTxtLatDir.getText().charAt(0);
            double latPlace_radians = ((double)latDeg + (double)latMin / 60.0 + (double)latSeg / 3600.0) * Math.PI / 180.0;
            if (latDir == 's' || latDir == 'S') {
                latPlace_radians = Math.PI * 2 - latPlace_radians;
            }
            double lonPlace_hours = Integer.parseInt(this.GetTxtLonNum.getText());
            int a = (14 - month) / 12;
            int y = year + 4800 - a;
            int m = month + 12 * a - 3;
            float JDN = day + (153 * m + 2) / 5 + 365 * y + y / 4 - y / 100 + y / 400 - 32045;
            float JD = JDN + 0.0f + 0.0f + 0.0f;
            double T = (JD - 2451545.0f) / 36525.0f;
            double U = T / 100.0;
            double lonSun = (4.9353929 + 62833.196168 * U + Math.pow(10.0, -7.0) * this.escalarProd(U)) % (Math.PI * 2);
            double oblic = 0.4090928 - 0.0226938 * U + Math.pow(10.0, -7.0) * (-75.0 * Math.pow(U, 2.0) + 96926.0 * Math.pow(U, 3.0) - 2491.0 * Math.pow(U, 4.0) - 12104.0 * Math.pow(U, 5.0) + (446.0 * Math.cos(this.NutA1(U)) + 28.0 * Math.cos(this.NutA2(U))));
            double sinDeltaSun = Math.sin(oblic) * Math.sin(lonSun);
            double DeltaSun = Math.asin(sinDeltaSun) % (Math.PI * 2);
            if (DeltaSun < 0.0) {
                DeltaSun += Math.PI * 2;
            }
            double AlfaSun = Math.atan2(Math.cos(oblic) * Math.sin(lonSun), Math.cos(oblic) * Math.cos(lonSun));
            double H0 = Math.acos(-Math.tan(DeltaSun) * Math.tan(latPlace_radians)) % Math.PI;
            double STsunshine = AlfaSun - H0;
            double STsunset = AlfaSun + H0;
            if (STsunset > Math.PI * 2) {
                STsunset %= Math.PI * 2;
            }
            if (STsunset < 0.0) {
                STsunset += Math.PI * 2;
            }
            if (STsunshine > Math.PI * 2) {
                STsunshine %= Math.PI * 2;
            }
            if (STsunshine < 0.0) {
                STsunshine += Math.PI * 2;
            }
            double STsunset_hours = STsunset * 24.0 / (Math.PI * 2) % 24.0;
            double STsunshine_hours = STsunshine * 24.0 / (Math.PI * 2) % 24.0;
            double GMST0_secs = 24110.54841 + 8640184.812866 * T + 0.093104 * Math.pow(T, 2.0) + 6.2E-6 * Math.pow(T, 3.0);
            double GMST0_hours = GMST0_secs / 3600.0 % 24.0;
            double UTsunset = 0.0;
            UTsunset = 0.9972696 * (STsunset_hours - GMST0_hours - lonPlace_hours);
            if (UTsunset < 0.0) {
                UTsunset += 24.0;
            }
            if ((UTsunshine = 0.9972696 * (STsunshine_hours - GMST0_hours - lonPlace_hours)) < 0.0) {
                UTsunshine += 24.0;
            }
            if (STsunset < STsunshine && (UTsunset = 0.9972696 * ((sth = (STsunset += Math.PI * 2) * 24.0 / (Math.PI * 2)) - GMST0_hours - lonPlace_hours)) < 0.0) {
                UTsunset = (24.0 - UTsunset) % 24.0;
            }
            double LoD = UTsunset - UTsunshine;
            UTsunset %= 24.0;
            UTsunshine %= 24.0;
            try {
                this.SetTxtOrto.setText(Double.toString(UTsunshine).substring(0, 5));
                this.SetTxtOcaso.setText(Double.toString(UTsunset).substring(0, 5));
                this.SetTxtDuration.setText(Double.toString(LoD).substring(0, 5));
                this.mainGraph.recordRepresentation(day, month, year, lonPlace_hours, latPlace_radians, UTsunshine, UTsunset);
                double val = STsunshine;
                while (val <= STsunset + 0.05) {
                    double theCosZ = Math.cos(DeltaSun) * Math.cos(val - AlfaSun) * Math.cos(latPlace_radians) + Math.sin(DeltaSun) * Math.sin(latPlace_radians);
                    double Z = Math.acos(theCosZ);
                    double theHeight = 90.0 - Z * 180.0 / Math.PI;
                    double UTval = 0.9972696 * (val * 24.0 / (Math.PI * 2) - GMST0_hours - lonPlace_hours);
                    if (UTval < 0.0) {
                        UTval += 24.0;
                    }
                    this.mainGraph.addPointLastRecord(new Point2D.Double(15.0 + UTval * 32.0, 340.0 - theHeight * 3.0));
                    val += 0.1;
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                this.txtError.setText("For the day and latitude requested there are no sunset and no sunrise");
            }
            this.mainGraph.repaint();
        }
    }

    private double escalarProd(double myT) {
        double[] addition = null;
        addition = new double[50];
        int i = 0;
        while (i < 50) {
            addition[i] = 0.0;
            addition[i] = alfaSun[i] + nuSun[i] * myT;
            ++i;
        }
        double pesc = 0.0;
        int k = 0;
        while (k < 50) {
            pesc += (double)lSun[k] * Math.sin(addition[k]);
            ++k;
        }
        return pesc;
    }

    private double NutA1(double value) {
        double a = 2.18 - 3375.7 * value + 0.36 * value * value;
        return a;
    }

    private double NutA2(double value) {
        double b = 3.51 + 125666.39 * value + 0.1 * value * value;
        return b;
    }

    private boolean checkInputData() {
        boolean validData = true;
        int day = 0;
        int month = 0;
        int year = 0;
        try {
            day = Integer.parseInt(this.GetTxtDay.getText());
            if (day < 1 || day > 31) {
                validData = false;
                this.txtError.setText("not a valid 'Day' for a day");
            }
        }
        catch (NumberFormatException e) {
            validData = false;
            this.txtError.setText("the 'Day' should be a number");
        }
        try {
            month = Integer.parseInt(this.GetTxtMonth.getText());
            if (month < 1 || month > 12) {
                validData = false;
                this.txtError.setText("not a valid 'Month' for a month");
            } else {
                if ((month == 4 || month == 6 || month == 9 || month == 11) && day > 30) {
                    validData = false;
                    this.txtError.setText("your month has as much 30 days ");
                }
                if (month == 2 & day > 29) {
                    validData = false;
                    this.txtError.setText("your month has as much 28 or 29 days ");
                }
            }
        }
        catch (NumberFormatException e) {
            validData = false;
            this.txtError.setText("the 'Month' should be a number");
        }
        try {
            year = Integer.parseInt(this.GetTxtYear.getText());
            if (year < 1900) {
                validData = false;
                this.txtError.setText("the 'Year' should be bigger than '1900'");
            }
        }
        catch (NumberFormatException e) {
            validData = false;
            this.txtError.setText("the 'Year' should be a number");
        }
        int latdeg = 0;
        int latmin = 0;
        float latsec = 0.0f;
        int latdir = 78;
        try {
            latdeg = Integer.parseInt(this.GetTxtLatDeg.getText());
            if (latdeg > 80 || latdeg < 1) {
                validData = false;
                this.txtError.setText("degrees of latitude between 1 and 80");
            }
        }
        catch (NumberFormatException e) {
            validData = false;
            this.txtError.setText("Latitude degrees should be an integer");
        }
        try {
            latmin = Integer.parseInt(this.GetTxtLatMin.getText());
            if (latmin > 60 || latmin < 0) {
                validData = false;
                this.txtError.setText("minutes of latitude between 0 and 60");
            }
        }
        catch (NumberFormatException e) {
            validData = false;
            this.txtError.setText("Latitude minutes should be an integer");
        }
        try {
            latsec = Integer.parseInt(this.GetTxtLatSec.getText());
            if (latsec > 60.0f || latsec < 0.0f) {
                validData = false;
                this.txtError.setText("seconds of latitude between 0 and 60");
            }
        }
        catch (NumberFormatException e) {
            validData = false;
            this.txtError.setText("Latitude seconds should be an integer");
        }
        if ((latdir = (int)this.GetTxtLatDir.getText().charAt(0)) != 110 && latdir != 78 && latdir != 115 && latdir != 83) {
            validData = false;
            this.txtError.setText("direction of latitude should be 'n','N','s' or 'S'");
        }
        int lon = 0;
        try {
            lon = Integer.parseInt(this.GetTxtLonNum.getText());
            if (lon > 12 || lon < -12) {
                validData = false;
                this.txtError.setText("Longitude between -12 and 12");
            }
        }
        catch (NumberFormatException e) {
            validData = false;
            this.txtError.setText("Longitud should be a number");
        }
        return validData;
    }
}

