/*
 * Decompiled with CFR 0.152.
 */
import com.Ostermiller.util.CSVParser;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import sum.ereignis.EBAnwendung;
import sum.komponenten.Etikett;
import sum.komponenten.Knopf;
import sum.komponenten.Tabelle;
import sum.werkzeuge.Textwerkzeug;

public class SuMAnwendung
extends EBAnwendung {
    private Textwerkzeug hatTW;
    private Knopf hatKnopfPerson = new Knopf(53.0, 69.0, 120.0, 25.0, "Person");
    private Etikett hatEtikettControlCenter;
    private Knopf hatKnopfNewFood;
    private Knopf hatKnopfNewActivity;
    private Knopf hatKnopfClearFood;
    private Knopf hatKnopfClearActivity;
    private Tabelle hatTabelleFood;
    private Tabelle hatTabelleActivity;
    private Knopf hatKnopfQuit;
    private Etikett hatEtikettResult;
    private Etikett hatEtikettFood;
    private Etikett hatEtikettActivity;
    private PersonWindow pw;
    private FoodWindow fw;
    private ActivityWindow aw;
    private Person person;
    private Hashtable foodTable;
    private Hashtable activityTable;
    private ArrayList foodList;
    private ArrayList activityList;

    public SuMAnwendung() {
        super(860, 250);
        double cals;
        String t;
        String name;
        boolean b;
        CSVParser csvParser;
        this.hatKnopfPerson.setzeBearbeiterGeklickt("hatKnopfPersonGeklickt");
        this.hatEtikettControlCenter = new Etikett(53.0, 23.0, 120.0, 25.0, "Control Center");
        this.hatEtikettControlCenter.setzeAusrichtung(1);
        this.hatKnopfNewFood = new Knopf(53.0, 112.0, 120.0, 25.0, "New Food");
        this.hatKnopfNewFood.setzeBearbeiterGeklickt("hatKnopfNewFoodGeklickt");
        this.hatKnopfNewActivity = new Knopf(53.0, 155.0, 120.0, 25.0, "New Activity");
        this.hatKnopfNewActivity.setzeBearbeiterGeklickt("hatKnopfNewActivityGeklickt");
        this.hatTabelleFood = new Tabelle(203.0, 68.0, 305.0, 113.0, 1, 4);
        this.hatTabelleFood.setzeSpaltenbreite(80);
        this.hatTabelleFood.setzeSpaltentitelAn("Day", 1);
        this.hatTabelleFood.setzeSpaltentitelAn("Meal", 2);
        this.hatTabelleFood.setzeSpaltentitelAn("Food", 3);
        this.hatTabelleFood.setzeSpaltentitelAn("Grams", 4);
        this.hatTabelleActivity = new Tabelle(532.0, 68.0, 305.0, 113.0, 1, 3);
        this.hatTabelleActivity.setzeSpaltenbreite(100);
        this.hatTabelleActivity.setzeSpaltentitelAn("Day", 1);
        this.hatTabelleActivity.setzeSpaltentitelAn("Activity", 2);
        this.hatTabelleActivity.setzeSpaltentitelAn("Hours", 3);
        this.hatKnopfQuit = new Knopf(53.0, 199.0, 120.0, 25.0, "Quit");
        this.hatKnopfQuit.setzeBearbeiterGeklickt("hatKnopfQuitGeklickt");
        this.hatEtikettResult = new Etikett(205.0, 199.0, 305.0, 25.0, "Result");
        this.hatEtikettResult.setzeAusrichtung(0);
        this.hatEtikettFood = new Etikett(201.0, 35.0, 100.0, 25.0, "Food");
        this.hatEtikettFood.setzeAusrichtung(1);
        this.hatKnopfClearFood = new Knopf(310.0, 35.0, 100.0, 25.0, "Clear");
        this.hatKnopfClearFood.setzeBearbeiterGeklickt("hatKnopfClearFoodGeklickt");
        this.hatEtikettActivity = new Etikett(531.0, 35.0, 100.0, 25.0, "Activity");
        this.hatEtikettActivity.setzeAusrichtung(1);
        this.hatKnopfClearActivity = new Knopf(640.0, 35.0, 100.0, 25.0, "Clear");
        this.hatKnopfClearActivity.setzeBearbeiterGeklickt("hatKnopfClearActivityGeklickt");
        this.hatTW = new Textwerkzeug();
        this.load();
        this.foodTable = new Hashtable();
        try {
            csvParser = new CSVParser(new FileInputStream("data/foods.csv"));
            b = false;
            name = "";
            while ((t = csvParser.nextValue()) != null) {
                boolean bl = b = !b;
                if (b) {
                    name = t;
                    continue;
                }
                cals = this.hatTW.alsZahl(t);
                Food f = new Food(name, cals);
                this.foodTable.put(name, f);
            }
            csvParser.close();
        }
        catch (Exception e) {
            System.out.println("Food File Error");
            this.beenden();
        }
        this.activityTable = new Hashtable();
        try {
            csvParser = new CSVParser(new FileInputStream("data/activities.csv"));
            b = false;
            name = "";
            while ((t = csvParser.nextValue()) != null) {
                boolean bl = b = !b;
                if (b) {
                    name = t;
                    continue;
                }
                cals = this.hatTW.alsZahl(t);
                Activity a = new Activity(name, cals);
                this.activityTable.put(name, a);
            }
            csvParser.close();
        }
        catch (Exception e) {
            System.out.println("Activities File Error");
            this.beenden();
        }
        this.updateResult();
    }

    public void hatKnopfPersonGeklickt() {
        this.pw = new PersonWindow(this.person);
    }

    public void hatKnopfNewFoodGeklickt() {
        this.fw = new FoodWindow(this, this.foodTable);
    }

    public void hatKnopfNewActivityGeklickt() {
        this.aw = new ActivityWindow(this, this.activityTable);
    }

    public void hatKnopfQuitGeklickt() {
        this.save();
        this.beenden();
    }

    public void hatKnopfPersonCancelGeklickt() {
        this.pw.hatKnopfCancelGeklickt();
    }

    public void hatKnopfPersonOkGeklickt() {
        this.pw.hatKnopfOkGeklickt();
        this.updateResult();
    }

    public void hatKnopfFoodCancelGeklickt() {
        this.fw.hatKnopfCancelGeklickt();
    }

    public void hatKnopfFoodOkGeklickt() {
        this.fw.hatKnopfOkGeklickt();
    }

    public void hatKnopfActivityCancelGeklickt() {
        this.aw.hatKnopfCancelGeklickt();
    }

    public void hatKnopfActivityOkGeklickt() {
        this.aw.hatKnopfOkGeklickt();
    }

    public void addFood(FoodItem pItem) {
        this.foodList.add(pItem);
        this.updateFoodTable();
        this.updateResult();
    }

    public void hatKnopfClearFoodGeklickt() {
        this.foodList.clear();
        this.updateFoodTable();
        this.updateResult();
    }

    public void updateFoodTable() {
        this.hatTabelleFood.setzeZeilenanzahl(this.foodList.size());
        for (int i = 0; i < this.foodList.size(); ++i) {
            FoodItem fi = (FoodItem)this.foodList.get(i);
            String day = "";
            switch (fi.day) {
                case 1: {
                    day = "Monday";
                    break;
                }
                case 2: {
                    day = "Tuesday";
                    break;
                }
                case 3: {
                    day = "Wednesday";
                    break;
                }
                case 4: {
                    day = "Thursday";
                    break;
                }
                case 5: {
                    day = "Friday";
                    break;
                }
                case 6: {
                    day = "Saturday";
                    break;
                }
                case 7: {
                    day = "Sunday";
                }
            }
            String meal = "";
            switch (fi.meal) {
                case 1: {
                    meal = "Breakfast";
                    break;
                }
                case 2: {
                    meal = "Lunch";
                    break;
                }
                case 3: {
                    meal = "Dinner";
                    break;
                }
                case 4: {
                    meal = "Other";
                }
            }
            this.hatTabelleFood.setzeInhaltAn(day, i + 1, 1);
            this.hatTabelleFood.setzeInhaltAn(meal, i + 1, 2);
            this.hatTabelleFood.setzeInhaltAn(fi.food().name(), i + 1, 3);
            this.hatTabelleFood.setzeInhaltAn(fi.grams(), i + 1, 4);
        }
    }

    public void addActivity(ActivityItem pItem) {
        this.activityList.add(pItem);
        this.updateActivityTable();
        this.updateResult();
    }

    public void hatKnopfClearActivityGeklickt() {
        this.activityList.clear();
        this.updateActivityTable();
        this.updateResult();
    }

    public void updateActivityTable() {
        this.hatTabelleActivity.setzeZeilenanzahl(this.activityList.size());
        for (int i = 0; i < this.activityList.size(); ++i) {
            ActivityItem ai = (ActivityItem)this.activityList.get(i);
            String day = "";
            switch (ai.day) {
                case 1: {
                    day = "Monday";
                    break;
                }
                case 2: {
                    day = "Tuesday";
                    break;
                }
                case 3: {
                    day = "Wednesday";
                    break;
                }
                case 4: {
                    day = "Thursday";
                    break;
                }
                case 5: {
                    day = "Friday";
                    break;
                }
                case 6: {
                    day = "Saturday";
                    break;
                }
                case 7: {
                    day = "Sunday";
                }
            }
            this.hatTabelleActivity.setzeInhaltAn(day, i + 1, 1);
            this.hatTabelleActivity.setzeInhaltAn(ai.activity().name(), i + 1, 2);
            this.hatTabelleActivity.setzeInhaltAn(ai.hours(), i + 1, 3);
        }
    }

    public void updateResult() {
        int i;
        int theCalories = -this.person.calories();
        for (i = 0; i < this.foodList.size(); ++i) {
            FoodItem fi = (FoodItem)this.foodList.get(i);
            theCalories += fi.calories();
        }
        for (i = 0; i < this.activityList.size(); ++i) {
            ActivityItem ai = (ActivityItem)this.activityList.get(i);
            theCalories -= ai.calories();
        }
        this.hatEtikettResult.setzeInhalt("Result: " + theCalories + " Kilocalories");
    }

    public void save() {
        ObjectOutputStream oos;
        FileOutputStream fout;
        try {
            fout = new FileOutputStream("data/person.ser");
            oos = new ObjectOutputStream(fout);
            oos.writeObject(this.person);
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            fout = new FileOutputStream("data/food.ser");
            oos = new ObjectOutputStream(fout);
            oos.writeObject(this.foodList);
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            fout = new FileOutputStream("data/activity.ser");
            oos = new ObjectOutputStream(fout);
            oos.writeObject(this.activityList);
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load() {
        ObjectInputStream o;
        FileInputStream file;
        try {
            file = new FileInputStream("data/person.ser");
            o = new ObjectInputStream(file);
            this.person = (Person)o.readObject();
            o.close();
        }
        catch (IOException e) {
            System.err.println(e);
            this.person = new Person();
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
            this.beenden();
        }
        try {
            file = new FileInputStream("data/food.ser");
            o = new ObjectInputStream(file);
            this.foodList = (ArrayList)o.readObject();
            o.close();
        }
        catch (IOException e) {
            System.err.println(e);
            this.foodList = new ArrayList();
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
            this.beenden();
        }
        try {
            file = new FileInputStream("data/activity.ser");
            o = new ObjectInputStream(file);
            this.activityList = (ArrayList)o.readObject();
            o.close();
        }
        catch (IOException e) {
            System.err.println(e);
            this.activityList = new ArrayList();
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
            this.beenden();
        }
        this.updateFoodTable();
        this.updateActivityTable();
    }
}

