/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayIterator<ElementType>
implements Iterator<ElementType> {
    private ElementType[] array;
    private int index = 0;
    private boolean lastRemoved = false;

    public ArrayIterator(ElementType[] array) {
        this.array = array;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.array.length;
    }

    @Override
    public ElementType next() throws NoSuchElementException {
        if (this.index >= this.array.length) {
            throw new NoSuchElementException("Array index: " + this.index);
        }
        ElementType object = this.array[this.index];
        ++this.index;
        this.lastRemoved = false;
        return object;
    }

    @Override
    public void remove() {
        if (this.index == 0) {
            throw new IllegalStateException();
        }
        if (this.lastRemoved) {
            throw new IllegalStateException();
        }
        this.array[this.index - 1] = null;
        this.lastRemoved = true;
    }
}

