/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import com.Ostermiller.util.CGILexer;
import com.Ostermiller.util.IteratorEnumeration;
import com.Ostermiller.util.NameValuePair;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CGIParser {
    private HashMap<String, ArrayList<String>> nameValuePairHash = new HashMap();
    private LinkedList<NameValuePair> nameValuePairList = new LinkedList();

    @Deprecated
    public CGIParser(InputStream in) throws IOException {
        if (in == null) {
            return;
        }
        CGILexer lex = new CGILexer(in);
        this.parse(lex, "ISO-8859-1");
    }

    public CGIParser(InputStream in, String charset) throws IOException, UnsupportedEncodingException {
        if (in == null) {
            return;
        }
        CGILexer lex = new CGILexer(new InputStreamReader(in, charset));
        this.parse(lex, charset);
    }

    @Deprecated
    public CGIParser(Reader in) throws IOException {
        if (in == null) {
            return;
        }
        CGILexer lex = new CGILexer(in);
        this.parse(lex, "ISO-8859-1");
    }

    public CGIParser(Reader in, String charset) throws IOException, UnsupportedEncodingException {
        if (in == null) {
            return;
        }
        CGILexer lex = new CGILexer(in);
        this.parse(lex, charset);
    }

    @Deprecated
    public CGIParser(String s) {
        if (s == null) {
            return;
        }
        try {
            CGILexer lex = new CGILexer(new StringReader(s));
            this.parse(lex, "ISO-8859-1");
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public CGIParser(String s, String charset) throws UnsupportedEncodingException {
        if (s == null) {
            return;
        }
        try {
            CGILexer lex = new CGILexer(new StringReader(s));
            this.parse(lex, charset);
        }
        catch (UnsupportedEncodingException uex) {
            throw uex;
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    private void parse(CGILexer lex, String charset) throws IOException, UnsupportedEncodingException {
        String nameValue;
        while ((nameValue = lex.nextToken()) != null) {
            String value;
            String name;
            int equalInd = nameValue.indexOf("=");
            if (equalInd == -1) {
                name = nameValue;
                value = "";
            } else {
                name = nameValue.substring(0, equalInd);
                value = nameValue.substring(equalInd + 1, nameValue.length());
            }
            try {
                name = URLDecoder.decode(name, charset);
            }
            catch (IllegalArgumentException iax) {
                name = "";
            }
            try {
                value = URLDecoder.decode(value, charset);
            }
            catch (IllegalArgumentException iax) {
                value = "";
            }
            ArrayList<String> values = this.nameValuePairHash.get(name);
            if (values == null) {
                values = new ArrayList();
            }
            values.add(value);
            this.nameValuePairHash.put(name, values);
            this.nameValuePairList.add(new NameValuePair(name, value));
        }
    }

    public String[] getParameterValues(String name) {
        ArrayList<String> values = this.nameValuePairHash.get(name);
        if (values == null) {
            return null;
        }
        String[] valArray = new String[values.size()];
        return values.toArray(valArray);
    }

    public void setParameter(String name, String value) {
        Iterator listIterator = this.nameValuePairList.iterator();
        while (listIterator.hasNext()) {
            NameValuePair nameValuePair = (NameValuePair)listIterator.next();
            if (!nameValuePair.getName().equals(name)) continue;
            listIterator.remove();
        }
        if (value == null) {
            this.nameValuePairHash.remove(name);
            return;
        }
        ArrayList<String> values = this.nameValuePairHash.get(name);
        if (values == null) {
            values = new ArrayList();
        }
        values.clear();
        values.add(value);
        this.nameValuePairHash.put(name, values);
        this.nameValuePairList.add(new NameValuePair(name, value));
    }

    public void setParameter(String name, String[] values) {
        Iterator listIterator = this.nameValuePairList.iterator();
        while (listIterator.hasNext()) {
            NameValuePair nameValuePair = (NameValuePair)listIterator.next();
            if (!nameValuePair.getName().equals(name)) continue;
            listIterator.remove();
        }
        if (values == null || values.length == 0) {
            this.nameValuePairHash.remove(name);
            return;
        }
        for (String element : values) {
            if (element != null) continue;
            throw new NullPointerException();
        }
        ArrayList<String> valuesVec = this.nameValuePairHash.get(name);
        if (valuesVec == null) {
            valuesVec = new ArrayList();
        }
        valuesVec.clear();
        for (String element : values) {
            valuesVec.add(element);
            this.nameValuePairList.add(new NameValuePair(name, element));
        }
        this.nameValuePairHash.put(name, valuesVec);
    }

    public void addParameter(String name, String value) {
        if (value == null) {
            return;
        }
        ArrayList<String> values = this.nameValuePairHash.get(name);
        if (values == null) {
            values = new ArrayList();
        }
        values.add(value);
        this.nameValuePairHash.put(name, values);
        this.nameValuePairList.add(new NameValuePair(name, value));
    }

    public void addParameter(String name, String[] values) {
        if (values == null || values.length == 0) {
            return;
        }
        for (String element : values) {
            if (element != null) continue;
            throw new NullPointerException();
        }
        ArrayList<String> valuesVec = this.nameValuePairHash.get(name);
        if (valuesVec == null) {
            valuesVec = new ArrayList();
        }
        for (String element : values) {
            valuesVec.add(element);
            this.nameValuePairList.add(new NameValuePair(name, element));
        }
        this.nameValuePairHash.put(name, valuesVec);
    }

    public String getParameter(String name) {
        ArrayList<String> values = this.nameValuePairHash.get(name);
        if (values == null) {
            return null;
        }
        return values.get(0);
    }

    public Enumeration<String> getParameterNames() {
        return new IteratorEnumeration<String>(this.nameValuePairHash.keySet().iterator());
    }

    public String[] getParameterNameList() {
        return this.nameValuePairHash.keySet().toArray(new String[0]);
    }

    public NameValuePair[] getParameters() {
        return this.nameValuePairList.toArray(new NameValuePair[0]);
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        boolean bFirst = true;
        for (NameValuePair nameValuePair : this.nameValuePairList) {
            if (!bFirst) {
                sb.append('&');
            }
            bFirst = false;
            sb.append(nameValuePair.toString(enc));
        }
        return sb.toString();
    }

    public String toString() {
        try {
            return this.toString("UTF-8");
        }
        catch (UnsupportedEncodingException uex) {
            throw new RuntimeException(uex);
        }
    }
}

