/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import com.Ostermiller.util.CmdLnListener;
import com.Ostermiller.util.CmdLnOption;
import com.Ostermiller.util.CmdLnResult;
import com.Ostermiller.util.ExtraCmdLnArgumentException;
import com.Ostermiller.util.MissingCmdLnArgumentException;
import com.Ostermiller.util.UnknownCmdLnOptionException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CmdLn {
    private String[] arguments;
    private String description;
    private ArrayList<CmdLnOption> options = new ArrayList();
    private HashMap<CmdLnOption, ArrayList<CmdLnResult>> optionsToResults = new HashMap();
    private ArrayList<CmdLnResult> results = new ArrayList();
    private ArrayList<String> leftOverArguments = new ArrayList();
    private HashMap<String, CmdLnOption> longOptions;
    private HashMap<Character, CmdLnOption> shortOptions;
    private LinkedHashSet<String> longOptionsStart = new LinkedHashSet(1);
    private LinkedHashSet<String> shortOptionsStart = new LinkedHashSet(1);
    private HashSet<String> nonOptionSeparators = new HashSet(1);
    private HashSet<Character> optionArgumentDelimiters = new HashSet(3);
    private boolean parsed = false;

    public CmdLn(String[] arguments) {
        if (arguments == null) {
            throw new IllegalArgumentException("Command line arguments cannot be null.");
        }
        for (String argument : arguments) {
            if (argument != null) continue;
            throw new IllegalArgumentException("Each command line argument cannot be null.");
        }
        this.arguments = (String[])arguments.clone();
        this.longOptionsStart.add("--");
        this.shortOptionsStart.add("-");
        this.nonOptionSeparators.add("--");
        this.optionArgumentDelimiters.add(Character.valueOf('='));
        this.optionArgumentDelimiters.add(Character.valueOf(':'));
        this.optionArgumentDelimiters.add(Character.valueOf(' '));
    }

    public CmdLn setOptionArgumentDelimiters(char[] delimiters) {
        this.optionArgumentDelimiters.clear();
        for (char c : delimiters) {
            this.optionArgumentDelimiters.add(Character.valueOf(c));
        }
        return this;
    }

    public CmdLn setOptionStarts(String longOptionsStart, String shortOptionsStart) {
        this.setOptionStarts(new String[]{longOptionsStart}, new String[]{shortOptionsStart});
        return this;
    }

    public CmdLn setOptionStarts(String[] longOptionsStart, String[] shortOptionsStart) {
        this.longOptionsStart.clear();
        if (longOptionsStart != null) {
            for (String optionStart : longOptionsStart) {
                if (optionStart == null) continue;
                if ("".equals(optionStart)) {
                    throw new IllegalArgumentException("long option start cannot be the empty string");
                }
                this.longOptionsStart.add(optionStart);
            }
        }
        this.shortOptionsStart.clear();
        if (shortOptionsStart != null) {
            for (String optionStart : shortOptionsStart) {
                if (optionStart == null) continue;
                if ("".equals(optionStart)) {
                    throw new IllegalArgumentException("short option start cannot be the empty string");
                }
                this.shortOptionsStart.add(optionStart);
            }
        }
        return this;
    }

    public CmdLn setNonOptionSeparators(String[] nonOptionSeparators) {
        this.nonOptionSeparators.clear();
        if (nonOptionSeparators != null) {
            for (String nonOptionSeparator : nonOptionSeparators) {
                this.nonOptionSeparators.add(nonOptionSeparator);
            }
        }
        return this;
    }

    public CmdLn setDescription(String description) {
        this.description = description;
        return this;
    }

    public CmdLn addOptions(Collection<CmdLnOption> options) {
        for (CmdLnOption option : options) {
            this.addOption(option);
        }
        return this;
    }

    public CmdLn addOptions(CmdLnOption[] options) {
        for (CmdLnOption option : options) {
            this.addOption(option);
        }
        return this;
    }

    public CmdLn addOption(CmdLnOption option) {
        if (this.parsed) {
            throw new IllegalStateException("Can no longer add options");
        }
        this.options.add(option);
        return this;
    }

    private CmdLnOption getOption(String s) {
        this.parse();
        return this.longOptions.get(s);
    }

    private CmdLnOption getOption(Character c) {
        this.parse();
        return this.shortOptions.get(c);
    }

    private CmdLnOption getOption(char c) {
        this.parse();
        return this.shortOptions.get(Character.valueOf(c));
    }

    public CmdLnResult getResult(String s) {
        this.parse();
        return this.getResult(this.getOption(s));
    }

    public CmdLnResult getResult(Character c) {
        this.parse();
        return this.getResult(this.getOption(c));
    }

    public CmdLnResult getResult(char c) {
        this.parse();
        return this.getResult(this.getOption(c));
    }

    public CmdLnResult getResult(CmdLnOption option) {
        this.parse();
        if (option == null) {
            return null;
        }
        ArrayList<CmdLnResult> results = this.optionsToResults.get(option);
        if (results == null) {
            return null;
        }
        return results.get(results.size() - 1);
    }

    public List<CmdLnResult> getResults() {
        this.parse();
        return Collections.unmodifiableList(this.results);
    }

    public List<CmdLnResult> getResults(String s) {
        this.parse();
        return this.getResults(this.getOption(s));
    }

    public List<CmdLnResult> getResults(Character c) {
        this.parse();
        return this.getResults(this.getOption(c));
    }

    public List<CmdLnResult> getResults(char c) {
        this.parse();
        return this.getResults(this.getOption(c));
    }

    public List<CmdLnResult> getResults(CmdLnOption option) {
        this.parse();
        if (option == null) {
            return null;
        }
        ArrayList<CmdLnResult> results = this.optionsToResults.get(option);
        if (results == null) {
            return null;
        }
        return Collections.unmodifiableList(results);
    }

    public boolean present(String s) {
        this.parse();
        return this.present(this.getOption(s));
    }

    public boolean present(Character c) {
        this.parse();
        return this.present(this.getOption(c));
    }

    public boolean present(char c) {
        this.parse();
        return this.present(this.getOption(c));
    }

    public boolean present(CmdLnOption option) {
        this.parse();
        if (option == null) {
            return false;
        }
        ArrayList<CmdLnResult> results = this.optionsToResults.get(option);
        return results != null;
    }

    public int occurrences(String s) {
        this.parse();
        return this.occurrences(this.getOption(s));
    }

    public int occurrences(Character c) {
        this.parse();
        return this.occurrences(this.getOption(c));
    }

    public int occurrences(char c) {
        this.parse();
        return this.occurrences(this.getOption(c));
    }

    public int occurrences(CmdLnOption option) {
        this.parse();
        if (option == null) {
            return 0;
        }
        ArrayList<CmdLnResult> results = this.optionsToResults.get(option);
        if (results == null) {
            return 0;
        }
        return results.size();
    }

    public List<String> getNonOptionArguments() {
        this.parse();
        return Collections.unmodifiableList(this.leftOverArguments);
    }

    private void processOptions() {
        this.longOptions = new HashMap();
        this.shortOptions = new HashMap();
        for (CmdLnOption option : this.options) {
            option.setImmutable();
            for (String name : option.getLongNames()) {
                if (this.longOptions.containsKey(name)) {
                    throw new IllegalArgumentException("More than one long option has the name: '" + name + "'");
                }
                this.longOptions.put(name, option);
            }
            for (Character c : option.getShortNames()) {
                if (this.shortOptions.containsKey(c)) {
                    throw new IllegalArgumentException("More than one short option has the character: '" + c + "'");
                }
                this.shortOptions.put(c, option);
            }
        }
    }

    private String getLongOptionName(String argument) {
        if (this.shortOptionsStart.contains(argument) || this.longOptionsStart.contains(argument)) {
            return null;
        }
        for (String optionStart : this.longOptionsStart) {
            if (!argument.startsWith(optionStart)) continue;
            return argument.substring(optionStart.length());
        }
        return null;
    }

    private String getShortOptionName(String sArgument) {
        if (this.shortOptionsStart.contains(sArgument) || this.longOptionsStart.contains(sArgument)) {
            return null;
        }
        for (String optionStart : this.shortOptionsStart) {
            if (!sArgument.startsWith(optionStart)) continue;
            return sArgument.substring(optionStart.length());
        }
        return null;
    }

    private void addResult(CmdLnResult result) {
        ArrayList<CmdLnResult> results = this.optionsToResults.get(result.getOption());
        if (results == null) {
            results = new ArrayList(1);
            this.optionsToResults.put(result.getOption(), results);
        }
        results.add(result);
        this.results.add(result);
    }

    private int getIndexOfDelimiter(String argument) {
        int index = -1;
        for (Character delimiter : this.optionArgumentDelimiters) {
            int i = argument.indexOf(delimiter.charValue());
            if (i <= 0 || index != -1 && i >= index) continue;
            index = i;
        }
        return index;
    }

    private void runThroughArguments() {
        CmdLnResult lastResult = null;
        String optionName = null;
        boolean seenNonOptionSeparator = false;
        for (String argument : this.arguments) {
            int delimiterIndex;
            if (seenNonOptionSeparator) {
                this.leftOverArguments.add(argument);
                continue;
            }
            if (this.nonOptionSeparators.contains(argument)) {
                seenNonOptionSeparator = true;
                continue;
            }
            optionName = this.getLongOptionName(argument);
            if (optionName != null) {
                CmdLnOption option;
                delimiterIndex = this.getIndexOfDelimiter(optionName);
                String optionArgument = null;
                if (delimiterIndex > 0) {
                    optionArgument = optionName.substring(delimiterIndex + 1);
                    optionName = optionName.substring(0, delimiterIndex);
                }
                if ((option = this.longOptions.get(optionName)) == null) {
                    throw new UnknownCmdLnOptionException().setArgument(argument).setOption(optionName);
                }
                lastResult = new CmdLnResult(option);
                this.addResult(lastResult);
                if (optionArgument == null) continue;
                if (lastResult.hasAllArguments()) {
                    throw new ExtraCmdLnArgumentException().setResult(lastResult);
                }
                lastResult.addArgument(optionArgument);
                continue;
            }
            optionName = this.getShortOptionName(argument);
            if (optionName != null) {
                delimiterIndex = this.getIndexOfDelimiter(optionName);
                for (int i = 0; i < optionName.length(); ++i) {
                    Character c = Character.valueOf(optionName.charAt(i));
                    CmdLnOption option = this.shortOptions.get(c);
                    if (option == null) {
                        throw new UnknownCmdLnOptionException().setArgument(argument).setOption(Character.toString(c.charValue()));
                    }
                    lastResult = new CmdLnResult(option);
                    this.addResult(lastResult);
                    if (delimiterIndex != i + 1) continue;
                    String optionArgument = optionName.substring(delimiterIndex + 1);
                    if (lastResult.hasAllArguments()) {
                        throw new ExtraCmdLnArgumentException().setResult(lastResult);
                    }
                    lastResult.addArgument(optionArgument);
                    i = optionName.length();
                }
                continue;
            }
            if (lastResult != null && !lastResult.hasAllArguments()) {
                lastResult.addArgument(argument);
                continue;
            }
            this.leftOverArguments.add(argument);
        }
    }

    public void parse() {
        if (this.parsed) {
            return;
        }
        this.parsed = true;
        this.processOptions();
        this.runThroughArguments();
        this.ensureOptionsSatisfied();
        this.callListeners();
    }

    private void ensureOptionsSatisfied() {
        for (CmdLnResult result : this.results) {
            if (!result.requiresMoreArguments()) continue;
            throw new MissingCmdLnArgumentException().setResult(result);
        }
    }

    private void callListeners() {
        for (CmdLnResult result : this.results) {
            CmdLnListener callback = result.getOption().getListener();
            if (callback == null) continue;
            callback.found(result);
        }
    }

    String getFirstLongOptionsStart() {
        if (this.longOptionsStart.size() == 0) {
            return null;
        }
        return (String)this.longOptionsStart.iterator().next();
    }

    String getFirstShortOptionsStart() {
        if (this.shortOptionsStart.size() == 0) {
            return null;
        }
        return (String)this.shortOptionsStart.iterator().next();
    }

    public String getHelp() {
        StringWriter out = new StringWriter();
        this.printHelp(out);
        return out.toString();
    }

    public void printHelp() {
        this.printHelp(System.out);
    }

    public void printHelp(OutputStream out) {
        this.printHelp(new PrintWriter(new OutputStreamWriter(out)));
    }

    public void printHelp(Writer out) {
        this.printHelp(new PrintWriter(out));
    }

    public void printHelp(PrintWriter out) {
        this.printHelp(out, 20, 80);
    }

    public String getHelp(int indent, int width) {
        StringWriter out = new StringWriter();
        this.printHelp(out, indent, width);
        return out.toString();
    }

    public void printHelp(int indent, int width) {
        this.printHelp(System.out, indent, width);
    }

    public void printHelp(OutputStream out, int indent, int width) {
        this.printHelp(new PrintWriter(new OutputStreamWriter(out)), indent, width);
    }

    public void printHelp(Writer out, int indent, int width) {
        this.printHelp(new PrintWriter(out), indent, width);
    }

    public void printHelp(PrintWriter out, int indent, int width) {
        this.parse();
        String shortOptionsStart = this.getFirstShortOptionsStart();
        String longOptionsStart = this.getFirstLongOptionsStart();
        if (this.description != null) {
            out.println(this.description);
        }
        int maxIndent = 0;
        for (CmdLnOption option : this.options) {
            int optionIndent = option.getHelpArgumentsLength(longOptionsStart, shortOptionsStart);
            if (optionIndent <= maxIndent) continue;
            maxIndent = optionIndent;
        }
        if (maxIndent < indent) {
            indent = maxIndent;
        }
        for (CmdLnOption option : this.options) {
            String optionHelp = option.getHelp(longOptionsStart, shortOptionsStart, indent, width);
            if (optionHelp == null) continue;
            out.println(optionHelp);
        }
        out.flush();
    }
}

