/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import com.Ostermiller.util.CmdLnListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CmdLnOption {
    private List<String> longNames;
    private List<Character> shortNames;
    private int minArguments = 0;
    private int maxArguments = 0;
    private boolean mutable = true;
    private String description = null;
    private CmdLnListener callback;
    private Object userObject;

    public CmdLnOption(String[] longNames) {
        this(longNames, null);
    }

    public CmdLnOption(char[] shortNames) {
        this(null, shortNames);
    }

    public CmdLnOption(String longName) {
        this(longName, null);
    }

    public CmdLnOption(Character shortName) {
        this(null, shortName);
    }

    public CmdLnOption(String[] longNames, char[] shortNames) {
        if (!(longNames != null && longNames.length != 0 || shortNames != null && shortNames.length != 0)) {
            throw new IllegalArgumentException("At least one long name or short name must be specified");
        }
        if (longNames == null) {
            this.longNames = new ArrayList<String>(0);
        } else {
            this.longNames = new ArrayList<String>(longNames.length);
            this.addLongNames(longNames);
        }
        if (shortNames == null) {
            this.shortNames = new ArrayList<Character>(0);
        } else {
            this.shortNames = new ArrayList<Character>(shortNames.length);
            this.addShortNames(shortNames);
        }
    }

    public CmdLnOption(String longName, Character shortName) {
        if (longName == null && shortName == null) {
            throw new IllegalArgumentException("A long name or short name must be specified");
        }
        if (longName == null) {
            this.longNames = new ArrayList<String>(0);
        } else {
            this.longNames = new ArrayList<String>(1);
            this.addLongName(longName);
        }
        if (shortName == null) {
            this.shortNames = new ArrayList<Character>(0);
        } else {
            this.shortNames = new ArrayList<Character>(1);
            this.addShortName(shortName);
        }
    }

    void setImmutable() {
        if (!this.mutable) {
            throw new IllegalStateException("Command line argument already immutable (Used by more than one CommandLineOption?)");
        }
        this.mutable = false;
    }

    private void checkState() {
        if (!this.mutable) {
            throw new IllegalStateException("option no longer modifiable");
        }
    }

    public CmdLnOption setNoArguments() {
        this.setArgumentBounds(0, 0);
        return this;
    }

    public CmdLnOption setOptionalArgument() {
        this.setArgumentBounds(0, 1);
        return this;
    }

    public CmdLnOption setRequiredArgument() {
        this.setArgumentBounds(1, 1);
        return this;
    }

    public CmdLnOption setUnlimitedArguments() {
        this.setArgumentBounds(0, Integer.MAX_VALUE);
        return this;
    }

    public CmdLnOption setArgumentBounds(int minArguments, int maxArguments) {
        this.checkState();
        if (minArguments < 0) {
            throw new IllegalArgumentException("min arguments cannot be negative");
        }
        if (maxArguments < minArguments) {
            throw new IllegalArgumentException("max arguments cannot be less than min arguments");
        }
        this.minArguments = minArguments;
        this.maxArguments = maxArguments;
        return this;
    }

    public CmdLnOption addLongNames(Collection<String> longNames) {
        this.checkState();
        for (String name : longNames) {
            this.addLongName(name);
        }
        return this;
    }

    public CmdLnOption addLongNames(String[] longNames) {
        this.checkState();
        for (String name : longNames) {
            this.addLongName(name);
        }
        return this;
    }

    public CmdLnOption addLongName(String name) {
        this.checkState();
        if (name == null) {
            throw new IllegalArgumentException("long name cannot be null");
        }
        if ("".equals(name)) {
            throw new IllegalArgumentException("long name cannot be blank");
        }
        this.longNames.add(name);
        return this;
    }

    public CmdLnOption addShortNames(Collection<Character> shortNames) {
        this.checkState();
        for (Character name : shortNames) {
            this.addShortName(name);
        }
        return this;
    }

    public CmdLnOption addShortNames(char[] shortNames) {
        this.checkState();
        for (char name : shortNames) {
            this.addShortName(Character.valueOf(name));
        }
        return this;
    }

    public CmdLnOption addShortNames(Character[] shortNames) {
        this.checkState();
        Character[] arr$ = shortNames;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            char name = arr$[i$].charValue();
            this.addShortName(Character.valueOf(name));
        }
        return this;
    }

    public CmdLnOption addShortName(Character name) {
        this.checkState();
        if (name == null) {
            throw new IllegalArgumentException("short name cannot be null");
        }
        if ("".equals(name)) {
            throw new IllegalArgumentException("short name cannot be blank");
        }
        this.shortNames.add(name);
        return this;
    }

    String getLongName() {
        if (this.longNames.size() > 1) {
            return null;
        }
        return this.longNames.get(0);
    }

    List<String> getLongNames() {
        return Collections.unmodifiableList(this.longNames);
    }

    Character getShortName() {
        if (this.shortNames.size() > 1) {
            return null;
        }
        return this.shortNames.get(0);
    }

    List<Character> getShortNames() {
        return Collections.unmodifiableList(this.shortNames);
    }

    int getMinArguments() {
        return this.minArguments;
    }

    int getMaxArguments() {
        return this.maxArguments;
    }

    int getHelpArgumentsLength(String longStart, String shortStart) {
        if (this.description == null) {
            return 0;
        }
        int length = 1;
        if (shortStart != null && this.shortNames.size() > 0) {
            ++length;
            length += shortStart.length();
            ++length;
        }
        if (longStart != null && this.longNames.size() > 0) {
            ++length;
            length += longStart.length();
            length += this.longNames.get(0).length();
        }
        if (this.getMaxArguments() > 0) {
            length += 4;
        }
        return length += 3;
    }

    String getHelp(String longStart, String shortStart, int indent, int lineWidth) {
        if (this.description == null) {
            return null;
        }
        int expectedLength = 32;
        StringBuffer sb = new StringBuffer(expectedLength += this.description.length());
        sb.append(" ");
        if (shortStart != null && this.shortNames.size() > 0) {
            sb.append(" ").append(shortStart).append(this.shortNames.get(0));
        }
        if (longStart != null && this.longNames.size() > 0) {
            sb.append(" ").append(longStart).append(this.longNames.get(0));
        }
        if (this.getMaxArguments() > 0) {
            sb.append(" ").append("<?>");
        }
        while (indent > sb.length() + 2) {
            sb.append(" ");
        }
        sb.append("  ");
        int descriptionIndex = 0;
        int charactersLeft = lineWidth - sb.length();
        int lineNumber = 1;
        while (descriptionIndex < this.description.length()) {
            int endIndex = descriptionIndex + charactersLeft;
            if (endIndex > this.description.length()) {
                endIndex = this.description.length();
            } else if (this.description.charAt(endIndex) != ' ') {
                endIndex = this.description.lastIndexOf(32, endIndex) > descriptionIndex ? this.description.lastIndexOf(32, endIndex) : (this.description.indexOf(32, endIndex) != -1 ? this.description.lastIndexOf(32, endIndex) : this.description.length());
            }
            if (lineNumber != 1) {
                sb.append("\n        ");
            }
            sb.append(this.description.substring(descriptionIndex, endIndex).trim());
            descriptionIndex = endIndex + 1;
            charactersLeft = lineWidth - 8;
            ++lineNumber;
        }
        return sb.toString();
    }

    public String toString() {
        if (this.longNames.size() > 0) {
            return this.longNames.get(0);
        }
        return this.shortNames.get(0).toString();
    }

    CmdLnListener getListener() {
        return this.callback;
    }

    public CmdLnOption setListener(CmdLnListener callback) {
        this.callback = callback;
        return this;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public CmdLnOption setUserObject(Object userObject) {
        this.userObject = userObject;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public CmdLnOption setDescription(String description) {
        this.description = description;
        return this;
    }
}

