/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

public final class ExecHelper {
    private String output;
    private String error;
    private int status;

    public static ExecHelper exec(String[] cmdarray) throws IOException {
        return new ExecHelper(Runtime.getRuntime().exec(cmdarray), null);
    }

    public static ExecHelper exec(String[] cmdarray, String[] envp) throws IOException {
        return new ExecHelper(Runtime.getRuntime().exec(cmdarray, envp), null);
    }

    public static ExecHelper exec(String[] cmdarray, String[] envp, File dir) throws IOException {
        return new ExecHelper(Runtime.getRuntime().exec(cmdarray, envp, dir), null);
    }

    public static ExecHelper exec(String[] cmdarray, String charset) throws IOException {
        return new ExecHelper(Runtime.getRuntime().exec(cmdarray), charset);
    }

    public static ExecHelper exec(String[] cmdarray, String[] envp, String charset) throws IOException {
        return new ExecHelper(Runtime.getRuntime().exec(cmdarray, envp), charset);
    }

    public static ExecHelper exec(String[] cmdarray, String[] envp, File dir, String charset) throws IOException {
        return new ExecHelper(Runtime.getRuntime().exec(cmdarray, envp, dir), charset);
    }

    public static ExecHelper execUsingShell(String command) throws IOException {
        return ExecHelper.execUsingShell(command, null);
    }

    public static ExecHelper execUsingShell(String command, String charset) throws IOException {
        if (command == null) {
            throw new NullPointerException();
        }
        String os = System.getProperty("os.name");
        String[] cmdarray = os.equals("Windows 95") || os.equals("Windows 98") || os.equals("Windows ME") ? new String[]{"command.exe", "/C", command} : (os.startsWith("Windows") ? new String[]{"cmd.exe", "/C", command} : new String[]{"/bin/sh", "-c", command});
        return new ExecHelper(Runtime.getRuntime().exec(cmdarray), charset);
    }

    private ExecHelper(Process process, String charset) throws IOException {
        InputStreamReader stderr;
        InputStreamReader stdout;
        StringBuffer output = new StringBuffer();
        StringBuffer error = new StringBuffer();
        if (charset == null) {
            stdout = new InputStreamReader(process.getInputStream());
            stderr = new InputStreamReader(process.getErrorStream());
        } else {
            stdout = new InputStreamReader(process.getInputStream(), charset);
            stderr = new InputStreamReader(process.getErrorStream(), charset);
        }
        char[] buffer = new char[1024];
        boolean done = false;
        boolean stdoutclosed = false;
        boolean stderrclosed = false;
        while (!done) {
            int read;
            boolean readSomething = false;
            if (!stdoutclosed && ((Reader)stdout).ready()) {
                readSomething = true;
                read = ((Reader)stdout).read(buffer, 0, buffer.length);
                if (read < 0) {
                    readSomething = true;
                    stdoutclosed = true;
                } else if (read > 0) {
                    readSomething = true;
                    output.append(buffer, 0, read);
                }
            }
            if (!stderrclosed && ((Reader)stderr).ready()) {
                read = ((Reader)stderr).read(buffer, 0, buffer.length);
                if (read < 0) {
                    readSomething = true;
                    stderrclosed = true;
                } else if (read > 0) {
                    readSomething = true;
                    error.append(buffer, 0, read);
                }
            }
            if (readSomething) continue;
            try {
                this.status = process.exitValue();
                done = true;
            }
            catch (IllegalThreadStateException itx) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ix) {
                    process.destroy();
                    throw new IOException("Interrupted - processes killed");
                }
            }
        }
        this.output = output.toString();
        this.error = error.toString();
    }

    public String getOutput() {
        return this.output;
    }

    public String getError() {
        return this.error;
    }

    public int getStatus() {
        return this.status;
    }
}

