/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.util;

import java.util.HashSet;
import java.util.LinkedList;

public class Parallelizer {
    public static final int INFINITE_THREAD_LIMIT = 0;
    private int concurrentThreadLimit = 0;
    private HashSet<Thread> runningThreads = new HashSet();
    private LinkedList<Thread> toRunQueue = new LinkedList();
    private static int threadNameCount = 0;
    private LinkedList<RuntimeException> exceptionList = new LinkedList();
    private LinkedList<Error> errorList = new LinkedList();

    public Parallelizer() {
        this(0);
    }

    public Parallelizer(int concurrentThreadLimit) {
        if (concurrentThreadLimit < 0) {
            throw new IllegalArgumentException("Bad concurrent thread limit: " + concurrentThreadLimit);
        }
        this.concurrentThreadLimit = concurrentThreadLimit;
    }

    public void run(Runnable job) {
        this.run(null, job, null, 0L);
    }

    public void run(Runnable job, String threadName) {
        this.run(null, job, threadName, 0L);
    }

    public void run(ThreadGroup threadGroup, Runnable job) {
        this.run(threadGroup, job, null, 0L);
    }

    public void run(ThreadGroup threadGroup, Runnable job, String threadName) {
        this.run(threadGroup, job, threadName, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ThreadGroup threadGroup, final Runnable job, String threadName, long stackSize) {
        this.throwFirstError();
        Runnable jobWrapper = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    job.run();
                }
                catch (RuntimeException runtimeException) {
                    HashSet hashSet = Parallelizer.this.runningThreads;
                    synchronized (hashSet) {
                        Parallelizer.this.exceptionList.add(runtimeException);
                    }
                }
                catch (Error error) {
                    HashSet hashSet = Parallelizer.this.runningThreads;
                    synchronized (hashSet) {
                        Parallelizer.this.errorList.add(error);
                    }
                }
                finally {
                    HashSet runtimeException = Parallelizer.this.runningThreads;
                    synchronized (runtimeException) {
                        Parallelizer.this.runningThreads.remove(Thread.currentThread());
                        Parallelizer.this.runningThreads.notifyAll();
                    }
                    Parallelizer.this.startAJobIfNeeded();
                }
            }
        };
        threadName = Parallelizer.getNextThreadName(threadName);
        HashSet<Thread> hashSet = this.runningThreads;
        synchronized (hashSet) {
            this.toRunQueue.add(new Thread(threadGroup, jobWrapper, threadName, stackSize));
        }
        this.startAJobIfNeeded();
    }

    private static String getNextThreadName(String threadName) {
        if (threadName != null) {
            return threadName;
        }
        return "Parallelizer-" + threadNameCount++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void throwFirstException() {
        HashSet<Thread> hashSet = this.runningThreads;
        synchronized (hashSet) {
            if (this.exceptionList.size() > 0) {
                throw this.exceptionList.removeFirst();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void throwFirstError() throws Error {
        HashSet<Thread> hashSet = this.runningThreads;
        synchronized (hashSet) {
            if (this.errorList.size() > 0) {
                throw this.errorList.removeFirst();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAJobIfNeeded() {
        HashSet<Thread> hashSet = this.runningThreads;
        synchronized (hashSet) {
            if (this.concurrentThreadLimit != 0 && this.runningThreads.size() >= this.concurrentThreadLimit) {
                return;
            }
            if (this.toRunQueue.size() == 0) {
                return;
            }
            Thread thread = this.toRunQueue.removeFirst();
            this.runningThreads.add(thread);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean done() {
        this.throwFirstError();
        HashSet<Thread> hashSet = this.runningThreads;
        synchronized (hashSet) {
            return this.toRunQueue.size() + this.runningThreads.size() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        this.throwFirstError();
        HashSet<Thread> hashSet = this.runningThreads;
        synchronized (hashSet) {
            for (Thread thread : this.runningThreads) {
                thread.interrupt();
                this.throwFirstError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpStack() {
        this.throwFirstError();
        HashSet<Thread> hashSet = this.runningThreads;
        synchronized (hashSet) {
            for (Thread thread : this.runningThreads) {
                for (StackTraceElement stackTraceElement : thread.getStackTrace()) {
                    System.out.println(stackTraceElement.toString());
                }
                this.throwFirstError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread[] getRunningThreads() {
        this.throwFirstError();
        HashSet<Thread> hashSet = this.runningThreads;
        synchronized (hashSet) {
            return this.runningThreads.toArray(new Thread[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() throws InterruptedException {
        while (!this.done()) {
            HashSet<Thread> hashSet = this.runningThreads;
            synchronized (hashSet) {
                this.throwFirstException();
                this.runningThreads.wait();
                this.throwFirstError();
                this.throwFirstException();
            }
        }
    }
}

