/*
 * Decompiled with CFR 0.152.
 */
package sum.strukturen;

import java.io.Serializable;
import sum.strukturen.Schluesselobjekt;
import sum.werkzeuge.Rechner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hashtabelle<Typ extends Schluesselobjekt>
implements Serializable {
    static final long serialVersionUID = 8311777060802L;
    private Rechner hatRechner;
    private Object hatGeloescht;
    private Object[] zFeld;
    private int zGroesse;
    private int zAnzahl;

    public Hashtabelle() {
        this.zGroesse = 11;
        this.zFeld = new Object[this.zGroesse];
        this.hatRechner = new Rechner();
        this.hatGeloescht = new Object();
        this.zAnzahl = 0;
    }

    public Hashtabelle(int pGroesse) {
        this.zGroesse = pGroesse;
        this.zFeld = new Object[this.zGroesse];
        this.hatRechner = new Rechner();
        this.hatGeloescht = new Object();
        this.zAnzahl = 0;
    }

    private int h(Object pObject) {
        int lHashcode = pObject.hashCode();
        return this.hatRechner.betrag(lHashcode) % this.zGroesse;
    }

    public void fuegeEin(Schluesselobjekt pSchluesselobjekt) {
        if (this.suche(pSchluesselobjekt.schluessel()) == null) {
            int lPosition = this.h(pSchluesselobjekt.schluessel());
            while (!this.leer(lPosition) && !this.geloescht(lPosition)) {
                ++lPosition;
                lPosition %= this.zGroesse;
            }
            this.zFeld[lPosition] = pSchluesselobjekt;
            ++this.zAnzahl;
            if ((double)this.zAnzahl / 0.75 > (double)this.zGroesse) {
                this.rehash();
            }
        }
    }

    public String toString() {
        String lString = "";
        for (int i = 0; i < this.zGroesse; ++i) {
            if (this.leer(i)) {
                lString = lString + "leer\n";
                continue;
            }
            if (this.geloescht(i)) {
                lString = lString + "gel&ouml;scht\n";
                continue;
            }
            Schluesselobjekt lSchluesselobjekt = (Schluesselobjekt)this.zFeld[i];
            lString = lString + this.zFeld[i].toString() + " (" + lSchluesselobjekt.schluessel().hashCode() + " )\n";
        }
        return lString;
    }

    private boolean leer(int pPosition) {
        return this.zFeld[pPosition] == null;
    }

    private boolean geloescht(int pPosition) {
        return this.zFeld[pPosition].equals(this.hatGeloescht);
    }

    public void loesche(Object pSchluessel) {
        boolean lGefunden = false;
        int lPosition = this.h(pSchluessel);
        while (!this.leer(lPosition) && !lGefunden) {
            if (!this.geloescht(lPosition)) {
                Schluesselobjekt lSchluesselobjekt = (Schluesselobjekt)this.zFeld[lPosition];
                lGefunden = lSchluesselobjekt.schluessel().equals(pSchluessel);
            }
            if (lGefunden) continue;
            ++lPosition;
            lPosition %= this.zGroesse;
        }
        if (lGefunden) {
            this.zFeld[lPosition] = this.hatGeloescht;
            --this.zAnzahl;
        }
    }

    public Typ suche(Object pSchluessel) {
        boolean lGefunden = false;
        int lPosition = this.h(pSchluessel);
        while (!this.leer(lPosition) && !lGefunden) {
            if (!this.geloescht(lPosition)) {
                Schluesselobjekt lSchluesselobjekt = (Schluesselobjekt)this.zFeld[lPosition];
                lGefunden = lSchluesselobjekt.schluessel().equals(pSchluessel);
            }
            if (lGefunden) continue;
            ++lPosition;
            lPosition %= this.zGroesse;
        }
        if (lGefunden) {
            return (Typ)((Schluesselobjekt)this.zFeld[lPosition]);
        }
        return null;
    }

    private void rehash() {
        Object[] lAltesFeld = this.zFeld;
        int lAlteGroesse = this.zGroesse;
        this.zGroesse = this.zGroesse * 2 + 1;
        this.zFeld = new Object[this.zGroesse];
        this.zAnzahl = 0;
        for (int i = 0; i < lAlteGroesse; ++i) {
            if (lAltesFeld[i] == null || lAltesFeld[i].equals(this.hatGeloescht)) continue;
            Schluesselobjekt lSchluesselobjekt = (Schluesselobjekt)lAltesFeld[i];
            this.fuegeEin(lSchluesselobjekt);
        }
    }

    public void entferneAlleElemente() {
        for (int i = 0; i < this.zGroesse; ++i) {
            this.zFeld[i] = null;
        }
        this.zAnzahl = 0;
    }
}

