/*
 * Decompiled with CFR 0.152.
 */
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.geom.Line2D;
import javax.media.j3d.Alpha;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Light;
import javax.media.j3d.Material;
import javax.media.j3d.PointLight;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Shape3D;
import javax.media.j3d.SpotLight;
import javax.media.j3d.Text3D;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class Animation
extends JPanel {
    private static final long serialVersionUID = 4736196693696740998L;
    private static final int DIRECTIONAL_LIGHT = 0;
    private static final int POINT_LIGHT = 1;
    private static final int SPOT_LIGHT = 2;
    private static int lightType = 1;
    private JPanel drawingPanel;
    TransformGroup objScale;
    private SimpleUniverse univ = null;
    private BranchGroup scene = null;
    static TransformGroup TransfMoon;
    RotationInterpolator rotatorEarth;

    public BranchGroup createSceneGraph() {
        Color3f moonColor = new Color3f(0.1f, 0.1f, 0.1f);
        Color3f emismoonColor = new Color3f(0.3f, 0.3f, 0.3f);
        Color3f specmoonColor = new Color3f(1.0f, 1.0f, 1.0f);
        Color3f lColor2 = new Color3f(1.0f, 1.0f, 0.4f);
        Color3f alColor = new Color3f(0.3f, 0.3f, 0.3f);
        Color3f bgColor = new Color3f(0.05f, 0.05f, 0.1f);
        BranchGroup objRoot = new BranchGroup();
        this.objScale = new TransformGroup();
        Transform3D t3d = new Transform3D();
        t3d.setScale(0.4);
        this.objScale.setTransform(t3d);
        objRoot.addChild(this.objScale);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        Background bg = new Background(bgColor);
        bg.setApplicationBounds(bounds);
        this.objScale.addChild(bg);
        AmbientLight aLgt = new AmbientLight(alColor);
        aLgt.setInfluencingBounds(bounds);
        this.objScale.addChild(aLgt);
        Color3f black = new Color3f(0.2f, 0.2f, 0.2f);
        Color3f blue = new Color3f(0.4f, 0.4f, 0.75f);
        TextureLoader loader = new TextureLoader("images/Earth.jpg", "RGB", (Component)new Container());
        Texture texture = loader.getTexture();
        texture.setBoundaryModeS(3);
        texture.setBoundaryModeT(3);
        texture.setBoundaryColor(new Color4f(0.0f, 1.0f, 0.0f, 0.0f));
        TextureAttributes texAttr = new TextureAttributes();
        texAttr.setTextureMode(2);
        TransformGroup EarthRotation = new TransformGroup();
        EarthRotation.setCapability(18);
        this.objScale.addChild(EarthRotation);
        Transform3D tr = new Transform3D();
        Vector3d posEarth = new Vector3d(0.0, 0.0, 0.0);
        tr.set(posEarth);
        tr.rotX(1.5707963267948966);
        TransformGroup tgEarth = new TransformGroup(tr);
        EarthRotation.addChild(tgEarth);
        Appearance a = new Appearance();
        a.setTexture(texture);
        a.setTextureAttributes(texAttr);
        a.setMaterial(new Material(blue, black, blue, black, 1.0f));
        int primflags = 3;
        Sphere sph = new Sphere(0.8f, primflags, 80, a);
        tgEarth.addChild(sph);
        Transform3D axisRot = new Transform3D();
        axisRot.rotX(1.5707963267948966);
        Alpha earthAlpha = new Alpha(-1, 1, 0L, 0L, 1034L, 0L, 0L, 0L, 0L, 0L);
        this.rotatorEarth = new RotationInterpolator(earthAlpha, EarthRotation, axisRot, 0.0f, (float)Math.PI * 2);
        this.rotatorEarth.setSchedulingBounds(bounds);
        EarthRotation.addChild(this.rotatorEarth);
        TransformGroup lMoonRotTrans = new TransformGroup();
        lMoonRotTrans.setCapability(18);
        lMoonRotTrans.setCapability(13);
        lMoonRotTrans.setCapability(14);
        this.objScale.addChild(lMoonRotTrans);
        BranchGroup moonBG = new BranchGroup();
        moonBG.setCapability(17);
        moonBG.setCapability(14);
        lMoonRotTrans.addChild(moonBG);
        Transform3D tm = new Transform3D();
        Vector3d lPosMoon = new Vector3d(1.5, 0.0, 0.0);
        tm.set(lPosMoon);
        TransfMoon = new TransformGroup(tm);
        TransfMoon.setCapability(13);
        TransfMoon.setCapability(18);
        TransfMoon.setCapability(14);
        moonBG.addChild(TransfMoon);
        Appearance appMoon = new Appearance();
        Material mMoon = new Material(moonColor, emismoonColor, moonColor, specmoonColor, 5.0f);
        mMoon.setLightingEnable(true);
        appMoon.setMaterial(mMoon);
        TransfMoon.addChild(new Sphere(0.15f, 1, 80, appMoon));
        Transform3D ts = new Transform3D();
        Vector3d lPosSun = new Vector3d(10.2, 0.0, 0.0);
        ts.set(lPosSun);
        TransformGroup TransfSun = new TransformGroup(ts);
        this.objScale.addChild(TransfSun);
        ColoringAttributes caLSun = new ColoringAttributes();
        caLSun.setColor(lColor2);
        Appearance appL2 = new Appearance();
        appL2.setColoringAttributes(caLSun);
        TransfSun.addChild(new Sphere(7.5f, 1, 80, appL2));
        Light lgtSun = null;
        Point3f lPoint = new Point3f(0.0f, 0.0f, 0.0f);
        Point3f atten = new Point3f(0.5f, 0.0f, 0.0f);
        Vector3f lDirect2 = new Vector3f(lPosSun);
        lDirect2.negate();
        switch (lightType) {
            case 0: {
                lgtSun = new DirectionalLight(lColor2, lDirect2);
                break;
            }
            case 1: {
                lgtSun = new PointLight(lColor2, lPoint, atten);
                break;
            }
            case 2: {
                lgtSun = new SpotLight(lColor2, lPoint, atten, lDirect2, 0.43633232f, 10.0f);
            }
        }
        lgtSun.setInfluencingBounds(bounds);
        TransfSun.addChild(lgtSun);
        Transform3D tr4 = new Transform3D();
        tr4.setScale(0.1);
        TransformGroup TG = new TransformGroup(tr4);
        this.objScale.addChild(TG);
        this.addTextGraph(TG, "New Moon", new Vector3d(17.0, 0.0, 0.0));
        this.addTextGraph(TG, "Waxing Crescent", new Vector3d(12.0, 12.0, 0.0));
        this.addTextGraph(TG, "First Quarter", new Vector3d(-2.5, 17.0, 0.0));
        this.addTextGraph(TG, "Waxing Gibbous", new Vector3d(-19.0, 12.0, 0.0));
        this.addTextGraph(TG, "Full Moon", new Vector3d(-22.0, 0.0, 0.0));
        this.addTextGraph(TG, "Waning Gibbous", new Vector3d(-19.0, -13.0, 0.0));
        this.addTextGraph(TG, "Third Quarter", new Vector3d(-2.5, -18.0, 0.0));
        this.addTextGraph(TG, "Waning Crescent", new Vector3d(12.0, -13.0, 0.0));
        objRoot.compile();
        return objRoot;
    }

    private void addTextGraph(TransformGroup TrGr, String text, Vector3d position) {
        Appearance a4 = new Appearance();
        ColoringAttributes caLTxt = new ColoringAttributes();
        caLTxt.setColor(new Color3f(0.3f, 0.3f, 0.3f));
        a4.setColoringAttributes(caLTxt);
        Line2D.Double extrusionShape = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
        Font3D f3d = new Font3D(new Font("Full Moon", 0, 1), new FontExtrusion(extrusionShape));
        Text3D txt1 = new Text3D(f3d, text, new Point3f((float)position.x, (float)position.y, (float)position.z));
        Shape3D s3D1 = new Shape3D();
        s3D1.setGeometry(txt1);
        s3D1.setAppearance(a4);
        TrGr.addChild(s3D1);
    }

    private Canvas3D createUniverse() {
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D c = new Canvas3D(config);
        this.univ = new SimpleUniverse(c);
        this.univ.getViewingPlatform().setNominalViewingTransform();
        this.univ.getViewer().getView().setMinimumFrameCycleTime(5L);
        return c;
    }

    public Animation() {
        this.initComponents();
        Canvas3D c = this.createUniverse();
        this.drawingPanel.add((Component)c, "Center");
        this.scene = this.createSceneGraph();
        this.univ.addBranchGraph(this.scene);
    }

    public void stopAnimation() {
        this.rotatorEarth.getAlpha().pause();
    }

    public void setMoonPosition(Vector3d pos) {
        Transform3D tm = new Transform3D();
        tm.set(pos);
        TransfMoon.setTransform(tm);
    }

    public Vector3d getMoonPosition() {
        Vector3d position = new Vector3d();
        Transform3D t1 = new Transform3D();
        TransfMoon.getTransform(t1);
        t1.get(position);
        return position;
    }

    public void startAnimation() {
        this.rotatorEarth.getAlpha().resume();
    }

    private void initComponents() {
        this.drawingPanel = new JPanel();
        this.drawingPanel.setLayout(new BorderLayout());
        this.drawingPanel.setPreferredSize(new Dimension(800, 600));
        this.add((Component)this.drawingPanel, "Center");
    }
}

