/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.mouse;

import com.sun.j3d.utils.behaviors.mouse.MouseBehavior;
import com.sun.j3d.utils.behaviors.mouse.MouseBehaviorCallback;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.vecmath.Vector3d;

public class MouseWheelZoom
extends MouseBehavior {
    double z_factor = 0.1;
    Vector3d translation = new Vector3d();
    private MouseBehaviorCallback callback = null;

    public MouseWheelZoom(TransformGroup transformGroup) {
        super(transformGroup);
    }

    public MouseWheelZoom() {
        super(0);
    }

    public MouseWheelZoom(int n) {
        super(n);
    }

    public MouseWheelZoom(Component component) {
        super(component, 0);
    }

    public MouseWheelZoom(Component component, TransformGroup transformGroup) {
        super(component, transformGroup);
    }

    public MouseWheelZoom(Component component, int n) {
        super(component, n);
    }

    public void initialize() {
        super.initialize();
        if ((this.flags & 2) == 2) {
            this.z_factor *= -1.0;
            this.invert = true;
        }
    }

    public double getFactor() {
        return this.z_factor;
    }

    public void setFactor(double d) {
        this.z_factor = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStimulus(Enumeration enumeration) {
        block3: while (enumeration.hasMoreElements()) {
            MouseEvent mouseEvent;
            WakeupCriterion wakeupCriterion = (WakeupCriterion)enumeration.nextElement();
            if (wakeupCriterion instanceof WakeupOnAWTEvent) {
                AWTEvent[] aWTEventArray = ((WakeupOnAWTEvent)wakeupCriterion).getAWTEvent();
                if (aWTEventArray.length <= 0) continue;
                mouseEvent = (MouseEvent)aWTEventArray[aWTEventArray.length - 1];
                this.doProcess(mouseEvent);
                continue;
            }
            if (!(wakeupCriterion instanceof WakeupOnBehaviorPost)) continue;
            while (true) {
                LinkedList linkedList = this.mouseq;
                synchronized (linkedList) {
                    if (this.mouseq.isEmpty()) {
                        continue block3;
                    }
                    mouseEvent = (MouseEvent)this.mouseq.remove(0);
                    while (mouseEvent.getID() == 507 && !this.mouseq.isEmpty() && ((MouseEvent)this.mouseq.get(0)).getID() == 507) {
                        mouseEvent = (MouseEvent)this.mouseq.remove(0);
                    }
                }
                this.doProcess(mouseEvent);
            }
        }
        this.wakeupOn(this.mouseCriterion);
    }

    void doProcess(MouseEvent mouseEvent) {
        int n = 0;
        this.processMouseEvent(mouseEvent);
        if (mouseEvent.getID() == 507) {
            MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)mouseEvent;
            if (mouseWheelEvent.getScrollType() == 0) {
                n = mouseWheelEvent.getUnitsToScroll();
            }
            if (!this.reset) {
                this.transformGroup.getTransform(this.currXform);
                this.translation.z = (double)n * this.z_factor;
                this.transformX.set(this.translation);
                if (this.invert) {
                    this.currXform.mul(this.currXform, this.transformX);
                } else {
                    this.currXform.mul(this.transformX, this.currXform);
                }
                this.transformGroup.setTransform(this.currXform);
                this.transformChanged(this.currXform);
                if (this.callback != null) {
                    this.callback.transformChanged(2, this.currXform);
                }
            } else {
                this.reset = false;
            }
        }
    }

    public void transformChanged(Transform3D transform3D) {
    }

    public void setupCallback(MouseBehaviorCallback mouseBehaviorCallback) {
        this.callback = mouseBehaviorCallback;
    }
}

