/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.LeafState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.Group;
import javax.media.j3d.ModelClip;
import javax.media.j3d.SceneGraphObject;
import javax.vecmath.Vector4d;

public class ModelClipState
extends LeafState {
    private int[] scopes;
    private int influencingBoundingLeaf;

    public ModelClipState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
        if (this.node != null) {
            this.scopes = new int[((ModelClip)this.node).numScopes()];
            for (int i = 0; i < this.scopes.length; ++i) {
                this.scopes[i] = controller.getSymbolTable().addReference(((ModelClip)this.node).getScope(i));
            }
            this.influencingBoundingLeaf = controller.getSymbolTable().addReference(((ModelClip)this.node).getInfluencingBoundingLeaf());
        }
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        boolean[] blArray = new boolean[6];
        ((ModelClip)this.node).getEnables(blArray);
        dataOutput.writeInt(this.scopes.length);
        for (int i = 0; i < this.scopes.length; ++i) {
            dataOutput.writeInt(this.scopes[i]);
        }
        dataOutput.writeInt(this.influencingBoundingLeaf);
        this.control.writeBounds(dataOutput, ((ModelClip)this.node).getInfluencingBounds());
        Vector4d[] vector4dArray = new Vector4d[6];
        ((ModelClip)this.node).getPlanes(vector4dArray);
        for (int i = 0; i < 6; ++i) {
            dataOutput.writeBoolean(blArray[i]);
            this.control.writeVector4d(dataOutput, vector4dArray[i]);
        }
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        this.scopes = new int[dataInput.readInt()];
        for (int i = 0; i < this.scopes.length; ++i) {
            this.scopes[i] = dataInput.readInt();
        }
        this.influencingBoundingLeaf = dataInput.readInt();
        ((ModelClip)this.node).setInfluencingBounds(this.control.readBounds(dataInput));
        boolean[] blArray = new boolean[6];
        Vector4d[] vector4dArray = new Vector4d[6];
        for (int i = 0; i < 6; ++i) {
            blArray[i] = dataInput.readBoolean();
            vector4dArray[i] = this.control.readVector4d(dataInput);
        }
        ((ModelClip)this.node).setEnables(blArray);
        ((ModelClip)this.node).setPlanes(vector4dArray);
    }

    public void buildGraph() {
        for (int i = 0; i < this.scopes.length; ++i) {
            ((ModelClip)this.node).addScope((Group)this.control.getSymbolTable().getJ3dNode(this.scopes[i]));
        }
        ((ModelClip)this.node).setInfluencingBoundingLeaf((BoundingLeaf)this.control.getSymbolTable().getJ3dNode(this.influencingBoundingLeaf));
        super.buildGraph();
    }

    protected SceneGraphObject createNode() {
        return new ModelClip();
    }
}

