/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.AWTEvent;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.media.j3d.AudioDevice;
import javax.media.j3d.AudioDevice3D;
import javax.media.j3d.AudioDevice3DL2;
import javax.media.j3d.AuralAttributes;
import javax.media.j3d.AuralAttributesRetained;
import javax.media.j3d.BackgroundSoundRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ConeSoundRetained;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.J3dClock;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dStructure;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.MediaContainerRetained;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.PointSoundRetained;
import javax.media.j3d.Sound;
import javax.media.j3d.SoundRetained;
import javax.media.j3d.SoundSchedulerAtom;
import javax.media.j3d.SoundscapeRetained;
import javax.media.j3d.UnorderList;
import javax.media.j3d.UpdateTargets;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.ViewPlatformRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

class SoundScheduler
extends J3dStructure {
    View view = null;
    boolean ready = false;
    ViewPlatformRetained viewPlatform = null;
    GraphicsContext3D graphicsCtx = null;
    AuralAttributesRetained lastAA = null;
    boolean resetAA = true;
    AudioDevice audioDevice = null;
    AudioDevice3D audioDevice3D = null;
    AudioDevice3DL2 audioDevice3DL2 = null;
    int totalChannels = 0;
    SoundscapeRetained[] intersectedSoundscapes = new SoundscapeRetained[32];
    Bounds[] intersectedRegions = new Bounds[32];
    Bounds region = null;
    ArrayList prioritizedSounds = new ArrayList();
    int nRetainedSounds = -1;
    int nImmedSounds = -1;
    AuralAttributesRetained aaRetained = null;
    boolean transformMsg = false;
    UpdateTargets targets = null;
    AuralAttributesRetained aaImmed = null;
    static final int EAR_POSITIONS_CHANGED = 1;
    static final int EYE_POSITIONS_CHANGED = 2;
    static final int IMAGE_PLATE_TO_VWORLD_CHANGED = 4;
    static final int HEAD_TO_VWORLD_CHANGED = 8;
    static final int LISTENER_CHANGED = 15;
    private int listenerUpdated = 15;
    private boolean positionalSoundUpdated = false;
    private boolean auralAttribsChanged = true;
    private boolean stallThread = false;
    int lastEventReceived = 202;
    static final boolean debugFlag = false;
    static final boolean internalErrors = false;

    SoundScheduler(VirtualUniverse virtualUniverse, View view) {
        super(virtualUniverse, 2);
        if (view == null) {
            System.err.println("WARNING: SoundScheduler constructed with null view");
        }
        if (virtualUniverse == null) {
            System.err.println("WARNING: SoundScheduler constructed with null universe");
        }
        this.universe = virtualUniverse;
        this.view = view;
        this.reset();
    }

    void processMessages(long l) {
        Object[] objectArray = this.getMessages(l);
        int n = this.getNumMessage();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                J3dMessage j3dMessage = objectArray[i];
                switch (j3dMessage.type) {
                    case 0: {
                        this.insertNodes(j3dMessage);
                        break;
                    }
                    case 1: {
                        this.removeNodes(j3dMessage);
                        break;
                    }
                    case 38: {
                        this.changeNodeAttrib(j3dMessage);
                        break;
                    }
                    case 45: {
                        this.changeNodeState(j3dMessage);
                        break;
                    }
                    case 23: {
                        this.processBoundingLeafChanged(j3dMessage);
                        break;
                    }
                    case 40: {
                        SoundscapeRetained soundscapeRetained = (SoundscapeRetained)j3dMessage.args[0];
                        if (!this.universe.soundStructure.isSoundscapeScopedToView(soundscapeRetained, this.view)) break;
                        this.auralAttribsChanged = true;
                        this.changeNodeAttrib(j3dMessage);
                        break;
                    }
                    case 39: {
                        this.auralAttribsChanged = true;
                        this.changeNodeAttrib(j3dMessage);
                        break;
                    }
                    case 51: {
                        this.changeNodeAttrib(j3dMessage);
                        break;
                    }
                    case 3: {
                        this.transformMsg = true;
                        this.auralAttribsChanged = true;
                        break;
                    }
                    case 44: {
                        this.processImmediateNodes(j3dMessage.args, l);
                        break;
                    }
                    case 56: {
                        this.processViewSpecificGroupChanged(j3dMessage);
                        break;
                    }
                    case 4: {
                        if (!this.prioritizedSounds.isEmpty()) break;
                        int n2 = this.prioritizeSounds();
                        break;
                    }
                }
                j3dMessage.decRefcount();
            }
            if (this.transformMsg) {
                this.targets = this.universe.transformStructure.getTargetList();
                this.updateTransformChange(this.targets, l);
                this.transformMsg = false;
                this.targets = null;
            }
            Arrays.fill(objectArray, 0, n, null);
        }
        try {
            this.renderChanges();
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Exception occurred during Sound rendering:");
            runtimeException.printStackTrace();
        }
        catch (Error error) {
            System.err.println("Error occurred during Sound rendering:");
            error.printStackTrace();
        }
        long l2 = this.shortestTimeToFinish();
        if (l2 == 0L) {
            VirtualUniverse.mc.sendRunMessage(this.universe, 2);
        } else if (l2 > 0L) {
            VirtualUniverse.mc.sendRunMessage(l2, this.view, 2);
        }
    }

    void insertNodes(J3dMessage j3dMessage) {
        Object object;
        int n;
        Object[] objectArray = (Object[])j3dMessage.args[0];
        ArrayList arrayList = (ArrayList)j3dMessage.args[3];
        ArrayList arrayList2 = (ArrayList)j3dMessage.args[4];
        for (n = 0; n < objectArray.length; ++n) {
            object = objectArray[n];
            if (object instanceof SoundRetained) {
                ++this.nRetainedSounds;
                this.addSound((SoundRetained)object);
                continue;
            }
            if (object instanceof SoundscapeRetained) {
                this.auralAttribsChanged = true;
                continue;
            }
            if (object instanceof AuralAttributesRetained) {
                this.auralAttribsChanged = true;
                continue;
            }
            if (!(object instanceof ViewPlatformRetained)) continue;
        }
        if (arrayList != null) {
            n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                object = (NodeRetained)arrayList.get(i);
                ArrayList arrayList3 = (ArrayList)arrayList2.get(i);
                if (!arrayList3.contains(this.view)) continue;
                if (object instanceof SoundRetained) {
                    ++this.nRetainedSounds;
                    this.addSound((SoundRetained)object);
                    continue;
                }
                if (!(object instanceof SoundscapeRetained)) continue;
                this.auralAttribsChanged = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSound(SoundRetained soundRetained) {
        if (soundRetained == null) {
            return;
        }
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            this.addPrioritizedSound(soundRetained);
        }
    }

    void removeNodes(J3dMessage j3dMessage) {
        int n;
        Object object;
        int n2;
        Object[] objectArray = (Object[])j3dMessage.args[0];
        ArrayList arrayList = (ArrayList)j3dMessage.args[3];
        ArrayList arrayList2 = (ArrayList)j3dMessage.args[4];
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            object = objectArray[n2];
            if (object instanceof SoundRetained) {
                SoundSchedulerAtom soundSchedulerAtom = null;
                n = 1;
                while ((soundSchedulerAtom = this.findSoundAtom((SoundRetained)object, n)) != null) {
                    this.stopSound(soundSchedulerAtom, false);
                    ++n;
                }
                continue;
            }
            if (!(object instanceof SoundscapeRetained)) continue;
            this.auralAttribsChanged = true;
        }
        if (arrayList != null) {
            n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                object = (NodeRetained)arrayList.get(n);
                ArrayList arrayList3 = (ArrayList)arrayList2.get(n);
                if (!arrayList3.contains(this.view)) continue;
                if (object instanceof SoundRetained) {
                    SoundSchedulerAtom soundSchedulerAtom = null;
                    int n3 = 1;
                    while ((soundSchedulerAtom = this.findSoundAtom((SoundRetained)object, n3)) != null) {
                        this.stopSound(soundSchedulerAtom, false);
                        ++n3;
                    }
                    continue;
                }
                if (!(object instanceof SoundscapeRetained)) continue;
                this.auralAttribsChanged = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteSound(SoundRetained soundRetained) {
        if (soundRetained != null) {
            return;
        }
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            if (!this.prioritizedSounds.isEmpty()) {
                int n = this.prioritizedSounds.size();
                for (int i = 0; i < n; ++i) {
                    SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(i);
                    if (soundSchedulerAtom.sound != soundRetained && soundSchedulerAtom.sound.sgSound != soundRetained) continue;
                    this.stopSound(soundSchedulerAtom, false);
                    this.prioritizedSounds.remove(i);
                }
            }
        }
    }

    void changeNodeAttrib(J3dMessage j3dMessage) {
        Object object = j3dMessage.args[0];
        Object object2 = j3dMessage.args[1];
        int n = (Integer)object2;
        if (object instanceof SoundRetained && this.universe.soundStructure.isSoundScopedToView(object, this.view)) {
            this.setAttribsDirtyFlag((SoundRetained)object, n);
            if ((n & 0x20) > 0) {
                this.shuffleSound((SoundRetained)object);
            }
            if ((n & 1) > 0) {
                this.loadSound((SoundRetained)object, true);
            }
            if ((n & 0x40) > 0) {
                this.muteSound((SoundRetained)object);
            }
            if ((n & 0x80) > 0) {
                this.pauseSound((SoundRetained)object);
            }
        } else if (object instanceof SoundscapeRetained && this.universe.soundStructure.isSoundscapeScopedToView(object, this.view)) {
            this.auralAttribsChanged = true;
        } else if (object instanceof AuralAttributesRetained) {
            this.auralAttribsChanged = true;
        } else if (object instanceof MediaContainerRetained) {
            int n2 = (Integer)j3dMessage.args[2];
            ArrayList arrayList = (ArrayList)j3dMessage.args[3];
            for (int i = 0; i < n2; ++i) {
                SoundRetained soundRetained = (SoundRetained)arrayList.get(i);
                if (soundRetained == null) continue;
                this.loadSound(soundRetained, true);
            }
        }
    }

    void changeNodeState(J3dMessage j3dMessage) {
        Object object = j3dMessage.args[0];
        Object object2 = j3dMessage.args[1];
        if (object instanceof SoundRetained && this.universe.soundStructure.isSoundScopedToView(object, this.view)) {
            int n = (Integer)object2;
            this.setStateDirtyFlag((SoundRetained)object, n);
            if ((n & 1) > 0) {
                this.loadSound((SoundRetained)object, false);
            }
            if ((n & 0x20) > 0) {
                if (((Boolean)j3dMessage.args[4]).booleanValue()) {
                    this.enableSound((SoundRetained)object);
                } else {
                    SoundRetained soundRetained = (SoundRetained)object;
                    for (int i = this.prioritizedSounds.size() - 1; i >= 0; --i) {
                        SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(i);
                        if (soundSchedulerAtom.sound.sgSound != soundRetained) continue;
                        this.turnOff(soundSchedulerAtom);
                        soundSchedulerAtom.enable(soundRetained.enable);
                    }
                }
            }
        }
    }

    void shuffleSound(SoundRetained soundRetained) {
        this.deleteSound(soundRetained);
        this.addSound(soundRetained);
    }

    void loadSound(SoundRetained soundRetained, boolean bl) {
        SoundSchedulerAtom soundSchedulerAtom = null;
        int n = 1;
        while ((soundSchedulerAtom = this.findSoundAtom(soundRetained, n)) != null) {
            MediaContainer mediaContainer = soundRetained.getSoundData();
            if (bl || soundSchedulerAtom.loadStatus != 2) {
                this.attachSoundData(soundSchedulerAtom, mediaContainer, bl);
            }
            ++n;
        }
    }

    void enableSound(SoundRetained soundRetained) {
        SoundSchedulerAtom soundSchedulerAtom = null;
        int n = 1;
        while ((soundSchedulerAtom = this.findSoundAtom(soundRetained, n)) != null) {
            soundSchedulerAtom.enable(soundRetained.enable);
            ++n;
        }
    }

    void muteSound(SoundRetained soundRetained) {
        SoundSchedulerAtom soundSchedulerAtom = null;
        int n = 1;
        while ((soundSchedulerAtom = this.findSoundAtom(soundRetained, n)) != null) {
            soundSchedulerAtom.mute(soundRetained.mute);
            ++n;
        }
    }

    void pauseSound(SoundRetained soundRetained) {
        SoundSchedulerAtom soundSchedulerAtom = null;
        int n = 1;
        while ((soundSchedulerAtom = this.findSoundAtom(soundRetained, n)) != null) {
            soundSchedulerAtom.pause(soundRetained.pause);
            ++n;
        }
    }

    void processImmediateNodes(Object[] objectArray, long l) {
        Object object = objectArray[0];
        Object object2 = objectArray[1];
        Object object3 = objectArray[2];
        Sound sound = (Sound)object3;
        Sound sound2 = (Sound)object2;
        int n = (Integer)object;
        switch (n) {
            case 15: 
            case 17: {
                this.addSound((SoundRetained)sound2.retained);
                ++this.nImmedSounds;
                break;
            }
            case 16: {
                this.deleteSound((SoundRetained)sound.retained);
                --this.nImmedSounds;
                break;
            }
            case 14: {
                this.deleteSound((SoundRetained)sound.retained);
                this.addSound((SoundRetained)sound2.retained);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTransformChange(UpdateTargets updateTargets, long l) {
        UnorderList unorderList = updateTargets.targetList[3];
        if (unorderList != null) {
            int n = unorderList.size();
            Object[] objectArray = unorderList.toArray(false);
            for (int i = 0; i < n; ++i) {
                Object[] objectArray2 = (Object[])objectArray[i];
                for (int j = 0; j < objectArray2.length; ++j) {
                    LeafRetained leafRetained;
                    LeafRetained leafRetained2;
                    if (objectArray2[j] instanceof ConeSoundRetained && this.universe.soundStructure.isSoundScopedToView(objectArray2[j], this.view)) {
                        leafRetained2 = (ConeSoundRetained)objectArray2[j];
                        leafRetained = leafRetained2;
                        synchronized (leafRetained) {
                            ((ConeSoundRetained)leafRetained2).updateTransformChange();
                        }
                        this.setStateDirtyFlag((SoundRetained)objectArray2[j], 32768);
                        continue;
                    }
                    if (objectArray2[j] instanceof PointSoundRetained && this.universe.soundStructure.isSoundScopedToView(objectArray2[j], this.view)) {
                        leafRetained2 = (PointSoundRetained)objectArray2[j];
                        leafRetained = leafRetained2;
                        synchronized (leafRetained) {
                            ((PointSoundRetained)leafRetained2).updateTransformChange();
                        }
                        this.setStateDirtyFlag((SoundRetained)objectArray2[j], 32768);
                        continue;
                    }
                    if (!(objectArray2[j] instanceof SoundscapeRetained) || !this.universe.soundStructure.isSoundscapeScopedToView(objectArray2[j], this.view)) continue;
                    leafRetained2 = (SoundscapeRetained)objectArray2[j];
                    leafRetained = leafRetained2;
                    synchronized (leafRetained) {
                        ((SoundscapeRetained)leafRetained2).updateTransformChange();
                        continue;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateTransformedFields(SoundRetained soundRetained) {
        if (soundRetained instanceof ConeSoundRetained && this.universe.soundStructure.isSoundScopedToView(soundRetained, this.view)) {
            ConeSoundRetained coneSoundRetained;
            ConeSoundRetained coneSoundRetained2 = coneSoundRetained = (ConeSoundRetained)soundRetained;
            synchronized (coneSoundRetained2) {
                coneSoundRetained.updateTransformChange();
            }
        }
        if (soundRetained instanceof PointSoundRetained && this.universe.soundStructure.isSoundScopedToView(soundRetained, this.view)) {
            PointSoundRetained pointSoundRetained;
            PointSoundRetained pointSoundRetained2 = pointSoundRetained = (PointSoundRetained)soundRetained;
            synchronized (pointSoundRetained2) {
                pointSoundRetained.updateTransformChange();
            }
        }
    }

    void activate() {
        this.updateThread.active = true;
        VirtualUniverse.mc.sendRunMessage(this.universe, 2);
    }

    void deactivate() {
        if (this.checkState()) {
            try {
                this.deactivateAllSounds();
            }
            catch (RuntimeException runtimeException) {
                System.err.println("Exception occurred during sound deactivation:");
                runtimeException.printStackTrace();
            }
            catch (Error error) {
                System.err.println("Error occurred during sound deactivation:");
                error.printStackTrace();
            }
            this.updateThread.active = false;
        }
    }

    boolean checkState() {
        boolean bl = false;
        if (this.stallThread) {
            bl = false;
        }
        if (this.ready) {
            bl = true;
        } else {
            this.reset();
            bl = this.ready;
        }
        return bl;
    }

    synchronized void reset() {
        if (this.universe == null || this.view == null || this.view.physicalEnvironment == null || this.view.physicalEnvironment.audioDevice == null) {
            this.audioDevice = null;
            this.ready = false;
            return;
        }
        this.audioDevice = this.view.physicalEnvironment.audioDevice;
        ViewPlatform viewPlatform = this.view.getViewPlatform();
        if (viewPlatform == null || viewPlatform.retained == null) {
            this.viewPlatform = null;
            this.ready = false;
            return;
        }
        this.viewPlatform = (ViewPlatformRetained)viewPlatform.retained;
        if (!viewPlatform.isLive()) {
            this.ready = false;
            return;
        }
        Canvas3D canvas3D = this.view.getFirstCanvas();
        if (canvas3D != null) {
            this.graphicsCtx = canvas3D.getGraphicsContext3D();
        }
        this.audioDevice3DL2 = null;
        this.audioDevice3D = null;
        if (this.audioDevice instanceof AudioDevice3DL2) {
            this.audioDevice3DL2 = (AudioDevice3DL2)this.audioDevice;
        }
        if (this.audioDevice instanceof AudioDevice3D) {
            this.audioDevice3D = (AudioDevice3D)this.audioDevice;
            this.audioDevice3D.setView(this.view);
            this.totalChannels = this.audioDevice.getTotalChannels();
        } else {
            this.totalChannels = 0;
        }
        if (this.totalChannels == 0) {
            this.ready = false;
            return;
        }
        this.ready = true;
        this.view.setUserHeadToVworldEnable(true);
    }

    void receiveAWTEvent(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        if (this.ready && n == 203) {
            this.lastEventReceived = n;
        } else if (this.ready && this.lastEventReceived == 203 && n == 204) {
            this.lastEventReceived = n;
        }
    }

    void renderChanges() {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        if (!this.checkState()) {
            return;
        }
        n2 = this.prioritizedSounds.size();
        if (n2 == 0) {
            return;
        }
        if (this.auralAttribsChanged && (n = this.findActiveSoundscapes()) > 0) {
            this.aaRetained = (AuralAttributesRetained)this.findClosestAAttribs(n).clone();
        }
        if (n2 > 0) {
            this.calcSchedulingAction();
            this.muteSilentSounds();
            this.positionalSoundUpdated = false;
            if (this.testListenerFlag()) {
                this.audioDevice3D.setView(this.view);
            }
            n3 = this.performActions();
            if (this.positionalSoundUpdated) {
                this.clearListenerFlag();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int prioritizeSounds() {
        int n;
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            if (!this.prioritizedSounds.isEmpty()) {
                this.prioritizedSounds.clear();
            }
            UnorderList unorderList = this.universe.soundStructure.getSoundList(this.view);
            this.nRetainedSounds = 0;
            this.nImmedSounds = 0;
            for (int i = 0; i < unorderList.size(); ++i) {
                this.addPrioritizedSound((SoundRetained)unorderList.get(i));
                ++this.nRetainedSounds;
            }
            Enumeration enumeration = this.view.getAllCanvas3Ds();
            while (enumeration.hasMoreElements()) {
                Canvas3D canvas3D = (Canvas3D)enumeration.nextElement();
                GraphicsContext3D graphicsContext3D = canvas3D.getGraphicsContext3D();
                Enumeration enumeration2 = graphicsContext3D.getAllSounds();
                while (enumeration2.hasMoreElements()) {
                    Sound sound = (Sound)enumeration2.nextElement();
                    if (sound == null) continue;
                    this.addPrioritizedSound((SoundRetained)sound.retained);
                    ++this.nImmedSounds;
                }
            }
            this.debugPrint(" prioritizeSound , num of processed non-retained sounds" + this.nImmedSounds);
            n = this.prioritizedSounds.size();
        }
        return n;
    }

    void addPrioritizedSound(SoundRetained soundRetained) {
        SoundRetained soundRetained2 = soundRetained.sgSound;
        if (soundRetained2 == null) {
            soundRetained.sgSound = soundRetained;
            soundRetained2 = soundRetained;
        }
        boolean bl = false;
        SoundSchedulerAtom soundSchedulerAtom = null;
        soundSchedulerAtom = this.findSoundAtom(soundRetained, 1);
        if (soundSchedulerAtom == null) {
            soundSchedulerAtom = new SoundSchedulerAtom();
            soundSchedulerAtom.soundScheduler = this;
            bl = true;
        }
        soundSchedulerAtom.sound = soundRetained;
        this.updateTransformedFields(soundRetained);
        if (!bl) {
            return;
        }
        soundSchedulerAtom.enable(soundRetained2.enable);
        if (this.prioritizedSounds.isEmpty()) {
            this.prioritizedSounds.add(soundSchedulerAtom);
        } else {
            int n;
            int n2 = this.prioritizedSounds.size() - 1;
            float f = soundRetained2.priority;
            for (n = n2; n >= 0; --n) {
                SoundSchedulerAtom soundSchedulerAtom2 = (SoundSchedulerAtom)this.prioritizedSounds.get(n);
                SoundRetained soundRetained3 = soundSchedulerAtom2.sound;
                if (!(f <= soundRetained3.sgSound.priority)) continue;
                if (n == n2) {
                    this.prioritizedSounds.add(soundSchedulerAtom);
                    break;
                }
                this.prioritizedSounds.add(n + 1, soundSchedulerAtom);
                break;
            }
            if (n < 0) {
                this.prioritizedSounds.add(0, soundSchedulerAtom);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int findActiveSoundscapes() {
        int n = 0;
        int n2 = 0;
        Object var3_3 = null;
        SoundscapeRetained soundscapeRetained = null;
        boolean bl = false;
        int n3 = 0;
        UnorderList unorderList = null;
        if (this.universe == null) {
            return 0;
        }
        unorderList = this.universe.soundStructure.getSoundscapeList(this.view);
        if (unorderList == null) {
            return 0;
        }
        UnorderList unorderList2 = unorderList;
        synchronized (unorderList2) {
            n3 = unorderList.size;
            if (n3 == 0) {
                return 0;
            }
            if (this.intersectedRegions.length < n) {
                this.intersectedRegions = new Bounds[n + 32];
            }
            if (this.intersectedSoundscapes.length < n) {
                this.intersectedSoundscapes = new SoundscapeRetained[n + 32];
            }
            n2 = 0;
            for (int i = 0; i < n3; ++i) {
                soundscapeRetained = (SoundscapeRetained)unorderList.get(i);
                if (soundscapeRetained.transformedRegion == null) continue;
                if (this.region instanceof BoundingSphere && soundscapeRetained.transformedRegion instanceof BoundingSphere || this.region instanceof BoundingBox && soundscapeRetained.transformedRegion instanceof BoundingBox || this.region instanceof BoundingPolytope && soundscapeRetained.transformedRegion instanceof BoundingPolytope) {
                    soundscapeRetained.transformedRegion.getWithLock(this.region);
                } else {
                    this.region = (Bounds)soundscapeRetained.transformedRegion.clone();
                }
                if (this.region == null || !this.viewPlatform.schedSphere.intersect(this.region)) continue;
                this.intersectedRegions[n2] = (Bounds)this.region.clone();
                this.intersectedSoundscapes[n2] = soundscapeRetained;
                ++n2;
            }
        }
        return n2;
    }

    AuralAttributesRetained findClosestAAttribs(int n) {
        AuralAttributes auralAttributes = null;
        SoundscapeRetained soundscapeRetained = null;
        boolean bl = false;
        soundscapeRetained = null;
        if (n == 1) {
            soundscapeRetained = this.intersectedSoundscapes[0];
        } else if (n > 1) {
            Bounds bounds = this.viewPlatform.schedSphere.closestIntersection(this.intersectedRegions);
            for (int i = 0; i < this.intersectedRegions.length; ++i) {
                if (this.intersectedRegions[i] != bounds) continue;
                soundscapeRetained = this.intersectedSoundscapes[i];
                break;
            }
        }
        if (soundscapeRetained == null || (auralAttributes = soundscapeRetained.getAuralAttributes()) != null) {
            // empty if block
        }
        return (AuralAttributesRetained)auralAttributes.retained;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateAuralAttribs(AuralAttributesRetained auralAttributesRetained) {
        if (this.auralAttribsChanged) {
            if (auralAttributesRetained != null) {
                AuralAttributesRetained auralAttributesRetained2 = auralAttributesRetained;
                synchronized (auralAttributesRetained2) {
                    Object object;
                    Object object2;
                    this.audioDevice3D.setRolloff(auralAttributesRetained.rolloff);
                    int n = auralAttributesRetained.getDistanceFilterLength();
                    if (auralAttributesRetained.filterType == -1 || n == 0) {
                        this.audioDevice3D.setDistanceFilter(-1, null, null);
                    } else {
                        object2 = new Point2f[n];
                        for (int i = 0; i < n; ++i) {
                            object2[i] = new Point2f();
                        }
                        auralAttributesRetained.getDistanceFilter((Point2f[])object2);
                        double[] dArray = new double[n];
                        object = new float[n];
                        for (int i = 0; i < n; ++i) {
                            dArray[i] = object2[i].x;
                            object[i] = object2[i].y;
                        }
                        this.audioDevice3D.setDistanceFilter(auralAttributesRetained.filterType, dArray, (float[])object);
                    }
                    this.audioDevice3D.setFrequencyScaleFactor(auralAttributesRetained.frequencyScaleFactor);
                    this.audioDevice3D.setVelocityScaleFactor(auralAttributesRetained.velocityScaleFactor);
                    this.audioDevice3D.setReflectionCoefficient(auralAttributesRetained.reflectionCoefficient);
                    if (this.audioDevice3DL2 != null) {
                        this.audioDevice3DL2.setReverbCoefficient(auralAttributesRetained.reverbCoefficient);
                        this.audioDevice3DL2.setDecayFilter(auralAttributesRetained.decayFilter);
                        this.audioDevice3DL2.setDiffusion(auralAttributesRetained.diffusion);
                        this.audioDevice3DL2.setDensity(auralAttributesRetained.density);
                    }
                    if ((object2 = auralAttributesRetained.reverbBounds) == null) {
                        this.audioDevice3D.setReverbDelay(auralAttributesRetained.reverbDelay);
                    } else {
                        float f;
                        if (object2 instanceof BoundingSphere) {
                            f = (float)(2.0 * ((BoundingSphere)object2).radius / (double)0.344f);
                        } else {
                            object = new BoundingSphere((Bounds)object2);
                            f = (float)(2.0 * object.radius / (double)0.344f);
                        }
                        this.audioDevice3D.setReverbDelay(f);
                    }
                    this.audioDevice3D.setReverbOrder(auralAttributesRetained.reverbOrder);
                    if (this.audioDevice3DL2 != null) {
                        this.audioDevice3DL2.setDecayTime(auralAttributesRetained.decayTime);
                    }
                }
                this.resetAA = true;
            } else if (this.lastAA != null) {
                this.audioDevice3D.setRolloff(1.0f);
                this.audioDevice3D.setReflectionCoefficient(0.0f);
                this.audioDevice3D.setReverbDelay(40.0f);
                this.audioDevice3D.setReverbOrder(0);
                this.audioDevice3D.setDistanceFilter(-1, null, null);
                this.audioDevice3D.setFrequencyScaleFactor(1.0f);
                this.audioDevice3D.setVelocityScaleFactor(0.0f);
                if (this.audioDevice3DL2 != null) {
                    this.audioDevice3DL2.setReverbCoefficient(0.0f);
                    this.audioDevice3DL2.setReflectionDelay(20.0f);
                    this.audioDevice3DL2.setDecayTime(1000.0f);
                    this.audioDevice3DL2.setDecayFilter(5000.0f);
                    this.audioDevice3DL2.setDiffusion(1.0f);
                    this.audioDevice3DL2.setDensity(1.0f);
                }
                this.resetAA = true;
            }
            this.lastAA = auralAttributesRetained;
            this.auralAttribsChanged = false;
        }
    }

    /*
     * Unable to fully structure code
     */
    void processSoundAtom(SoundSchedulerAtom var1_1) {
        var2_2 = var1_1.sound;
        var3_3 = var2_2.sgSound;
        if (var1_1.status == 4 && var1_1.enabled != 2) {
            return;
        }
        if (var1_1.loadStatus != 2) {
            this.attachSoundData(var1_1, var3_3.soundData, false);
        }
        if (var1_1.loadStatus != 2) {
            return;
        }
        if (this.resetAA) {
            var1_1.setAttribsDirtyFlag(2);
        }
        var4_4 = false;
        if (!this.updateThread.active) {
            this.region = null;
            var4_4 = false;
        } else if (var3_3.getInImmCtx()) {
            this.region = null;
            var4_4 = true;
        } else {
            if (var3_3.schedulingRegion != null && var2_2.transformedRegion != null) {
                if (this.region instanceof BoundingSphere != false && var2_2.transformedRegion instanceof BoundingSphere != false || this.region instanceof BoundingBox != false && var2_2.transformedRegion instanceof BoundingBox != false || this.region instanceof BoundingPolytope && var2_2.transformedRegion instanceof BoundingPolytope) {
                    var2_2.transformedRegion.getWithLock(this.region);
                } else {
                    this.region = (Bounds)var2_2.transformedRegion.clone();
                }
            } else {
                this.region = null;
            }
            var4_4 = this.region != null ? this.viewPlatform.schedSphere.intersect(this.region) : false;
        }
        if (!var3_3.getInImmCtx() && (!var4_4 || var2_2.switchState == null || !var2_2.switchState.currentSwitchOn)) ** GOTO lbl-1000
        if (var1_1.muted == 0) ** GOTO lbl-1000
        if (var1_1.muted == 2) lbl-1000:
        // 2 sources

        {
            var1_1.schedulingAction = var1_1.calcActiveSchedAction();
        } else lbl-1000:
        // 2 sources

        {
            var1_1.schedulingAction = var1_1.calcInactiveSchedAction();
        }
        if (var1_1.schedulingAction == 3 && (var1_1.testDirtyFlags() || this.testListenerFlag() && !(var3_3 instanceof BackgroundSoundRetained))) {
            var1_1.schedulingAction = 18;
        }
        switch (var1_1.schedulingAction) {
            case 17: {
                var1_1.status = 0;
                this.turnOff(var1_1);
                var1_1.schedulingAction = 1;
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                var5_5 = J3dClock.currentTimeMillis();
                if (var1_1.endTime <= 0L || var1_1.endTime > var5_5) break;
                var1_1.schedulingAction = 19;
                var1_1.status = 4;
                this.turnOff(var1_1);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            default: {
                var1_1.schedulingAction = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int calcSchedulingAction() {
        int n = 0;
        int n2 = 0;
        if (this.universe == null) {
            return 0;
        }
        if (this.universe.soundStructure == null) {
            return 0;
        }
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            n = this.prioritizedSounds.size();
            for (int i = 0; i < n; ++i) {
                SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(i);
                SoundRetained soundRetained = soundSchedulerAtom.sound;
                SoundRetained soundRetained2 = soundRetained.sgSound;
                boolean bl = false;
                if (!soundRetained2.source.isLive() && !soundRetained2.getInImmCtx()) {
                    if (soundSchedulerAtom.playing || soundSchedulerAtom.enabled == 1) {
                        soundSchedulerAtom.setEnableState(3);
                        bl = true;
                    } else if (soundSchedulerAtom.enabled == 3) {
                        bl = true;
                    } else if (soundSchedulerAtom.enabled == 2) {
                        soundSchedulerAtom.setEnableState(0);
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    ++n2;
                    this.processSoundAtom(soundSchedulerAtom);
                    continue;
                }
                soundSchedulerAtom.schedulingAction = 0;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void muteSilentSounds() {
        int n = 0;
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            int n2 = this.prioritizedSounds.size();
            for (int i = 0; i < n2; ++i) {
                int n3;
                SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(i);
                SoundRetained soundRetained = soundSchedulerAtom.sound;
                SoundRetained soundRetained2 = soundRetained.sgSound;
                int n4 = soundSchedulerAtom.sampleId;
                int n5 = soundSchedulerAtom.status;
                if (soundSchedulerAtom.status == 4 || soundSchedulerAtom.schedulingAction == 0 || n4 == -1) continue;
                if (soundSchedulerAtom.schedulingAction == 12 || soundSchedulerAtom.schedulingAction == 7 || soundSchedulerAtom.schedulingAction == 2 || soundSchedulerAtom.schedulingAction == 8) {
                    if (n5 != 2) {
                        this.audioDevice3D.muteSample(n4);
                    }
                    soundSchedulerAtom.numberChannels = n3 = this.audioDevice3D.getNumberOfChannelsUsed(n4);
                    n += n3;
                    continue;
                }
                n3 = this.audioDevice3D.getNumberOfChannelsUsed(n4, false);
                if (n + n3 > this.totalChannels) {
                    if (soundSchedulerAtom.schedulingAction == 11 || soundSchedulerAtom.schedulingAction == 3) {
                        soundSchedulerAtom.schedulingAction = 12;
                    } else if (soundSchedulerAtom.schedulingAction == 5) {
                        soundSchedulerAtom.schedulingAction = 7;
                    } else if (soundSchedulerAtom.schedulingAction == 6) {
                        soundSchedulerAtom.schedulingAction = 8;
                    } else if (soundSchedulerAtom.schedulingAction == 13) {
                        soundSchedulerAtom.schedulingAction = 14;
                    } else if (soundSchedulerAtom.schedulingAction == 15) {
                        soundSchedulerAtom.schedulingAction = 16;
                    }
                    this.audioDevice3D.muteSample(n4);
                } else if (n5 != 1) {
                    this.audioDevice3D.unmuteSample(n4);
                }
                soundSchedulerAtom.numberChannels = n3 = this.audioDevice3D.getNumberOfChannelsUsed(n4);
                n += n3;
            }
        }
    }

    void muteSilentSound(SoundSchedulerAtom soundSchedulerAtom) {
        SoundRetained soundRetained = soundSchedulerAtom.sound;
        SoundRetained soundRetained2 = soundRetained.sgSound;
        int n = soundSchedulerAtom.sampleId;
        int n2 = soundSchedulerAtom.status;
        if (n2 == 4) {
            return;
        }
        if (n == -1) {
            return;
        }
        if ((soundSchedulerAtom.schedulingAction == 12 || soundSchedulerAtom.schedulingAction == 7 || soundSchedulerAtom.schedulingAction == 2 || soundSchedulerAtom.schedulingAction == 8) && n2 != 2) {
            this.audioDevice3D.muteSample(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long shortestTimeToFinish() {
        long l = J3dClock.currentTimeMillis();
        long l2 = -1L;
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            int n = this.prioritizedSounds.size();
            for (int i = 0; i < n; ++i) {
                long l3;
                SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(i);
                if (soundSchedulerAtom.status == 0 || soundSchedulerAtom.status == 4 || (l3 = soundSchedulerAtom.endTime) < 0L) continue;
                long l4 = l3 - l;
                if (l4 < 0L) {
                    l4 = 0L;
                }
                if (l2 < 0L) {
                    l2 = l4;
                    continue;
                }
                if (l4 >= l2) continue;
                l2 = l4;
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int performActions() {
        int n = 0;
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            int n2 = this.prioritizedSounds.size();
            for (int i = 0; i < n2; ++i) {
                SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(i);
                SoundRetained soundRetained = soundSchedulerAtom.sound;
                SoundRetained soundRetained2 = soundRetained.sgSound;
                int n3 = soundSchedulerAtom.sampleId;
                if (n3 == -1) continue;
                this.resetAA = false;
                AuralAttributesRetained auralAttributesRetained = soundRetained2.getInImmCtx() ? (this.graphicsCtx != null && this.graphicsCtx.auralAttributes != null ? (this.aaImmed = (AuralAttributesRetained)this.graphicsCtx.auralAttributes.retained) : null) : this.aaRetained;
                this.updateAuralAttribs(auralAttributesRetained);
                switch (soundSchedulerAtom.schedulingAction) {
                    case 5: {
                        this.turnOff(soundSchedulerAtom);
                    }
                    case 6: {
                        if (soundSchedulerAtom.paused == 3) {
                            this.pause(soundSchedulerAtom);
                        }
                        if (soundSchedulerAtom.paused == 2) {
                            this.unpause(soundSchedulerAtom);
                        }
                        if (soundSchedulerAtom.paused == 0) {
                            soundSchedulerAtom.status = 1;
                            this.render(true, soundSchedulerAtom, auralAttributesRetained);
                        } else {
                            soundSchedulerAtom.status = 3;
                            soundSchedulerAtom.setEnableState(2);
                        }
                        ++n;
                        break;
                    }
                    case 7: {
                        this.turnOff(soundSchedulerAtom);
                    }
                    case 8: {
                        if (soundSchedulerAtom.paused == 3) {
                            this.pause(soundSchedulerAtom);
                        }
                        if (soundSchedulerAtom.paused == 2) {
                            this.unpause(soundSchedulerAtom);
                        }
                        if (soundSchedulerAtom.paused == 0) {
                            soundSchedulerAtom.status = 2;
                            this.render(true, soundSchedulerAtom, auralAttributesRetained);
                        } else {
                            soundSchedulerAtom.status = 3;
                            soundSchedulerAtom.setEnableState(2);
                        }
                        ++n;
                        break;
                    }
                    case 15: {
                        this.unpause(soundSchedulerAtom);
                    }
                    case 11: {
                        soundSchedulerAtom.status = 1;
                        this.render(false, soundSchedulerAtom, auralAttributesRetained);
                        ++n;
                        break;
                    }
                    case 16: {
                        this.unpause(soundSchedulerAtom);
                    }
                    case 12: {
                        this.render(false, soundSchedulerAtom, auralAttributesRetained);
                        soundSchedulerAtom.status = 2;
                        ++n;
                        break;
                    }
                    case 13: 
                    case 14: {
                        this.pause(soundSchedulerAtom);
                        soundSchedulerAtom.status = 3;
                        ++n;
                        break;
                    }
                    case 18: {
                        this.render(false, soundSchedulerAtom, auralAttributesRetained);
                        ++n;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        if (this.resetAA || soundSchedulerAtom.testDirtyFlags()) {
                            this.render(false, soundSchedulerAtom, auralAttributesRetained);
                        }
                        ++n;
                        break;
                    }
                    case 17: {
                        this.turnOff(soundSchedulerAtom);
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 19: {
                        break;
                    }
                }
                soundSchedulerAtom.clearStateDirtyFlag();
                soundSchedulerAtom.clearAttribsDirtyFlag();
            }
        }
        this.resetAA = false;
        return n;
    }

    void render(boolean bl, SoundSchedulerAtom soundSchedulerAtom, AuralAttributesRetained auralAttributesRetained) {
        SoundRetained soundRetained = soundSchedulerAtom.sound;
        SoundRetained soundRetained2 = soundRetained.sgSound;
        if (soundSchedulerAtom.sampleId == -1 || soundSchedulerAtom.soundData == null) {
            return;
        }
        int n = soundSchedulerAtom.sampleId;
        if (bl) {
            if (soundRetained2 instanceof PointSoundRetained || soundRetained2 instanceof ConeSoundRetained) {
                this.updateXformedParams(true, soundSchedulerAtom);
            }
            this.updateSoundParams(true, soundSchedulerAtom, auralAttributesRetained);
            this.start(soundSchedulerAtom);
        } else if (soundSchedulerAtom.status == 1) {
            if (soundRetained2 instanceof PointSoundRetained || soundRetained2 instanceof ConeSoundRetained) {
                this.updateXformedParams(false, soundSchedulerAtom);
            }
            this.updateSoundParams(false, soundSchedulerAtom, auralAttributesRetained);
            this.update(soundSchedulerAtom);
        }
    }

    void start(SoundSchedulerAtom soundSchedulerAtom) {
        SoundRetained soundRetained = soundSchedulerAtom.sound.sgSound;
        int n = soundSchedulerAtom.sampleId;
        int n2 = -1;
        if (n != -1 && (n2 = this.audioDevice3D.startSample(n)) >= 0) {
            soundSchedulerAtom.playing = true;
            soundSchedulerAtom.startTime = this.audioDevice3D.getStartTime(n);
            soundSchedulerAtom.calculateEndTime();
        } else {
            soundSchedulerAtom.startTime = 0L;
            soundSchedulerAtom.endTime = 0L;
            soundSchedulerAtom.playing = false;
        }
    }

    void update(SoundSchedulerAtom soundSchedulerAtom) {
        int n = soundSchedulerAtom.sampleId;
        if (n == -1) {
            return;
        }
        SoundRetained soundRetained = soundSchedulerAtom.sound;
        this.audioDevice3D.updateSample(n);
        soundSchedulerAtom.calculateEndTime();
        if (soundRetained instanceof PointSoundRetained || soundRetained instanceof ConeSoundRetained) {
            this.positionalSoundUpdated = true;
        }
    }

    void stopSound(SoundSchedulerAtom soundSchedulerAtom, boolean bl) {
        if (this.audioDevice3D == null) {
            return;
        }
        switch (soundSchedulerAtom.enabled) {
            case 1: {
                if (bl) {
                    soundSchedulerAtom.setEnableState(2);
                    break;
                }
                soundSchedulerAtom.setEnableState(0);
                break;
            }
            case 3: {
                soundSchedulerAtom.setEnableState(0);
                break;
            }
            case 2: {
                if (bl) break;
                soundSchedulerAtom.setEnableState(0);
                break;
            }
        }
        soundSchedulerAtom.status = 0;
        this.turnOff(soundSchedulerAtom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void deactivateAllSounds() {
        if (this.audioDevice3D == null) {
            return;
        }
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            if (this.prioritizedSounds != null) {
                int n = this.prioritizedSounds.size();
                for (int i = 0; i < n; ++i) {
                    SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(i);
                    SoundRetained soundRetained = soundSchedulerAtom.sound;
                    SoundRetained soundRetained2 = soundRetained.sgSound;
                    if (soundRetained2.continuous) {
                        soundSchedulerAtom.schedulingAction = soundSchedulerAtom.calcInactiveSchedAction();
                        this.muteSilentSound(soundSchedulerAtom);
                        continue;
                    }
                    this.stopSound(soundSchedulerAtom, true);
                    soundSchedulerAtom.schedulingAction = 1;
                }
            }
        }
        this.performActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void pauseAllSounds() {
        if (this.audioDevice3D == null) {
            return;
        }
        this.stallThread = true;
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            if (this.prioritizedSounds != null) {
                int n = this.prioritizedSounds.size();
                block6: for (int i = 0; i < n; ++i) {
                    SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(i);
                    SoundRetained soundRetained = soundSchedulerAtom.sound;
                    SoundRetained soundRetained2 = soundRetained.sgSound;
                    switch (soundSchedulerAtom.enabled) {
                        case 1: 
                        case 3: {
                            this.pause(soundSchedulerAtom);
                            continue block6;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void resumeAllSounds() {
        if (this.audioDevice3D == null) {
            return;
        }
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            if (this.prioritizedSounds != null) {
                int n = this.prioritizedSounds.size();
                block6: for (int i = 0; i < n; ++i) {
                    SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(i);
                    SoundRetained soundRetained = soundSchedulerAtom.sound;
                    SoundRetained soundRetained2 = soundRetained.sgSound;
                    switch (soundSchedulerAtom.enabled) {
                        case 1: 
                        case 3: {
                            this.unpause(soundSchedulerAtom);
                            continue block6;
                        }
                    }
                }
            }
        }
        this.stallThread = false;
    }

    synchronized void stopAllSounds() {
        this.stopAllSounds(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void stopAllSounds(boolean bl) {
        if (this.audioDevice3D == null) {
            return;
        }
        if (this.lastEventReceived == 203) {
            return;
        }
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            if (this.prioritizedSounds != null) {
                int n = this.prioritizedSounds.size();
                for (int i = 0; i < n; ++i) {
                    SoundSchedulerAtom soundSchedulerAtom = (SoundSchedulerAtom)this.prioritizedSounds.get(i);
                    this.stopSound(soundSchedulerAtom, bl);
                }
            }
        }
    }

    void pause(SoundSchedulerAtom soundSchedulerAtom) {
        if (soundSchedulerAtom.sampleId == -1) {
            return;
        }
        this.audioDevice3D.pauseSample(soundSchedulerAtom.sampleId);
        soundSchedulerAtom.setPauseState(1);
    }

    void unpause(SoundSchedulerAtom soundSchedulerAtom) {
        if (soundSchedulerAtom.sampleId == -1) {
            return;
        }
        this.audioDevice3D.unpauseSample(soundSchedulerAtom.sampleId);
        soundSchedulerAtom.setPauseState(0);
    }

    void turnOff(SoundSchedulerAtom soundSchedulerAtom) {
        if (soundSchedulerAtom.sampleId == -1) {
            return;
        }
        if (this.audioDevice3D.stopSample(soundSchedulerAtom.sampleId) < 0) {
            // empty if block
        }
        soundSchedulerAtom.playing = false;
        soundSchedulerAtom.startTime = 0L;
        soundSchedulerAtom.endTime = 0L;
    }

    void updateXformedParams(boolean bl, SoundSchedulerAtom soundSchedulerAtom) {
        Cloneable cloneable;
        Cloneable cloneable2;
        PointSoundRetained pointSoundRetained = (PointSoundRetained)soundSchedulerAtom.sound;
        PointSoundRetained pointSoundRetained2 = (PointSoundRetained)pointSoundRetained.sgSound;
        int n = soundSchedulerAtom.sampleId;
        if (n == -1) {
            return;
        }
        PointSoundRetained pointSoundRetained3 = pointSoundRetained;
        if (bl || this.testListenerFlag() || soundSchedulerAtom.testDirtyFlag(soundSchedulerAtom.attribsDirty, 64) || soundSchedulerAtom.testDirtyFlag(soundSchedulerAtom.stateDirty, 32768)) {
            cloneable2 = new Point3f();
            pointSoundRetained.getXformPosition((Point3f)cloneable2);
            cloneable = new Point3d((Point3f)cloneable2);
            this.audioDevice3D.setPosition(n, (Point3d)cloneable);
        }
        if (pointSoundRetained instanceof ConeSoundRetained) {
            cloneable2 = (ConeSoundRetained)pointSoundRetained;
            cloneable = (ConeSoundRetained)pointSoundRetained.sgSound;
            if (bl || soundSchedulerAtom.testDirtyFlag(soundSchedulerAtom.attribsDirty, 33280)) {
                Vector3f vector3f = new Vector3f();
                ((ConeSoundRetained)cloneable2).getXformDirection(vector3f);
                Vector3d vector3d = new Vector3d(vector3f);
                this.audioDevice3D.setDirection(n, vector3d);
            }
        }
    }

    void updateSoundParams(boolean bl, SoundSchedulerAtom soundSchedulerAtom, AuralAttributesRetained auralAttributesRetained) {
        float[] fArray;
        Object[] objectArray;
        Object[] objectArray2;
        Point2f[] point2fArray;
        int n;
        PointSoundRetained pointSoundRetained;
        SoundRetained soundRetained = soundSchedulerAtom.sound;
        SoundRetained soundRetained2 = soundRetained.sgSound;
        int n2 = soundSchedulerAtom.sampleId;
        if (n2 == -1) {
            return;
        }
        if (bl || soundSchedulerAtom.testDirtyFlag(soundSchedulerAtom.attribsDirty, 2)) {
            if (auralAttributesRetained != null) {
                this.audioDevice3D.setSampleGain(n2, soundRetained2.initialGain * auralAttributesRetained.attributeGain);
            } else {
                this.audioDevice3D.setSampleGain(n2, soundRetained2.initialGain);
            }
        }
        if (bl || soundSchedulerAtom.testDirtyFlag(soundSchedulerAtom.attribsDirty, 4)) {
            this.audioDevice3D.setLoop(n2, soundRetained2.loopCount);
        }
        if ((bl || soundSchedulerAtom.testDirtyFlag(soundSchedulerAtom.attribsDirty, 2048)) && this.audioDevice3DL2 != null) {
            this.audioDevice3DL2.setRateScaleFactor(n2, soundRetained2.rate);
        }
        if (bl || soundSchedulerAtom.testDirtyFlag(soundSchedulerAtom.attribsDirty, 128)) {
            if (soundRetained2 instanceof ConeSoundRetained) {
                pointSoundRetained = (ConeSoundRetained)soundRetained2;
                n = pointSoundRetained.getDistanceGainLength();
                if (n == 0) {
                    this.audioDevice3D.setDistanceGain(n2, null, null, null, null);
                } else {
                    point2fArray = new Point2f[n];
                    objectArray2 = new Point2f[n];
                    for (int i = 0; i < n; ++i) {
                        point2fArray[i] = new Point2f();
                        objectArray2[i] = new Point2f();
                    }
                    ((ConeSoundRetained)pointSoundRetained).getDistanceGain(point2fArray, (Point2f[])objectArray2);
                    objectArray = new double[n];
                    fArray = new float[n];
                    double[] dArray = new double[n];
                    float[] fArray2 = new float[n];
                    for (int i = 0; i < n; ++i) {
                        objectArray[i] = point2fArray[i].x;
                        fArray[i] = point2fArray[i].y;
                        dArray[i] = objectArray2[i].x;
                        fArray2[i] = objectArray2[i].y;
                    }
                    this.audioDevice3D.setDistanceGain(n2, (double[])objectArray, fArray, dArray, fArray2);
                }
            } else if (soundRetained2 instanceof PointSoundRetained) {
                pointSoundRetained = (PointSoundRetained)soundRetained2;
                n = pointSoundRetained.getDistanceGainLength();
                if (n == 0) {
                    this.audioDevice3D.setDistanceGain(n2, null, null, null, null);
                } else {
                    point2fArray = new Point2f[n];
                    for (int i = 0; i < n; ++i) {
                        point2fArray[i] = new Point2f();
                    }
                    pointSoundRetained.getDistanceGain(point2fArray);
                    objectArray2 = new double[n];
                    objectArray = new float[n];
                    for (int i = 0; i < n; ++i) {
                        objectArray2[i] = (Point2f)((double)point2fArray[i].x);
                        objectArray[i] = point2fArray[i].y;
                    }
                    this.audioDevice3D.setDistanceGain(n2, (double[])objectArray2, (float[])objectArray, null, null);
                }
            }
        }
        if (soundRetained2 instanceof ConeSoundRetained && (bl || soundSchedulerAtom.testDirtyFlag(soundSchedulerAtom.attribsDirty, 1024))) {
            pointSoundRetained = (ConeSoundRetained)soundRetained2;
            n = ((ConeSoundRetained)pointSoundRetained).getAngularAttenuationLength();
            if (n == 0) {
                point2fArray = (Point2f[])new double[2];
                objectArray2 = new float[2];
                point2fArray[0] = (Point2f)0.0;
                point2fArray[1] = (Point2f)1.5707963267948966;
                objectArray2[0] = (Point2f)1.0f;
                objectArray2[1] = (Point2f)0.0f;
                this.audioDevice3D.setAngularAttenuation(n2, -1, (double[])point2fArray, (float[])objectArray2, null);
            } else {
                point2fArray = new Point3f[n];
                for (int i = 0; i < n; ++i) {
                    point2fArray[i] = new Point3f();
                }
                ((ConeSoundRetained)pointSoundRetained).getAngularAttenuation((Point3f[])point2fArray);
                double[] dArray = new double[n];
                objectArray = new float[n];
                fArray = new float[n];
                for (int i = 0; i < n; ++i) {
                    dArray[i] = ((Point3f)((Object)point2fArray[i])).x;
                    objectArray[i] = ((Point3f)((Object)point2fArray[i])).y;
                    fArray[i] = ((Point3f)((Object)point2fArray[i])).z;
                }
                this.audioDevice3D.setAngularAttenuation(n2, ((ConeSoundRetained)pointSoundRetained).filterType, dArray, (float[])objectArray, fArray);
            }
        }
    }

    boolean checkAudioDevice3D() {
        if (this.universe != null && this.universe.currentView != null && this.universe.currentView.physicalEnvironment != null) {
            this.audioDevice = this.universe.currentView.physicalEnvironment.audioDevice;
            if (this.audioDevice != null) {
                if (this.audioDevice instanceof AudioDevice3DL2) {
                    this.audioDevice3DL2 = (AudioDevice3DL2)this.audioDevice;
                }
                if (this.audioDevice instanceof AudioDevice3D) {
                    this.audioDevice3D = (AudioDevice3D)this.audioDevice;
                }
            } else {
                this.audioDevice3DL2 = null;
                this.audioDevice3D = null;
            }
        }
        if (this.audioDevice3D == null) {
            return false;
        }
        return this.audioDevice3D.getTotalChannels() != 0;
    }

    void clearSoundData(SoundSchedulerAtom soundSchedulerAtom) {
        if (this.checkAudioDevice3D() && soundSchedulerAtom.sampleId != -1) {
            this.stopSound(soundSchedulerAtom, false);
            this.audioDevice3D.clearSound(soundSchedulerAtom.sampleId);
        }
        soundSchedulerAtom.sampleId = -1;
        soundSchedulerAtom.loadStatus = 0;
        SoundRetained soundRetained = soundSchedulerAtom.sound;
        soundSchedulerAtom.loadStatus = 0;
        soundSchedulerAtom.soundData = null;
        soundRetained.changeAtomList(soundSchedulerAtom, 0);
    }

    void attachSoundData(SoundSchedulerAtom soundSchedulerAtom, MediaContainer mediaContainer, boolean bl) {
        if (!bl && soundSchedulerAtom.soundData == mediaContainer) {
            return;
        }
        SoundRetained soundRetained = soundSchedulerAtom.sound.sgSound;
        if (!this.checkAudioDevice3D()) {
            soundSchedulerAtom.loadStatus = 1;
            soundRetained.changeAtomList(soundSchedulerAtom, 1);
            return;
        }
        if (soundSchedulerAtom.soundData != null) {
            this.clearSoundData(soundSchedulerAtom);
            if (mediaContainer == null) {
                return;
            }
        }
        URL uRL = ((MediaContainerRetained)soundRetained.soundData.retained).url;
        String string = ((MediaContainerRetained)soundRetained.soundData.retained).urlString;
        InputStream inputStream = ((MediaContainerRetained)soundRetained.soundData.retained).inputStream;
        if (uRL == null && string == null && inputStream == null) {
            if (soundSchedulerAtom.sampleId != -1) {
                this.clearSoundData(soundSchedulerAtom);
            }
            return;
        }
        soundRetained.soundType = soundRetained instanceof ConeSoundRetained ? 3 : (soundRetained instanceof PointSoundRetained ? 2 : 1);
        MediaContainer mediaContainer2 = new MediaContainer();
        mediaContainer2.duplicateAttributes(mediaContainer, true);
        mediaContainer2.setCapability(0);
        mediaContainer2.setCapability(2);
        int n = this.audioDevice3D.prepareSound(soundRetained.soundType, mediaContainer2);
        if (n == -1) {
            soundSchedulerAtom.loadStatus = -1;
            soundRetained.changeAtomList(soundSchedulerAtom, -1);
        } else {
            long l;
            soundSchedulerAtom.sampleId = n;
            soundSchedulerAtom.loopLength = soundSchedulerAtom.sampleLength = (l = this.audioDevice3D.getSampleDuration(n));
            soundSchedulerAtom.loopStartOffset = 0L;
            soundSchedulerAtom.attackLength = 0L;
            soundSchedulerAtom.releaseLength = 0L;
            soundSchedulerAtom.loadStatus = 2;
            soundSchedulerAtom.soundData = mediaContainer;
            soundRetained.changeAtomList(soundSchedulerAtom, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SoundSchedulerAtom findSoundAtom(SoundRetained soundRetained, int n) {
        if (soundRetained == null) {
            return null;
        }
        SoundSchedulerAtom soundSchedulerAtom = null;
        ArrayList arrayList = this.prioritizedSounds;
        synchronized (arrayList) {
            if (!this.prioritizedSounds.isEmpty()) {
                SoundSchedulerAtom soundSchedulerAtom2 = null;
                int n2 = 0;
                int n3 = this.prioritizedSounds.size();
                for (int i = 0; i < n3; ++i) {
                    soundSchedulerAtom2 = (SoundSchedulerAtom)this.prioritizedSounds.get(i);
                    if (soundSchedulerAtom2.sound == null) continue;
                    if (soundSchedulerAtom2.sound.sgSound == soundRetained) {
                        if (++n2 != n) continue;
                        soundSchedulerAtom = soundSchedulerAtom2;
                        break;
                    }
                    if (soundSchedulerAtom2.sound.sgSound != soundRetained.sgSound) continue;
                    soundSchedulerAtom2.sound = soundRetained;
                    if (++n2 != n) continue;
                    soundSchedulerAtom = soundSchedulerAtom2;
                    break;
                }
            }
        }
        return soundSchedulerAtom;
    }

    void setListenerFlag(int n) {
        this.listenerUpdated |= n;
    }

    void clearListenerFlag() {
        this.listenerUpdated = 0;
    }

    boolean testListenerFlag() {
        return this.listenerUpdated > 0;
    }

    void setAttribsDirtyFlag(SoundRetained soundRetained, int n) {
        SoundSchedulerAtom soundSchedulerAtom = null;
        int n2 = 1;
        while ((soundSchedulerAtom = this.findSoundAtom(soundRetained, n2)) != null) {
            soundSchedulerAtom.setAttribsDirtyFlag(n);
            ++n2;
        }
    }

    void setStateDirtyFlag(SoundRetained soundRetained, int n) {
        SoundSchedulerAtom soundSchedulerAtom = null;
        int n2 = 1;
        while ((soundSchedulerAtom = this.findSoundAtom(soundRetained, n2)) != null) {
            soundSchedulerAtom.setStateDirtyFlag(n);
            ++n2;
        }
    }

    void printAtomState(SoundSchedulerAtom soundSchedulerAtom) {
        SoundRetained soundRetained = soundSchedulerAtom.sound.sgSound;
        this.debugPrint("                  this atom = " + soundSchedulerAtom + "       ");
        this.debugPrint("                 references sound = " + soundRetained + "       ");
        this.debugPrint("                 enabled " + soundSchedulerAtom.enabled);
        this.debugPrint("                 status " + soundSchedulerAtom.status);
        this.debugPrint("                 activated " + soundSchedulerAtom.activated);
        this.debugPrint("                 released " + soundRetained.release);
        this.debugPrint("                 continuous " + soundRetained.continuous);
        this.debugPrint("                 scheduling " + soundSchedulerAtom.schedulingAction);
    }

    void debugPrint(String string) {
    }

    void processViewSpecificGroupChanged(J3dMessage j3dMessage) {
        Object e;
        int n;
        int n2;
        Object object;
        Object object2;
        int n3 = (Integer)j3dMessage.args[0];
        Object[] objectArray = (Object[])j3dMessage.args[1];
        if ((n3 & 2) != 0 || (n3 & 1) != 0) {
            object2 = (View)objectArray[0];
            object = (ArrayList)objectArray[2];
            if (object2 == this.view) {
                n2 = ((ArrayList)object).size();
                for (n = 0; n < n2; ++n) {
                    e = ((ArrayList)object).get(n);
                    if (e instanceof SoundRetained) {
                        ++this.nRetainedSounds;
                        this.addSound((SoundRetained)e);
                        continue;
                    }
                    if (!(e instanceof SoundscapeRetained)) continue;
                    this.auralAttribsChanged = true;
                }
            }
        }
        if ((n3 & 4) != 0 || (n3 & 1) != 0) {
            if ((n3 & 4) != 0) {
                object = (View)objectArray[0];
                object2 = (ArrayList)objectArray[2];
            } else {
                object = (View)objectArray[4];
                object2 = (ArrayList)objectArray[6];
            }
            if (object == this.view) {
                n2 = ((ArrayList)object2).size();
                for (n = 0; n < n2; ++n) {
                    e = ((ArrayList)object2).get(n);
                    if (e instanceof SoundRetained) {
                        SoundSchedulerAtom soundSchedulerAtom = null;
                        int n4 = 1;
                        while ((soundSchedulerAtom = this.findSoundAtom((SoundRetained)e, n4)) != null) {
                            this.stopSound(soundSchedulerAtom, false);
                            ++n4;
                        }
                        continue;
                    }
                    if (!(e instanceof SoundscapeRetained)) continue;
                    this.auralAttribsChanged = true;
                }
            }
        }
    }

    void processBoundingLeafChanged(J3dMessage j3dMessage) {
        Object[] objectArray = (Object[])j3dMessage.args[3];
        for (int i = 0; i < objectArray.length; ++i) {
            LeafRetained leafRetained = (LeafRetained)objectArray[i];
            if (leafRetained instanceof SoundRetained && this.universe.soundStructure.isSoundScopedToView(leafRetained, this.view)) {
                this.auralAttribsChanged = true;
                continue;
            }
            if (!(leafRetained instanceof SoundscapeRetained) || !this.universe.soundStructure.isSoundscapeScopedToView(leafRetained, this.view)) continue;
            this.auralAttribsChanged = true;
        }
    }

    void cleanup() {
    }
}

