/*
 * Decompiled with CFR 0.152.
 */
package com.strobe.orbit;

import com.strobe.orbit.Planet;
import com.strobe.orbit.SolarSystemTransport;
import processing.core.PApplet;
import toxi.geom.ReadonlyVec2D;
import toxi.geom.Vec2D;

class Body
extends Vec2D {
    float distance = 0.0f;
    Body prev = null;
    Planet parent = null;
    float mySize;
    float displaySize;
    int lNum = 0;
    String name;
    boolean animate = false;
    boolean follow = false;
    int animateStart = 0;
    int myColor;
    float ellipseE;
    float ellipseA;
    float ellipseB;
    float ellipseCenter;
    float orbit_speed;
    float pathAngle;
    boolean showLabel = false;
    protected SolarSystemTransport parentApp;

    Body() {
        super(0.0f, 0.0f);
    }

    Body(SolarSystemTransport parentApp, String name, float sz) {
        super(0.0f, 0.0f);
        this.parentApp = parentApp;
        this.name = name;
        ((Object)((Object)parentApp)).getClass();
        this.displaySize = this.mySize = SolarSystemTransport.map((float)sz, (float)0.0f, (float)1.2E9f, (float)0.0f, (float)(parentApp.width / 2));
    }

    Body(SolarSystemTransport parentApp, Planet parent, String name, float sz, int lNum) {
        this(parentApp, name, sz);
        this.parent = parent;
        this.lNum = lNum;
        this.myColor = parentApp.color(255, 0, 0);
    }

    void display() {
        if (this.animate) {
            if (this.parentApp.TICK - this.animateStart < 6) {
                this.displaySize += 1.0f;
            } else if (this.parentApp.TICK - this.animateStart < 11) {
                this.displaySize -= 1.0f;
            } else {
                this.animate = false;
            }
        }
        this.parentApp.fill(this.myColor);
        this.parentApp.translate(this.x, this.y, 0.0f);
        this.parentApp.sphere(this.displaySize);
        this.parentApp.translate(-this.x, -this.y, 0.0f);
    }

    Vec2D getProjectedDest(Body dest) {
        int t = 1;
        while (t < 10000) {
            Vec2D projectedDest = dest.locationAtTime(t);
            Vec2D projectedVelocity = projectedDest.sub((Vec2D)this).normalize().scale(this.parentApp.ROCKET_SPEED);
            if (this.add(projectedVelocity.scale((float)t).scale(this.parentApp.SIM_SPEED)).distanceTo((ReadonlyVec2D)projectedDest) < 5.0f) {
                return projectedDest;
            }
            ++t;
        }
        return null;
    }

    void setSize(float sz) {
        this.displaySize = sz;
    }

    int getArrivalTimeITN(Body dest, int startTime) {
        Vec2D realLoc = this.locationAtTime(startTime);
        int t = startTime;
        while (t < startTime + 10000) {
            Vec2D projectedDest = dest.locationAtTime(t);
            Vec2D projectedVelocity = projectedDest.sub(realLoc).normalize().scale(this.parentApp.ROCKET_SPEED);
            if (realLoc.add(projectedVelocity.scale((float)(t - startTime)).scale(this.parentApp.SIM_SPEED)).distanceTo((ReadonlyVec2D)projectedDest) < 5.0f) {
                return t;
            }
            ++t;
        }
        return Integer.MAX_VALUE;
    }

    boolean mouseOver() {
        return PApplet.dist((float)this.parentApp.screenX(this.x, this.y, 0.0f), (float)this.parentApp.screenY(this.x, this.y, 0.0f), (float)this.parentApp.mouseX, (float)this.parentApp.mouseY) < (float)(this.parentApp.SNAP_DIST * 2);
    }

    void animate() {
        this.animate = true;
        this.animateStart = this.parentApp.TICK;
    }

    Vec2D locationAtTime(int steps) {
        switch (this.lNum) {
            case 0: {
                return new Vec2D(this.ellipseCenter + this.ellipseA * PApplet.sin((float)this.angleAtTime(steps)), this.ellipseB * PApplet.cos((float)this.angleAtTime(steps)));
            }
            case 1: {
                return this.parent.locationAtTime(steps).scale(0.95f);
            }
            case 2: {
                return this.parent.locationAtTime(steps).scale(1.15f);
            }
            case 3: {
                return this.parent.locationAtTime(steps).getRotated((float)Math.PI);
            }
            case 4: {
                return this.parent.locationAtTime(steps).getRotated(1.0471976f);
            }
            case 5: {
                return this.parent.locationAtTime(steps).getRotated(-1.0471976f);
            }
        }
        return null;
    }

    float angleAtTime(int steps) {
        return this.pathAngle + (float)steps * this.orbit_speed * this.parentApp.SIM_SPEED;
    }

    Vec2D locationAtAngle(float angle) {
        return new Vec2D(this.ellipseCenter + this.ellipseA * PApplet.cos((float)angle), this.ellipseB * PApplet.sin((float)angle));
    }
}

