/*
 * Decompiled with CFR 0.152.
 */
package com.strobe.orbit;

import com.strobe.orbit.Body;
import com.strobe.orbit.Edge;
import com.strobe.orbit.SolarSystemTransport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import toxi.geom.ReadonlyVec2D;

class BodyGraph
implements Iterable<Body>,
Iterator<Body> {
    private ArrayList<Body> vertices = new ArrayList();
    private ArrayList<Edge> edges = new ArrayList();
    SolarSystemTransport parentApp;

    BodyGraph(SolarSystemTransport parentApp) {
        this.parentApp = parentApp;
    }

    void addVertex(Body node) {
        this.vertices.add(node);
    }

    void addEdge(Body node1, Body node2) {
        this.edges.add(new Edge(node1, node2));
    }

    ArrayList<Body> getNeighbors(Body body) {
        ArrayList<Body> neighbors = new ArrayList<Body>();
        for (Edge edge : this.edges) {
            Body neighbor = edge.getNeighbor(body);
            if (neighbor == null) continue;
            neighbors.add(neighbor);
        }
        return neighbors;
    }

    Body get(String name) {
        for (Body b : this.vertices) {
            if (!b.name.equals(name)) continue;
            return b;
        }
        return null;
    }

    public ArrayList<Body> vertices() {
        return this.vertices;
    }

    @Override
    public Iterator iterator() {
        return this.vertices.iterator();
    }

    @Override
    public Body next() {
        return this.vertices.iterator().next();
    }

    @Override
    public boolean hasNext() {
        return this.vertices.iterator().hasNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    boolean isEmpty() {
        return this.vertices.isEmpty();
    }

    Stack<Body> dijkstra(Body a, Body b) {
        ArrayList vertices = (ArrayList)this.parentApp.bodyGraph.vertices().clone();
        for (Body ver : vertices) {
            ver.distance = Float.MAX_VALUE;
            ver.prev = null;
        }
        a.distance = 0.0f;
        while (!vertices.isEmpty()) {
            Body body = this.parentApp.getSmallestDist(vertices);
            if (body.distance == Float.MAX_VALUE) break;
            vertices.remove((Object)body);
            for (Body neighbor : this.parentApp.bodyGraph.getNeighbors(body)) {
                float altDist;
                if (!vertices.contains((Object)neighbor) || !((altDist = body.distance + body.distanceTo((ReadonlyVec2D)neighbor)) < neighbor.distance)) continue;
                neighbor.distance = altDist;
                neighbor.prev = body;
            }
        }
        Stack<Body> path = new Stack<Body>();
        while (b.prev != null) {
            path.push(b);
            b = b.prev;
        }
        path.push(a);
        return (Stack)path.clone();
    }
}

