/*
 * Decompiled with CFR 0.152.
 */
package com.strobe.orbit;

import com.strobe.orbit.Body;
import com.strobe.orbit.SolarSystemTransport;
import controlP5.Textlabel;
import processing.core.PApplet;
import toxi.geom.ReadonlyVec2D;
import toxi.geom.Vec2D;

class Planet
extends Body {
    float angle_to_ecliptic;
    Body[] lagranges = new Body[5];
    int tick;

    Planet(SolarSystemTransport parentApp, String name, float sz, float ellipseA, float ellipseE, float pathAngle, float angle_to_ecliptic, int theColor) {
        super(parentApp, name, sz);
        int i = 0;
        while (i < this.lagranges.length) {
            this.lagranges[i] = new Body(parentApp, this, String.valueOf(name) + "l" + (i + 1), sz, i + 1);
            this.lagranges[i].setSize(this.mySize);
            parentApp.bodyGraph.addVertex(this.lagranges[i]);
            ++i;
        }
        ((Object)((Object)parentApp)).getClass();
        ((Object)((Object)parentApp)).getClass();
        this.ellipseA = PApplet.map((float)(ellipseA * 1.49598E8f), (float)0.0f, (float)1.2E9f, (float)0.0f, (float)(parentApp.width / 2));
        this.ellipseE = ellipseE;
        this.ellipseCenter = this.ellipseA * ellipseE;
        this.ellipseB = (float)((double)this.ellipseA * Math.sqrt(1.0f - ellipseE * ellipseE));
        this.orbit_speed = ellipseA == 0.0f ? 0.0f : 1.0f / ellipseA;
        this.angle_to_ecliptic = PApplet.radians((float)angle_to_ecliptic);
        this.pathAngle = PApplet.radians((float)pathAngle);
        this.myColor = theColor;
        this.update();
        parentApp.bodyGraph.addVertex(this);
    }

    void setupGraph(Planet next) {
        this.parentApp.bodyGraph.addEdge(this, this.lagranges[0]);
        this.parentApp.bodyGraph.addEdge(this, this.lagranges[1]);
        this.parentApp.bodyGraph.addEdge(this.lagranges[1], this.lagranges[3]);
        this.parentApp.bodyGraph.addEdge(this.lagranges[1], this.lagranges[4]);
        if (next != null) {
            int i = 1;
            while (i < this.lagranges.length) {
                int j = 0;
                while (j < this.lagranges.length) {
                    if (j != 1) {
                        this.parentApp.bodyGraph.addEdge(this.lagranges[i], next.lagranges[j]);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    @Override
    void display() {
        if (this.isMouseOverOrbit()) {
            this.parentApp.strokeWeight(3.0f);
            this.follow = true;
            ((Textlabel)this.parentApp.controlP5.controller("planetName")).setValue(String.valueOf(this.name.toUpperCase()));
        } else {
            this.parentApp.strokeWeight(1.0f);
            this.follow = false;
        }
        this.parentApp.stroke(this.myColor);
        if (this.parentApp.showOrbits) {
            this.parentApp.noFill();
            this.parentApp.ellipse(this.ellipseCenter, 0.0f, this.ellipseA, this.ellipseB);
        }
        this.parentApp.noStroke();
        if (this.parentApp.showLagrange && !this.equals((Object)this.parentApp.planets[0])) {
            this.showLagrange();
        }
        if (this.parentApp.showPlanets) {
            super.display();
        }
    }

    void tick() {
        this.pathAngle += this.orbit_speed * this.parentApp.SIM_SPEED;
        this.set(this.ellipseCenter + this.ellipseA * SolarSystemTransport.sin((float)this.pathAngle), this.ellipseB * SolarSystemTransport.cos((float)this.pathAngle));
        this.update();
    }

    void update() {
        this.lagranges[0].set(this.scale(0.95f));
        this.lagranges[1].set(this.scale(1.15f));
        this.lagranges[2].set(this.getRotated((float)Math.PI));
        this.lagranges[3].set(this.getRotated(1.0471976f));
        this.lagranges[4].set(this.getRotated(-1.0471976f));
    }

    boolean isMouseOverOrbit() {
        float i = 0.0f;
        while (i < (float)Math.PI * 2) {
            float f = SolarSystemTransport.dist((float)this.parentApp.screenX(this.ellipseCenter + this.ellipseA * SolarSystemTransport.sin((float)i), this.ellipseB * SolarSystemTransport.cos((float)i), 0.0f), (float)this.parentApp.screenY(this.ellipseCenter + this.ellipseA * SolarSystemTransport.sin((float)i), this.ellipseB * SolarSystemTransport.cos((float)i), 0.0f), (float)this.parentApp.mouseX, (float)this.parentApp.mouseY);
            ((Object)((Object)this.parentApp)).getClass();
            if (f < 5.0f) {
                return true;
            }
            i += (float)Math.PI / this.ellipseA;
        }
        return false;
    }

    void setSizeFactor(float sizeFactor) {
        this.displaySize = this.mySize * sizeFactor;
        int i = 0;
        while (i < this.lagranges.length) {
            this.lagranges[i].setSize(this.displaySize);
            ++i;
        }
    }

    void showLagrange() {
        Body[] bodyArray = this.lagranges;
        int n = this.lagranges.length;
        int n2 = 0;
        while (n2 < n) {
            Body l = bodyArray[n2];
            l.display();
            this.parentApp.fill(255);
            ++n2;
        }
    }

    @Override
    Vec2D locationAtAngle(float angle) {
        return new Vec2D(this.ellipseCenter + this.ellipseA * SolarSystemTransport.sin((float)angle), this.ellipseB * SolarSystemTransport.cos((float)angle));
    }

    float angle() {
        float angle = this.getNormalized().angleBetween((ReadonlyVec2D)new Vec2D(1.0f, 0.0f));
        return this.y < 0.0f ? -(angle + (float)Math.PI) : angle + (float)Math.PI;
    }
}

