/*
 * Decompiled with CFR 0.152.
 */
package com.strobe.orbit;

import com.strobe.orbit.Body;
import com.strobe.orbit.Planet;
import com.strobe.orbit.SolarSystemTransport;
import java.util.Stack;
import processing.core.PApplet;
import toxi.geom.ReadonlyVec2D;
import toxi.geom.Vec2D;

class Rocket
extends Body {
    Stack<Body> myPath;
    Vec2D prevLoc = null;
    Vec2D myVelocity;
    int tick = 0;
    float currBest = Float.MAX_VALUE;
    boolean waitingITN = false;
    boolean launchITN = false;
    boolean waitingHohmann = false;
    boolean launchHohmann = false;
    float ellipseAngle = 0.0f;
    Planet source;
    Planet dest;
    private int incrCounter = 0;

    Rocket(SolarSystemTransport parentApp, Planet source, Planet dest) {
        this.parentApp = parentApp;
        this.name = "rocket";
        this.myColor = parentApp.color(130);
        this.source = source;
        this.dest = dest;
        this.displaySize = 0.5f;
        this.updateHohmann();
    }

    @Override
    void display() {
        if (this.mouseOver()) {
            this.myColor = this.parentApp.color(200);
            this.follow = true;
        } else {
            this.myColor = this.parentApp.color(130);
            this.follow = false;
        }
        this.parentApp.noStroke();
        this.parentApp.translate(this.x(), this.y(), 0.0f);
        this.parentApp.fill(255.0f, 160.0f, 0.0f);
        this.parentApp.cylinder(4.0f * this.displaySize, 3.0f * this.displaySize, 15);
        this.parentApp.fill(this.myColor);
        if (this.myVelocity != null) {
            float rotation = PApplet.tan((float)(this.myVelocity.y() / this.myVelocity.x())) - 1.5707964f;
            this.parentApp.rotate(rotation);
        }
    }

    void update() {
        if (!this.launchHohmann && !this.launchITN) {
            this.set(this.source);
        }
        if (this.waitingITN) {
            if (this.parentApp.TICK % 3 == 0 && this.itnLaunchWindow()) {
                this.waitingITN = false;
                this.launchITN = true;
            }
        } else if (this.waitingHohmann) {
            if (this.hohmannLaunchWindow()) {
                this.waitingHohmann = false;
                this.prevLoc = this.source;
                this.launchHohmann = true;
                this.pathAngle = -1.5707964f;
            }
        } else if (this.launchHohmann) {
            this.tickHohmann();
        }
    }

    Vec2D getITNVelocity(Body dest) {
        int t = 1;
        while (t < 10000) {
            Vec2D projectedDest = dest.locationAtTime(t);
            Vec2D projectedVelocity = projectedDest.sub((Vec2D)this).normalize().scale(this.parentApp.ROCKET_SPEED);
            if (this.add(projectedVelocity.scale((float)t).scale(this.parentApp.SIM_SPEED)).distanceTo((ReadonlyVec2D)projectedDest) < 5.0f) {
                return projectedVelocity;
            }
            ++t;
        }
        return null;
    }

    void waitITN() {
        this.waitingITN = true;
        this.launchITN = false;
        this.launchHohmann = false;
        this.waitingHohmann = false;
        this.myPath = this.parentApp.getPath(this.source, this.dest);
        this.currBest = this.dest.distance;
    }

    void waitHohmann() {
        this.waitingHohmann = true;
        this.launchHohmann = false;
        this.launchITN = false;
        this.waitingITN = false;
    }

    @Override
    void setSize(float newSize) {
        this.displaySize = newSize;
    }

    void setSource(Planet source) {
        this.source = source;
        if (this.waitingITN) {
            this.parentApp.ITN(0);
        }
    }

    void setDest(Planet dest) {
        this.dest = dest;
        if (this.waitingITN) {
            this.parentApp.ITN(0);
        }
    }

    void previewITN() {
        Body[] pathList;
        if (!this.launchITN && !this.waitingITN) {
            this.myPath = this.parentApp.getPath(this.source, this.dest);
        }
        if ((pathList = this.myPath.toArray(new Body[this.myPath.size()])).length == 0) {
            return;
        }
        this.parentApp.noFill();
        this.parentApp.stroke(this.parentApp.color(255, 0, 0));
        this.parentApp.beginShape();
        this.parentApp.vertex(pathList[pathList.length - 1].x(), pathList[pathList.length - 1].y());
        int i = pathList.length - 1;
        while (i > 0) {
            Vec2D between = pathList[i - 1].sub(pathList[i]).scale(0.5f);
            float angleC1 = i % 2 == 0 ? 0.7853982f : -0.7853982f;
            Vec2D c1 = pathList[i].add(between.rotate(angleC1));
            Vec2D c2 = pathList[i - 1].add(between.rotate(angleC1 * 2.0f));
            this.parentApp.bezierVertex(c1.x(), c1.y(), c2.x(), c2.y(), pathList[i - 1].x(), pathList[i - 1].y());
            --i;
        }
        this.parentApp.endShape();
    }

    void previewHohmann() {
        if (!this.launchHohmann) {
            this.updateHohmann();
        }
        this.parentApp.noFill();
        this.parentApp.stroke(this.parentApp.color(255, 0, 0));
        this.parentApp.strokeWeight(2.0f);
        this.parentApp.rotateZ(this.ellipseAngle);
        this.parentApp.beginShape(2);
        float i = 0.0f;
        while (i < (float)Math.PI * 2) {
            this.parentApp.vertex(this.ellipseCenter + this.ellipseA * PApplet.sin((float)i), this.ellipseB * PApplet.cos((float)i));
            i += 0.12566371f;
        }
        this.parentApp.endShape();
        this.parentApp.rotateZ(-this.ellipseAngle);
    }

    void updateHohmann() {
        float angle = this.getNormalized().angleBetween((ReadonlyVec2D)new Vec2D(1.0f, 0.0f));
        angle = this.y < 0.0f ? angle - 1.5707964f : -angle - 1.5707964f;
        this.ellipseA = this.source.distanceTo((ReadonlyVec2D)this.dest.locationAtAngle(angle)) / 2.0f;
        this.ellipseE = 1.0f - this.source.distanceTo((ReadonlyVec2D)this.parentApp.planets[0]) / this.ellipseA;
        this.ellipseB = (float)((double)this.ellipseA * Math.sqrt(1.0f - this.ellipseE * this.ellipseE));
        ((Object)((Object)this.parentApp)).getClass();
        float f = this.ellipseA / 1.49598E8f;
        float f2 = this.parentApp.width / 2;
        ((Object)((Object)this.parentApp)).getClass();
        this.orbit_speed = 1.0f / SolarSystemTransport.map((float)f, (float)0.0f, (float)f2, (float)0.0f, (float)1.2E9f);
        this.ellipseCenter = this.ellipseA * this.ellipseE;
        this.ellipseAngle = this.pathAngle = this.source.angle();
    }

    void tickHohmann() {
        this.pathAngle += this.orbit_speed * this.parentApp.SIM_SPEED;
        Vec2D nextLoc = new Vec2D(this.ellipseCenter + this.ellipseA * SolarSystemTransport.sin((float)this.pathAngle), this.ellipseB * SolarSystemTransport.cos((float)this.pathAngle)).getRotated(this.ellipseAngle);
        Vec2D projected = this.locationAtAngle(0.0f).rotate(this.ellipseAngle);
        this.myVelocity = projected.y > 0.0f ? projected.rotate(1.5707964f) : projected;
        this.prevLoc = new Vec2D((ReadonlyVec2D)this);
        this.set(nextLoc);
        if (this.distanceTo((ReadonlyVec2D)this.dest) < (float)(this.parentApp.SNAP_DIST * 2)) {
            this.dest.animate();
            this.launchHohmann = false;
            if (this.parentApp.followBody == this) {
                this.parentApp.followBody = this.dest;
            }
            this.parentApp.resetProgress();
        }
        this.display();
    }

    boolean itnLaunchWindow() {
        float goal = this.source.distanceTo((ReadonlyVec2D)this.dest);
        this.myPath = this.parentApp.getPath(this.source, this.dest);
        if (this.dest.distance < this.currBest) {
            this.currBest = this.dest.distance;
        }
        this.parentApp.setProgress(SolarSystemTransport.map((float)(goal / this.currBest), (float)0.8f, (float)1.0f, (float)0.0f, (float)1.0f));
        return this.currBest <= goal;
    }

    boolean hohmannLaunchWindow() {
        Vec2D destProject = this.dest.locationAtTime((int)((float)Math.PI / (this.orbit_speed * this.parentApp.SIM_SPEED)));
        float distance = this.locationAtAngle(0.0f).getRotated(this.pathAngle).distanceTo((ReadonlyVec2D)destProject);
        float goal = this.parentApp.SNAP_DIST * 2;
        this.parentApp.setProgress(goal / distance);
        return distance <= goal;
    }
}

