/*
 * Decompiled with CFR 0.152.
 */
package com.strobe.orbit;

import com.strobe.orbit.Body;
import com.strobe.orbit.BodyGraph;
import com.strobe.orbit.Planet;
import com.strobe.orbit.Rocket;
import com.strobe.orbit.TravelInformation;
import controlP5.ControlGroup;
import controlP5.ControlP5;
import controlP5.ControllerGroup;
import controlP5.MultiList;
import controlP5.MultiListButton;
import controlP5.Textarea;
import controlP5.Textlabel;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Stack;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import toxi.geom.Vec3D;

public class SolarSystemTransport
extends PApplet {
    PGraphics cp5;
    ControlP5 controlP5;
    MultiList pathList;
    MultiListButton s;
    MultiListButton d;
    Textarea helpText;
    final int AU = 149598000;
    final int SCALE_FACTOR = 1200000000;
    final int SNAP_DIST = 5;
    final int RED = this.color(255, 0, 0);
    int TICK = 0;
    int animateStart = 0;
    float SIM_SPEED = 0.02f;
    float ROCKET_SPEED = 100.0f;
    float rotateXVal = 0.0f;
    float rotateYVal = 0.0f;
    float rotateCamX = 0.0f;
    float rotateCamZ = 0.0f;
    float camZoom = 20.0f;
    float zoom = -200.0f;
    boolean showOrbits = true;
    boolean showPlanets = true;
    boolean showLagrange = false;
    Vec3D cameraVec = new Vec3D(0.0f, 0.0f, 0.0f);
    BodyGraph bodyGraph;
    Body followBody = null;
    Rocket rocket = null;
    Planet[] planets = new Planet[8];
    private TravelInformation information;
    private String[] tableHead = new String[]{"V1 (km/s)", "V2 (km/s)", "Delta V1  (km/s)", "Delta V2  (km/s)", "T (years)"};
    private String[] tableValues = new String[]{"38.6361882600935", "7.42575211610484", "8.80618826009348", "5.65424788389516", "2.73108973081272"};
    public String[] extraTableHead = new String[]{"Planet", "Start Planet", "Arrival planet"};
    public String[] extraRowInfo = new String[]{"Planet", "R (km)", "T (years)", "M (km)", "V (km/s)", "vE (km/s)"};
    public String[] extraRowFirstInfo = new String[]{"Start Planet", "149597870.7", "1", "5.98E24", "29.83", "42.17962"};
    public String[] extraRowSecondInfo = new String[]{"Arrival Planet", "778357721.2521", "11.87", "1.90E27", "13.08", "18.49512"};
    static float[] unitConeX;
    static float[] unitConeY;
    static int coneDetail;

    static {
        SolarSystemTransport.coneDetail(24);
    }

    public void setup() {
        this.size(1024, 768, "processing.core.PGraphics3D");
        this.controlP5 = new ControlP5((PApplet)this);
        this.bodyGraph = new BodyGraph(this);
        this.sphereDetail(18);
        this.ellipseMode(2);
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                if (evt.getWheelRotation() < 0) {
                    if (SolarSystemTransport.this.zoom < 400.0f) {
                        SolarSystemTransport.this.zoom = (float)((double)SolarSystemTransport.this.zoom + ((double)evt.getScrollAmount() + Math.abs((double)SolarSystemTransport.this.zoom * 0.1)));
                    }
                    if (SolarSystemTransport.this.camZoom > 10.0f) {
                        SolarSystemTransport.this.camZoom -= (float)evt.getScrollAmount();
                    }
                } else {
                    if (SolarSystemTransport.this.zoom > -10000.0f) {
                        SolarSystemTransport.this.zoom = (float)((double)SolarSystemTransport.this.zoom - ((double)evt.getScrollAmount() + Math.abs((double)SolarSystemTransport.this.zoom * 0.1)));
                    }
                    if (SolarSystemTransport.this.camZoom < 100.0f) {
                        SolarSystemTransport.this.camZoom += (float)evt.getScrollAmount();
                    }
                }
            }
        });
        this.planets[0] = new Planet(this, "sun", 700000.0f, 0.0f, 0.0f, 0.0f, 0.0f, this.color(255, 255, 10));
        this.planets[1] = new Planet(this, "mercury", 2450.0f, 0.386f, 0.206f, 0.0f, 3.38f, this.color(113, 252, 194));
        this.planets[2] = new Planet(this, "venus", 6050.0f, 0.723f, 0.007f, 0.0f, 3.86f, this.color(234, 88, 11));
        this.planets[3] = new Planet(this, "earth", 6400.0f, 1.0f, 0.017f, 0.0f, 7.155f, this.color(49, 118, 226));
        this.planets[4] = new Planet(this, "mars", 3400.0f, 1.881f, 0.093f, 0.0f, 5.65f, this.color(239, 64, 64));
        this.planets[5] = new Planet(this, "jupiter", 71500.0f, 11.857f, 0.048f, 0.0f, 6.09f, this.color(54, 163, 56));
        this.planets[6] = new Planet(this, "saturn", 63500.0f, 29.42f, 0.056f, 0.0f, 5.51f, this.color(248, 202, 0));
        this.planets[7] = new Planet(this, "uranus", 24973.0f, 83.75f, 0.046f, 0.0f, 6.48f, this.color(189, 21, 80));
        this.controlP5.addSlider("sunSize", 1.0f, 50.0f, 20.0f, 5, 5, 50, 10).setLabel("Sun Size");
        this.controlP5.addSlider("planetSize", 1.0f, 2000.0f, 1000.0f, 5, 20, 50, 10).setLabel("Planet Size");
        this.controlP5.addSlider("rocketSize", 0.0f, 1.0f, 0.5f, 5, 35, 50, 10).setLabel("Rocket Size");
        this.controlP5.addSlider("speed", 0.0f, 0.05f, this.SIM_SPEED, 5, 50, 50, 10);
        this.controlP5.addToggle("orbits", true, 5.0f, 65.0f, 10, 10);
        this.controlP5.addToggle("planets", true, 40.0f, 65.0f, 10, 10);
        this.controlP5.addButton("hohmann", 1.0f, 20, this.height - 40, 50, 25);
        this.controlP5.addSlider("itnProgress", 0.0f, 1.0f, 0.0f, 5, this.height - 70, 10, 60).setLabelVisible(false);
        this.pathList = this.controlP5.addMultiList("pathList", 5, this.height - 100, 70, 10);
        this.s = this.pathList.add("source", 0);
        this.d = this.pathList.add("destination", 1);
        int i = 1;
        while (i < this.planets.length) {
            this.s.add("source", (float)i).setLabel(this.planets[i].name);
            this.d.add("dest", (float)i).setLabel(this.planets[i].name);
            ++i;
        }
        this.controlP5.addTextlabel("planetName", "...", this.width - 60, 10);
        this.information = new TravelInformation(this);
        this.addTableInformation();
        this.addTableExtraInformation();
        i = 1;
        while (i < this.planets.length - 1) {
            this.planets[i].setupGraph(this.planets[i + 1]);
            ++i;
        }
        this.planets[this.planets.length - 1].setupGraph(null);
        this.rocket = new Rocket(this, this.planets[3], this.planets[5]);
        this.source(3);
        this.dest(5);
        this.rotateXVal = 0.5f;
        this.rotateYVal = 0.5f;
        this.zoom = -10.0f;
        this.controlP5.controller("sunSize").trigger();
        this.controlP5.controller("planetSize").trigger();
        this.controlP5.controller("rocketSize").trigger();
    }

    public void draw() {
        this.lights();
        this.background(0);
        this.cp5 = this.createGraphics(this.width, this.height, "processing.core.PGraphics2D");
        this.beginRecord(this.cp5);
        this.controlP5.draw();
        this.endRecord();
        if (this.followBody != null) {
            if (this.keyPressed && this.key == '\uffff' && this.keyCode == 16) {
                this.rotateCamX = SolarSystemTransport.map((float)(this.width / 2 - this.mouseX), (float)(-this.width / 2), (float)(this.width / 2), (float)-2.5132742f, (float)2.5132742f);
                this.rotateCamZ = (float)(this.height / 2 - this.mouseY) * 0.1f;
            }
            this.cameraVec = this.followBody.getRotated(this.rotateCamX).normalize().scale(this.camZoom).to3DXY();
            this.camera(this.followBody.x() + this.cameraVec.x(), this.followBody.y() + this.cameraVec.y(), this.rotateCamZ, this.followBody.x(), this.followBody.y(), 0.0f, 0.0f, 0.0f, -1.0f);
            this.mainDisplay();
            this.camera();
        } else {
            this.pushMatrix();
            this.translate(this.width / 2, this.height / 2, this.zoom);
            if (this.keyPressed && this.key == '\uffff' && this.keyCode == 16) {
                this.rotateYVal = ((float)this.mouseX / (float)this.width + 0.5f) * (float)Math.PI;
                this.rotateXVal = ((float)this.mouseY / (float)this.height + 0.5f) * (float)Math.PI;
            }
            this.rotateX(this.rotateXVal);
            this.rotateY(this.rotateYVal);
            this.mainDisplay();
            this.popMatrix();
        }
        this.image((PImage)this.cp5, 0.0f, 0.0f);
        ++this.TICK;
    }

    void mainDisplay() {
        Planet[] planetArray = this.planets;
        int n = this.planets.length;
        int n2 = 0;
        while (n2 < n) {
            Planet p = planetArray[n2];
            p.tick();
            p.display();
            ++n2;
        }
        this.rocket.previewHohmann();
        this.rocket.update();
    }

    public void mouseClicked() {
    }

    public void addTableInformation() {
        ControlGroup information = this.controlP5.addGroup("Eliptical Trajectory", 400, 300, 200);
        int i = 1;
        while (i < 3) {
            int j = 0;
            while (j < 5) {
                String labeltext = "";
                if (i == 1) {
                    labeltext = this.tableHead[j];
                } else if (i == 2) {
                    labeltext = this.tableValues[j];
                }
                String pos = String.valueOf(i) + j;
                Textlabel label = this.controlP5.addTextlabel("et" + pos, labeltext, 110 * j, 20 * i);
                label.setWidth(120);
                label.setGroup((ControllerGroup)information);
                ++j;
            }
            ++i;
        }
        information.setPosition((float)(this.width - 550), (float)(this.height - 70));
    }

    public void addTableExtraInformation() {
        ControlGroup extraInformation = this.controlP5.addGroup("Initial values", 400, 300, 200);
        int i = 1;
        while (i < 7) {
            int j = 0;
            while (j < 3) {
                String labeltext = "...";
                if (i == 1) {
                    labeltext = this.extraTableHead[j];
                } else if (j == 0) {
                    labeltext = this.extraRowInfo[i - 1];
                }
                String name = "gi" + i + j;
                Textlabel label = this.controlP5.addTextlabel(name, labeltext, 110 * j, 20 * i);
                label.setGroup((ControllerGroup)extraInformation);
                ++j;
            }
            ++i;
        }
        extraInformation.setPosition(160.0f, (float)(this.height - 150));
    }

    Body getFollowBody() {
        Planet[] planetArray = this.planets;
        int n = this.planets.length;
        int n2 = 0;
        while (n2 < n) {
            Planet p = planetArray[n2];
            if (!p.equals((Object)this.planets[0]) && p.follow) {
                return p;
            }
            ++n2;
        }
        return null;
    }

    void sunSize(float value) {
        this.planets[0].setSizeFactor(value);
    }

    void planetSize(float value) {
        Planet[] planetArray = this.planets;
        int n = this.planets.length;
        int n2 = 0;
        while (n2 < n) {
            Planet p = planetArray[n2];
            if (p != this.planets[0]) {
                p.setSizeFactor(value);
            }
            ++n2;
        }
    }

    void rocketSize(float value) {
        this.rocket.setSize(value);
    }

    void speed(float value) {
        this.SIM_SPEED = value;
    }

    void orbits(boolean value) {
        this.showOrbits = value;
    }

    void planets(boolean value) {
        this.showPlanets = value;
    }

    void lagrange(boolean value) {
        this.showLagrange = value;
    }

    void ITN(int value) {
        this.resetProgress();
        this.rocket.waitITN();
    }

    void hohmann(int value) {
        this.resetProgress();
        this.rocket.waitHohmann();
    }

    void source(int value) {
        this.s.setLabel("from: " + this.planets[value].name);
        this.rocket.setSource(this.planets[value]);
        this.information.updateSourceInformation(this.planets[value].name);
    }

    void dest(int value) {
        this.d.setLabel("to: " + this.planets[value].name);
        this.rocket.setDest(this.planets[value]);
        this.information.updateDestinationInformation(this.planets[value].name);
    }

    void setProgress(float value) {
        if (value > this.controlP5.controller("itnProgress").value()) {
            this.controlP5.controller("itnProgress").setValue(value);
        }
    }

    void resetProgress() {
        this.controlP5.controller("itnProgress").setValue(0.0f);
    }

    Stack<Body> getPath(Body source, Body dest) {
        return this.bodyGraph.dijkstra(source, dest);
    }

    Body getSmallestDist(ArrayList<Body> vertices) {
        Body smallest = vertices.get(0);
        for (Body b : vertices) {
            if (!(b.distance < smallest.distance)) continue;
            smallest = b;
        }
        return smallest;
    }

    void cylinder(float w, float h, int sides) {
        float[] x = new float[sides + 1];
        float[] z = new float[sides + 1];
        int i = 0;
        while (i < x.length) {
            float angle = (float)Math.PI * 2 / (float)sides * (float)i;
            x[i] = SolarSystemTransport.sin((float)angle) * w;
            z[i] = SolarSystemTransport.cos((float)angle) * w;
            ++i;
        }
        this.beginShape(11);
        this.vertex(0.0f, -h / 2.0f, 0.0f);
        i = 0;
        while (i < x.length) {
            this.vertex(x[i], -h / 2.0f, z[i]);
            ++i;
        }
        this.endShape();
        this.beginShape(17);
        i = 0;
        while (i < x.length) {
            this.vertex(x[i], -h / 2.0f, z[i]);
            this.vertex(x[i], h / 2.0f, z[i]);
            ++i;
        }
        this.endShape();
        this.beginShape(11);
        this.vertex(0.0f, h / 2.0f, 0.0f);
        i = 0;
        while (i < x.length) {
            this.vertex(x[i], h / 2.0f, z[i]);
            ++i;
        }
        this.endShape();
    }

    static void coneDetail(int det) {
        coneDetail = det;
        unitConeX = new float[det + 1];
        unitConeY = new float[det + 1];
        int i = 0;
        while (i <= det) {
            float a1 = (float)Math.PI * 2 * (float)i / (float)det;
            SolarSystemTransport.unitConeX[i] = (float)Math.cos(a1);
            SolarSystemTransport.unitConeY[i] = (float)Math.sin(a1);
            ++i;
        }
    }

    void cone(float x, float y, float r, float h) {
        this.pushMatrix();
        this.translate(x, y);
        this.scale(r, r);
        this.beginShape(9);
        int i = 0;
        while (i < coneDetail) {
            this.vertex(unitConeX[i], unitConeY[i], 0.0f);
            this.vertex(unitConeX[i + 1], unitConeY[i + 1], 0.0f);
            this.vertex(0.0f, 0.0f, h);
            ++i;
        }
        this.endShape();
        this.popMatrix();
    }

    void fin(float sz, float angle) {
        this.pushMatrix();
        this.scale(sz);
        this.rotateY(angle);
        this.beginShape();
        this.vertex(0.0f, 6.0f);
        this.vertex(4.2f, 0.0f);
        this.vertex(9.0f, 0.0f);
        this.vertex(5.0f, 6.0f);
        this.endShape(2);
        this.popMatrix();
    }

    public static void main(String[] args) {
        PApplet.main((String[])new String[]{"--present", SolarSystemTransport.class.getName()});
    }
}

