/*
 * Decompiled with CFR 0.152.
 */
package com.strobe.orbit;

import com.strobe.orbit.SolarSystemTransport;
import com.strobe.orbit.data.PlanetInfo;
import com.strobe.orbit.data.TravelComputation;
import controlP5.Textlabel;

public class TravelInformation {
    SolarSystemTransport parent;
    TravelComputation travelInfo;
    private String source;
    private String destination;

    public TravelInformation(SolarSystemTransport parent) {
        this.parent = parent;
        this.travelInfo = new TravelComputation();
    }

    public void updateSourceInformation(String source) {
        this.source = source;
        PlanetInfo pInfo = this.travelInfo.getPlanets().get(source);
        System.out.println(pInfo);
        ((Textlabel)this.parent.controlP5.controller("gi11")).setValue(" ").setValue(String.valueOf(pInfo.getName()));
        ((Textlabel)this.parent.controlP5.controller("gi21")).setValue(" ").setValue(String.valueOf(pInfo.getRadius()));
        ((Textlabel)this.parent.controlP5.controller("gi31")).setValue(" ").setValue(String.valueOf(pInfo.getPeriod()));
        ((Textlabel)this.parent.controlP5.controller("gi41")).setValue(" ").setValue(String.valueOf(pInfo.getMass()));
        ((Textlabel)this.parent.controlP5.controller("gi51")).setValue(" ").setValue(String.valueOf(pInfo.getOrbitalVelocity()));
        ((Textlabel)this.parent.controlP5.controller("gi61")).setValue(" ").setValue(String.valueOf(pInfo.getEscapeVelocity()));
        this.updateTravelInformation();
    }

    public void updateDestinationInformation(String destination) {
        this.destination = destination;
        PlanetInfo pInfo = this.travelInfo.getPlanets().get(destination);
        System.out.println(pInfo);
        ((Textlabel)this.parent.controlP5.controller("gi12")).setValue(String.valueOf(pInfo.getName()));
        ((Textlabel)this.parent.controlP5.controller("gi22")).setValue(String.valueOf(pInfo.getRadius()));
        ((Textlabel)this.parent.controlP5.controller("gi32")).setValue(String.valueOf(pInfo.getPeriod()));
        ((Textlabel)this.parent.controlP5.controller("gi42")).setValue(String.valueOf(pInfo.getMass()));
        ((Textlabel)this.parent.controlP5.controller("gi52")).setValue(String.valueOf(pInfo.getOrbitalVelocity()));
        ((Textlabel)this.parent.controlP5.controller("gi62")).setValue(String.valueOf(pInfo.getEscapeVelocity()));
        this.updateTravelInformation();
    }

    private void updateTravelInformation() {
        if (this.source != null && this.destination != null) {
            PlanetInfo sInfo = this.travelInfo.getPlanets().get(this.source);
            PlanetInfo dInfo = this.travelInfo.getPlanets().get(this.destination);
            float v1 = (float)((double)sInfo.getOrbitalVelocity() * Math.pow(2.0f * dInfo.getRadius() / (dInfo.getRadius() + sInfo.getRadius()), 0.5));
            float v2 = v1 * sInfo.getRadius() / dInfo.getRadius();
            float deltaV1 = v1 - sInfo.getOrbitalVelocity();
            float deltaV2 = dInfo.getOrbitalVelocity() - v2;
            float t = (float)((double)3.1416f * Math.pow(Math.pow((sInfo.getRadius() + dInfo.getRadius()) * 1000.0f, 3.0) / 8.0 / (double)6.67384f * Math.pow(10.0, 11.0) / (double)1.9891f / Math.pow(10.0, 30.0), 0.5) / (double)365.2f / 24.0 / 3600.0);
            ((Textlabel)this.parent.controlP5.controller("et20")).setValue(String.valueOf(v1));
            ((Textlabel)this.parent.controlP5.controller("et21")).setValue(String.valueOf(v2));
            ((Textlabel)this.parent.controlP5.controller("et22")).setValue(String.valueOf(deltaV1));
            ((Textlabel)this.parent.controlP5.controller("et23")).setValue(String.valueOf(deltaV2));
            ((Textlabel)this.parent.controlP5.controller("et24")).setValue(String.valueOf(t));
        }
    }
}

