/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CColor;
import controlP5.CDrawable;
import controlP5.CVector3f;
import controlP5.ControlCanvas;
import controlP5.ControlFont;
import controlP5.ControlP5;
import controlP5.ControlP5IOHandler;
import controlP5.ControlP5XMLElement;
import controlP5.ControlPicking;
import controlP5.ControlWindowCanvas;
import controlP5.ControlWindowKeyListener;
import controlP5.Controller;
import controlP5.ControllerList;
import controlP5.PAppletWindow;
import controlP5.Tab;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Hashtable;
import java.util.Vector;
import processing.core.PApplet;

public class ControlWindow
implements MouseWheelListener {
    protected ControlP5 controlP5;
    protected int mouseX;
    protected int mouseY;
    protected int pmouseX;
    protected int pmouseY;
    protected boolean mousePressed;
    protected boolean mouselock;
    protected Controller isControllerActive;
    public int background = 0;
    protected CColor color = new CColor();
    private String _myName = "main";
    protected PApplet _myApplet;
    private boolean isPAppletWindow;
    protected ControllerList _myTabs;
    protected boolean isVisible = true;
    protected boolean isInit = false;
    protected boolean isRemove = false;
    protected CDrawable _myDrawable;
    protected boolean isAutoDraw;
    protected boolean isUpdate;
    public static final int NORMAL = 0;
    public static final int ECONOMIC = 1;
    protected Vector<ControlWindowCanvas> _myControlWindowCanvas;
    protected Vector<ControlCanvas> _myControlCanvas;
    protected boolean isMouseOver;
    protected boolean isDrawBackground = true;
    protected boolean isUndecorated = false;
    protected boolean is3D;
    protected CVector3f autoPosition = new CVector3f(10.0f, 30.0f, 0.0f);
    protected float tempAutoPositionHeight = 0.0f;
    protected ControlPicking _myPicking;
    protected boolean rendererNotification = false;

    public ControlWindow(ControlP5 controlP5, PApplet pApplet) {
        this.controlP5 = controlP5;
        this._myApplet = pApplet;
        this._myApplet.registerMouseEvent((Object)this);
        this._myApplet.addMouseWheelListener((MouseWheelListener)this);
        this.isAutoDraw = true;
        this.init();
    }

    protected void init() {
        String string = this._myApplet.g.getClass().toString().toLowerCase();
        this.is3D = string.contains("gl") || string.contains("3d");
        this._myPicking = new ControlPicking(this);
        this._myTabs = new ControllerList();
        this._myControlWindowCanvas = new Vector();
        this._myControlCanvas = new Vector();
        if (this._myApplet instanceof PAppletWindow) {
            this._myName = ((PAppletWindow)this._myApplet).name();
            this.isPAppletWindow = true;
            ((PAppletWindow)this._myApplet).setControlWindow(this);
        }
        if (this.isPAppletWindow) {
            this.background = -16777216;
        }
        if (!this.isInit) {
            if (this._myApplet instanceof PAppletWindow) {
                this._myApplet.registerKeyEvent((Object)new ControlWindowKeyListener(this));
            } else {
                ControlP5.keyHandler.update(this);
            }
        }
        this._myTabs.add(new Tab(this.controlP5, this, "global"));
        this._myTabs.add(new Tab(this.controlP5, this, "default"));
        this.activateTab((Tab)this._myTabs.get(1));
        if (this._myApplet.g.getClass().getName().indexOf("PGraphics2D") > -1 || this._myApplet.g.getClass().getName().indexOf("PGraphics3D") > -1) {
            if (!this.rendererNotification) {
                ControlP5.logger().info("You are using renderer " + this._myApplet.g.getClass().getName() + ".\n" + "In order to render controlP5 elements you need to call the ControlP5's draw() manually.\n" + "Suggestion is to put controlP5.draw(); at the bottom of the draw function of your sketch.");
                this.rendererNotification = true;
            }
        } else if (!this.isInit) {
            this._myApplet.registerPre((Object)this);
            this._myApplet.registerDraw((Object)this);
        }
        this.isInit = true;
    }

    public Tab currentTab() {
        for (int i = 1; i < this._myTabs.size(); ++i) {
            if (!((Tab)this._myTabs.get(i)).isActive()) continue;
            return (Tab)this._myTabs.get(i);
        }
        return null;
    }

    public void activateTab(String string) {
        for (int i = 1; i < this._myTabs.size(); ++i) {
            if (!((Tab)this._myTabs.get(i)).name().equals(string)) continue;
            this.activateTab((Tab)this._myTabs.get(i));
        }
    }

    public void removeTab(Tab tab) {
        this._myTabs.remove(tab);
    }

    public Tab add(Tab tab) {
        this._myTabs.add(tab);
        return tab;
    }

    public Tab addTab(String string) {
        return this.tab(string);
    }

    protected void activateTab(Tab tab) {
        for (int i = 1; i < this._myTabs.size(); ++i) {
            if (this._myTabs.get(i) == tab) {
                ((Tab)this._myTabs.get(i)).setActive(true);
                continue;
            }
            ((Tab)this._myTabs.get(i)).setActive(false);
        }
    }

    public ControllerList tabs() {
        return this._myTabs;
    }

    public Tab tab(String string) {
        return this.controlP5.tab(this, string);
    }

    public void remove() {
        for (int i = this._myTabs.size() - 1; i >= 0; --i) {
            ((Tab)this._myTabs.get(i)).remove();
        }
        this._myTabs.clear();
        this._myTabs.clearDrawable();
        this.controlP5.controlWindowList.remove(this);
    }

    public void clear() {
        this.remove();
        if (this._myApplet instanceof PAppletWindow) {
            this._myApplet.unregisterMouseEvent((Object)this);
            this._myApplet.removeMouseWheelListener((MouseWheelListener)this);
            this._myApplet.stop();
            ((PAppletWindow)this._myApplet).dispose();
            this._myApplet = null;
            System.gc();
        }
    }

    protected void updateFont(ControlFont controlFont) {
        for (int i = 0; i < this._myTabs.size(); ++i) {
            ((Tab)this._myTabs.get(i)).updateFont(controlFont);
        }
    }

    public void updateEvents() {
        this.isMouseOver = false;
        if (this._myTabs.size() <= 0) {
            return;
        }
        this._myTabs.get(0).updateEvents();
        for (int i = 1; i < this._myTabs.size(); ++i) {
            ((Tab)this._myTabs.get(i)).continuousUpdateEvents();
            if (!((Tab)this._myTabs.get(i)).isActive() || !((Tab)this._myTabs.get(i)).isVisible()) continue;
            this._myTabs.get(i).updateEvents();
        }
    }

    public boolean isMouseOver() {
        return this.isMouseOver;
    }

    public void update() {
        this._myTabs.get(0).update();
        for (int i = 1; i < this._myTabs.size(); ++i) {
            ((Tab)this._myTabs.get(i)).update();
        }
    }

    public void setUpdate(boolean bl) {
        this.isUpdate = bl;
        for (int i = 0; i < this._myTabs.size(); ++i) {
            this._myTabs.get(i).setUpdate(bl);
        }
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public void addCanvas(ControlWindowCanvas controlWindowCanvas) {
        this._myControlWindowCanvas.add(controlWindowCanvas);
        controlWindowCanvas.setControlWindow(this);
    }

    public void removeCanvas(ControlWindowCanvas controlWindowCanvas) {
        this._myControlWindowCanvas.remove(controlWindowCanvas);
    }

    public void pre() {
        if (this.isVisible && this.isPAppletWindow && this.isDrawBackground) {
            this._myApplet.background(this.background);
        }
    }

    public void draw() {
        if (!this.controlP5.blockDraw) {
            this._myPicking.reset();
            this.updateEvents();
            if (this.isVisible) {
                int n;
                int n2;
                int n3 = this._myApplet.g.rectMode;
                int n4 = this._myApplet.g.ellipseMode;
                int n5 = this._myApplet.g.imageMode;
                this._myApplet.rectMode(0);
                this._myApplet.ellipseMode(0);
                this._myApplet.imageMode(0);
                if (this.isPAppletWindow) {
                    this._myApplet.background(this.background);
                }
                if (this._myDrawable != null) {
                    this._myDrawable.draw(this._myApplet);
                }
                for (n2 = 0; n2 < this._myControlWindowCanvas.size(); ++n2) {
                    if (this._myControlWindowCanvas.get(n2).mode() != 0) continue;
                    this._myControlWindowCanvas.get(n2).draw(this._myApplet);
                }
                this._myApplet.noStroke();
                this._myApplet.noFill();
                n2 = 0;
                int n6 = 0;
                int n7 = 0;
                if (this._myTabs.size() > 0) {
                    for (n = 1; n < this._myTabs.size(); ++n) {
                        if (!((Tab)this._myTabs.get(n)).isVisible()) continue;
                        if (n7 < ((Tab)this._myTabs.get(n)).height()) {
                            n7 = ((Tab)this._myTabs.get(n)).height();
                        }
                        if (n2 > this.component().getWidth() - ((Tab)this._myTabs.get(n)).width()) {
                            n6 += n7 + 1;
                            n2 = 0;
                            n7 = 0;
                        }
                        ((Tab)this._myTabs.get(n)).setOffset(n2, n6);
                        if (((Tab)this._myTabs.get(n)).updateLabel()) {
                            ((Tab)this._myTabs.get(n)).drawLabel(this._myApplet);
                        }
                        if (((Tab)this._myTabs.get(n)).isActive()) {
                            ((Tab)this._myTabs.get(n)).draw(this._myApplet);
                        }
                        n2 += ((Tab)this._myTabs.get(n)).width();
                    }
                    this._myTabs.get(0).draw(this._myApplet);
                }
                for (n = 0; n < this._myControlWindowCanvas.size(); ++n) {
                    if (this._myControlWindowCanvas.get(n).mode() != 1) continue;
                    this._myControlWindowCanvas.get(n).draw(this._myApplet);
                }
                this.pmouseX = this.mouseX;
                this.pmouseY = this.mouseY;
                this._myApplet.rectMode(n3);
                this._myApplet.ellipseMode(n4);
                this._myApplet.imageMode(n5);
            }
        }
        this._myPicking.display(this._myApplet);
    }

    public void setContext(CDrawable cDrawable) {
        this._myDrawable = cDrawable;
    }

    public String name() {
        return this._myName;
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        if (this.isVisible) {
            int n;
            if (mouseEvent.getID() == 501) {
                this.mousePressed = true;
                for (n = 0; n < this._myTabs.size(); ++n) {
                    if (!this._myTabs.get(n).setMousePressed(true)) continue;
                    this.mouselock = true;
                    return;
                }
            }
            if (mouseEvent.getID() == 502) {
                this.mousePressed = false;
                this.mouselock = false;
                for (n = 0; n < this._myTabs.size(); ++n) {
                    this._myTabs.get(n).setMousePressed(false);
                }
            }
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        if (n < 0) {
            String string = "Mouse wheel moved UP " + -n + " notch";
        } else {
            String string = "Mouse wheel moved DOWN " + n + " notch";
        }
    }

    public void multitouch(int[][] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            this.mouseX = nArray[i][0];
            this.mouseY = nArray[i][1];
            if (!this.isVisible) continue;
            if (nArray[i][2] == 501) {
                this.mousePressed = true;
                for (n = 0; n < this._myTabs.size(); ++n) {
                    if (!this._myTabs.get(n).setMousePressed(true)) continue;
                    this.mouselock = true;
                    ControlP5.logger().finer(" mouselock = " + this.mouselock);
                    return;
                }
            }
            if (nArray[i][2] != 502) continue;
            this.mousePressed = false;
            this.mouselock = false;
            for (n = 0; n < this._myTabs.size(); ++n) {
                this._myTabs.get(n).setMousePressed(false);
            }
        }
    }

    public boolean isMousePressed() {
        return this.mousePressed;
    }

    public void keyEvent(KeyEvent keyEvent) {
        for (int i = 0; i < this._myTabs.size(); ++i) {
            this._myTabs.get(i).keyEvent(keyEvent);
        }
    }

    public void setColorActive(int n) {
        this.color.colorActive = n;
        for (int i = 0; i < this.tabs().size(); ++i) {
            ((Tab)this.tabs().get(i)).setColorActive(n);
        }
    }

    public void setColorForeground(int n) {
        this.color.colorForeground = n;
        for (int i = 0; i < this.tabs().size(); ++i) {
            ((Tab)this.tabs().get(i)).setColorForeground(n);
        }
    }

    public void setColorBackground(int n) {
        this.color.colorBackground = n;
        for (int i = 0; i < this.tabs().size(); ++i) {
            ((Tab)this.tabs().get(i)).setColorBackground(n);
        }
    }

    public void setColorLabel(int n) {
        this.color.colorCaptionLabel = n;
        for (int i = 0; i < this.tabs().size(); ++i) {
            ((Tab)this.tabs().get(i)).setColorLabel(n);
        }
    }

    public void setColorValue(int n) {
        this.color.colorValueLabel = n;
        for (int i = 0; i < this.tabs().size(); ++i) {
            ((Tab)this.tabs().get(i)).setColorValue(n);
        }
    }

    public void setBackground(int n) {
        this.background = n;
    }

    public PApplet papplet() {
        return this._myApplet;
    }

    public Component component() {
        return this.papplet();
    }

    public void setTitle(String string) {
        if (this._myApplet instanceof PAppletWindow) {
            ((PAppletWindow)this._myApplet).setTitle(string);
        }
    }

    public void showCoordinates() {
        if (this._myApplet instanceof PAppletWindow) {
            ((PAppletWindow)this._myApplet).showCoordinates();
        }
    }

    public void hideCoordinates() {
        if (this._myApplet instanceof PAppletWindow) {
            ((PAppletWindow)this._myApplet).hideCoordinates();
        }
    }

    public void hide() {
        this.isVisible = false;
        if (this.isPAppletWindow) {
            ((PAppletWindow)this._myApplet).visible(false);
        }
    }

    public void setMode(int n) {
        this.setUpdateMode(n);
    }

    public void setUpdateMode(int n) {
        if (this.isPAppletWindow) {
            ((PAppletWindow)this._myApplet).setMode(n);
        }
    }

    public void frameRate(int n) {
        this._myApplet.frameRate((float)n);
    }

    public void show() {
        this.isVisible = true;
        if (this.isPAppletWindow) {
            ((PAppletWindow)this._myApplet).visible(true);
        }
    }

    public void setDrawBackground(boolean bl) {
        this.isDrawBackground = bl;
    }

    public boolean isDrawBackground() {
        return this.isDrawBackground;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    protected boolean isControllerActive(Controller controller) {
        if (this.isControllerActive == null) {
            return false;
        }
        return this.isControllerActive.equals(controller);
    }

    protected void setControllerActive(Controller controller) {
        this.isControllerActive = controller;
    }

    public void toggleUndecorated() {
        this.setUndecorated(!this.isUndecorated());
    }

    public void setUndecorated(boolean bl) {
        if (bl != this.isUndecorated()) {
            this.isUndecorated = bl;
            this._myApplet.frame.removeNotify();
            this._myApplet.frame.setUndecorated(this.isUndecorated);
            this._myApplet.setSize(this._myApplet.width, this._myApplet.height);
            this._myApplet.setBounds(0, 0, this._myApplet.width, this._myApplet.height);
            this._myApplet.frame.setSize(this._myApplet.width, this._myApplet.height);
            this._myApplet.frame.addNotify();
        }
    }

    public boolean isUndecorated() {
        return this.isUndecorated;
    }

    public void setLocation(int n, int n2) {
        this._myApplet.frame.setLocation(n, n2);
    }

    protected ControlP5XMLElement getAsXML() {
        ControlP5XMLElement controlP5XMLElement = new ControlP5XMLElement(new Hashtable(), true, false);
        controlP5XMLElement.setName("window");
        controlP5XMLElement.setAttribute("class", this._myApplet.getClass().getName());
        controlP5XMLElement.setAttribute("name", this.name());
        controlP5XMLElement.setAttribute("width", "" + this._myApplet.width);
        controlP5XMLElement.setAttribute("height", "" + this._myApplet.height);
        controlP5XMLElement.setAttribute("background", ControlP5IOHandler.intToString(this.background));
        if (this._myApplet.getClass().getName().indexOf("controlP5.PAppletWindow") != -1) {
            controlP5XMLElement.setAttribute("x", "" + ((PAppletWindow)this._myApplet).x);
            controlP5XMLElement.setAttribute("y", "" + ((PAppletWindow)this._myApplet).y);
        }
        return controlP5XMLElement;
    }
}

