/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CColor;
import controlP5.CDrawable;
import controlP5.CVector3f;
import controlP5.ControlBehavior;
import controlP5.ControlEvent;
import controlP5.ControlFont;
import controlP5.ControlGroup;
import controlP5.ControlListener;
import controlP5.ControlP5;
import controlP5.ControlP5Constants;
import controlP5.ControlP5XMLElement;
import controlP5.ControlWindow;
import controlP5.ControllerDisplay;
import controlP5.ControllerGroup;
import controlP5.ControllerInterface;
import controlP5.ControllerPlug;
import controlP5.ControllerSprite;
import controlP5.Label;
import controlP5.Tab;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import processing.core.PApplet;
import processing.core.PImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Controller
implements ControllerInterface,
CDrawable,
ControlP5Constants {
    protected CVector3f position;
    protected CVector3f positionBuffer;
    protected CVector3f absolutePosition;
    protected ControllerInterface _myParent;
    protected String _myName;
    protected ControlWindow _myControlWindow;
    private boolean isInside = false;
    protected boolean isMousePressed = false;
    protected ControlP5 controlP5;
    protected int width;
    protected int height;
    protected int _myId = -1;
    protected float _myValue;
    protected float _myDefaultValue;
    protected String _myStringValue = "";
    protected float[] _myArrayValue;
    protected Label _myCaptionLabel;
    protected Label _myValueLabel;
    protected boolean isLabelVisible = true;
    protected boolean isMoveable = true;
    protected boolean isBroadcast = true;
    protected boolean isVisible = true;
    protected boolean isActive = false;
    protected boolean isInit = false;
    protected List<ControlListener> _myControlListener;
    protected CColor color = new CColor();
    protected float _myMin;
    protected float _myMax;
    protected float _myUnit;
    private List<ControllerPlug> _myControllerPlugList;
    protected String target;
    protected Object targetObject;
    protected ControlBehavior _myBehavior;
    protected boolean isBehavior;
    protected boolean isXMLsavable = true;
    protected List<Controller> subelements;
    protected int myBroadcastType = 1;
    protected boolean isUpdate = false;
    protected int _myDecimalPoints = 2;
    protected ControllerSprite sprite;
    protected boolean isSprite;
    protected int autoWidth = 50;
    protected int autoHeight = 20;
    protected CVector3f autoSpacing = new CVector3f(10.0f, 10.0f, 0.0f);
    protected boolean isLock = false;
    protected boolean isUserInteraction = true;
    protected boolean[] availableImages = new boolean[4];
    protected PImage[] images = new PImage[4];
    protected ControllerDisplay _myDisplay;
    protected ControllerDisplay _myDebugDisplay;
    protected int _myDisplayMode = 0;
    protected int _myPickingColor = -256;

    protected Controller(ControlP5 controlP5, ControllerGroup controllerGroup, String string, float f, float f2, int n, int n2) {
        this.controlP5 = controlP5;
        if (this.controlP5 == null) {
            this.isBroadcast = false;
        }
        this._myName = string;
        this.position = new CVector3f(f, f2, 0.0f);
        this.positionBuffer = new CVector3f(f, f2, 0.0f);
        this.setParent(controllerGroup);
        if (controllerGroup != null) {
            this.color.set(controllerGroup.color);
        } else {
            this.color.set(this.controlP5.color);
        }
        this.width = n;
        this.height = n2;
        this._myCaptionLabel = new Label(string, this.color.colorCaptionLabel);
        this._myValueLabel = new Label("");
        this._myControllerPlugList = new Vector<ControllerPlug>();
        this._myControlListener = new Vector<ControlListener>();
        this.subelements = new Vector<Controller>();
        this._myArrayValue = new float[0];
        this.setDisplay(this._myDebugDisplay);
    }

    protected Controller(int n, int n2) {
        this.position = new CVector3f(n, n2, 0.0f);
    }

    @Override
    public final void init() {
        this._myDefaultValue = this._myValue;
        this.controlP5.controlbroadcaster().plug((Object)ControlP5.papplet, this, this._myName);
        this.initControllerValue();
        this.isInit = this.controlP5.isAutoInitialization;
        this.setValue(this._myDefaultValue);
        this.isInit = true;
        this.updateDisplayMode(0);
    }

    private void initControllerValue() {
        if (this._myControllerPlugList.size() == 1) {
            if (Float.isNaN(this.defaultValue())) {
                if (this.getControllerPlugList().get(0).value() == null) {
                    this.setDefaultValue(this.min());
                } else {
                    float f = 0.0f;
                    if (this.getControllerPlugList().get(0).value() instanceof Boolean) {
                        boolean bl = new Boolean(this.getControllerPlugList().get(0).value().toString());
                        f = bl ? 1.0f : 0.0f;
                    } else if (this.getControllerPlugList().get(0).value() instanceof Float) {
                        f = new Float(this.getControllerPlugList().get(0).value().toString()).floatValue();
                    } else if (this.getControllerPlugList().get(0).value() instanceof Integer) {
                        f = new Integer(this.getControllerPlugList().get(0).value().toString()).intValue();
                    } else if (this.getControllerPlugList().get(0).value() instanceof String) {
                        this._myStringValue = this.getControllerPlugList().get(0).value().toString();
                    }
                    this.setDefaultValue(f);
                }
            }
        } else if (Float.isNaN(this.defaultValue())) {
            this.setDefaultValue(this.min());
        }
        this._myValue = this._myDefaultValue;
    }

    protected void updateFont(ControlFont controlFont) {
        this._myCaptionLabel.updateFont(controlFont);
        this._myValueLabel.updateFont(controlFont);
    }

    public void setBehavior(ControlBehavior controlBehavior) {
        this.isBehavior = true;
        this._myBehavior = controlBehavior;
        this._myBehavior.init(this);
    }

    public void removeBehavior() {
        this.isBehavior = false;
        this._myBehavior = null;
    }

    public ControlBehavior behavior() {
        return this._myBehavior;
    }

    public float defaultValue() {
        return this._myDefaultValue;
    }

    public void setDefaultValue(float f) {
        this._myDefaultValue = f;
    }

    public void setMoveable(boolean bl) {
        this.isMoveable = bl;
    }

    public boolean isMoveable() {
        return this.isMoveable;
    }

    public void setLabelVisible(boolean bl) {
        this.isLabelVisible = bl;
    }

    public void setBroadcast(boolean bl) {
        this.isBroadcast = bl;
    }

    public boolean isBroadcast() {
        return this.isBroadcast;
    }

    @Override
    public CVector3f position() {
        return this.position;
    }

    @Override
    public void setPosition(float f, float f2) {
        this.position.x = f;
        this.position.y = f2;
    }

    @Override
    public CVector3f absolutePosition() {
        return this.absolutePosition;
    }

    @Override
    public void updateAbsolutePosition() {
    }

    @Override
    public final void continuousUpdateEvents() {
        if (this.isBehavior && this._myBehavior.isActive() && !this.isMousePressed) {
            this._myBehavior.update();
        }
    }

    @Override
    public final void updateEvents() {
        if (this.isVisible && this.isMousePressed == this._myControlWindow.mouselock) {
            if (this.isMousePressed && ControlP5.keyHandler.isAltDown && this.isMoveable) {
                if (!ControlP5.isMoveable) {
                    this.positionBuffer.x += (float)(this._myControlWindow.mouseX - this._myControlWindow.pmouseX);
                    this.positionBuffer.y += (float)(this._myControlWindow.mouseY - this._myControlWindow.pmouseY);
                    if (ControlP5.keyHandler.isShiftDown) {
                        this.position.x = (int)this.positionBuffer.x / 10 * 10;
                        this.position.y = (int)this.positionBuffer.y / 10 * 10;
                    } else {
                        this.position.set(this.positionBuffer);
                    }
                }
            } else if (!this.isLock) {
                if (this.isInside) {
                    this._myControlWindow.isMouseOver = true;
                }
                if (this.inside()) {
                    if (!this.isInside) {
                        this.setIsInside(true);
                        this.onEnter();
                    }
                } else if (this.isInside && !this.isMousePressed) {
                    this.onLeave();
                    this.setIsInside(false);
                }
            }
        }
        this._myControlWindow._myPicking.update(this);
    }

    @Override
    public void updateInternalEvents(PApplet pApplet) {
    }

    @Override
    public void draw(PApplet pApplet) {
        pApplet.pushMatrix();
        pApplet.translate(this.position.x, this.position.y);
        this._myDisplay.display(pApplet, this);
        pApplet.popMatrix();
    }

    @Override
    public void add(ControllerInterface controllerInterface) {
        ControlP5.logger().warning(" add() not supported.");
    }

    @Override
    public void remove(ControllerInterface controllerInterface) {
        ControlP5.logger().warning("remove() not supported.");
    }

    @Override
    public void remove() {
        if (this._myParent != null) {
            this._myParent.remove(this);
        }
        if (this.controlP5 != null) {
            this.controlP5.remove(this);
        }
    }

    @Override
    public String name() {
        return this._myName;
    }

    public void moveTo(String string) {
        this.setTab(string);
        for (Controller controller : this.subelements) {
            controller.moveTo(string);
        }
    }

    public void moveTo(Tab tab) {
        this.setTab(tab.getWindow(), tab.name());
        for (Controller controller : this.subelements) {
            controller.moveTo(tab);
        }
    }

    public void moveTo(PApplet pApplet) {
        this.setTab("default");
        for (Controller controller : this.subelements) {
            controller.moveTo(pApplet);
        }
    }

    public void moveTo(PApplet pApplet, String string) {
        this.setTab(string);
        for (Controller controller : this.subelements) {
            controller.moveTo(pApplet, string);
        }
    }

    public void moveTo(ControlWindow controlWindow) {
        this.setTab(controlWindow, "default");
        for (Controller controller : this.subelements) {
            controller.moveTo(controlWindow);
        }
    }

    public void moveTo(ControlWindow controlWindow, String string) {
        this.setTab(controlWindow, string);
        for (Controller controller : this.subelements) {
            controller.moveTo(controlWindow, string);
        }
    }

    @Override
    public void moveTo(ControlGroup controlGroup, Tab tab, ControlWindow controlWindow) {
        for (Controller controller : this.subelements) {
            controller.moveTo(controlGroup, tab, controlWindow);
        }
        if (controlGroup != null) {
            this.setGroup(controlGroup);
            return;
        }
        if (controlWindow == null) {
            controlWindow = this.controlP5.controlWindow;
        }
        this.setTab(controlWindow, tab.name());
    }

    public void moveTo(ControlGroup controlGroup) {
        if (controlGroup != null) {
            this.setGroup(controlGroup);
            return;
        }
    }

    public void moveTo(ControllerGroup controllerGroup) {
        if (controllerGroup != null) {
            this.setGroup(controllerGroup);
            return;
        }
    }

    public void setTab(String string) {
        this.setParent(this.controlP5.getTab(string));
        for (Controller controller : this.subelements) {
            controller.setTab(string);
        }
    }

    public void setTab(ControlWindow controlWindow, String string) {
        this.setParent(this.controlP5.getTab(controlWindow, string));
        for (Controller controller : this.subelements) {
            controller.setTab(controlWindow, string);
        }
    }

    public void setGroup(String string) {
        this.setParent(this.controlP5.getGroup(string));
        for (Controller controller : this.subelements) {
            controller.setGroup(string);
        }
    }

    public void setGroup(ControllerGroup controllerGroup) {
        this.setParent(controllerGroup);
        for (Controller controller : this.subelements) {
            controller.setGroup(controllerGroup);
        }
    }

    public void setWindow(PApplet pApplet) {
        this.moveTo(pApplet);
    }

    public ControlWindow setWindow(ControlWindow controlWindow) {
        this.moveTo(controlWindow);
        return this._myControlWindow;
    }

    @Override
    public Tab getTab() {
        if (this._myParent instanceof Tab) {
            return (Tab)this._myParent;
        }
        return this._myParent.getTab();
    }

    public final void setParent(ControllerInterface controllerInterface) {
        if (this._myParent != null) {
            this._myParent.remove(this);
        }
        this.absolutePosition = new CVector3f(this.position);
        if (controllerInterface != null) {
            this._myParent = controllerInterface;
            this._myParent.add(this);
            this.absolutePosition.add(this._myParent.position());
            this._myControlWindow = this._myParent.getWindow();
        }
    }

    @Override
    public ControllerInterface parent() {
        return this._myParent;
    }

    @Override
    public ControlWindow getWindow() {
        return this._myControlWindow;
    }

    protected boolean inside() {
        return (float)this._myControlWindow.mouseX > this.position.x() + this._myParent.absolutePosition().x() && (float)this._myControlWindow.mouseX < this.position.x() + this._myParent.absolutePosition().x() + (float)this.width && (float)this._myControlWindow.mouseY > this.position.y() + this._myParent.absolutePosition().y() && (float)this._myControlWindow.mouseY < this.position.y() + this._myParent.absolutePosition().y() + (float)this.height;
    }

    public boolean isInside() {
        return this.isInside;
    }

    public boolean isMousePressed() {
        return this.isMousePressed;
    }

    protected void onEnter() {
    }

    protected void onLeave() {
    }

    protected void mousePressed() {
    }

    protected void mouseReleased() {
    }

    protected void mouseReleasedOutside() {
    }

    @Override
    public final boolean setMousePressed(boolean bl) {
        if (!this.isVisible && !this.isUserInteraction) {
            return false;
        }
        if (bl) {
            if (this.isInside) {
                this.isMousePressed = true;
                if (!ControlP5.keyHandler.isAltDown) {
                    this.mousePressed();
                }
                return true;
            }
        } else {
            if (this.isMousePressed && this.inside()) {
                this.isMousePressed = false;
                if (!ControlP5.keyHandler.isAltDown) {
                    this.mouseReleased();
                }
            }
            if (!this.inside()) {
                this.setIsInside(false);
                this.isMousePressed = false;
                this.mouseReleasedOutside();
            }
        }
        return false;
    }

    protected void setIsInside(boolean bl) {
        this.isInside = bl;
    }

    protected boolean getIsInside() {
        return this.isInside;
    }

    @Override
    public void keyEvent(KeyEvent keyEvent) {
    }

    @Override
    public void setId(int n) {
        this._myId = n;
    }

    @Override
    public int id() {
        return this._myId;
    }

    protected ControllerPlug controllerPlug(int n) {
        return this._myControllerPlugList.get(n);
    }

    protected List<ControllerPlug> getControllerPlugList() {
        return this._myControllerPlugList;
    }

    protected boolean checkControllerPlug(ControllerPlug controllerPlug) {
        for (ControllerPlug controllerPlug2 : this._myControllerPlugList) {
            if (!controllerPlug2.object().equals(controllerPlug.object()) || !controllerPlug2.name().equals(controllerPlug.name())) continue;
            return true;
        }
        return false;
    }

    protected void addControllerPlug(ControllerPlug controllerPlug) {
        if (this.checkControllerPlug(controllerPlug)) {
            return;
        }
        this._myControllerPlugList.add(controllerPlug);
    }

    protected void removeControllerPlug(ControllerPlug controllerPlug) {
        this._myControllerPlugList.remove(controllerPlug);
    }

    public void plugTo(Object[] objectArray) {
        for (Object object : objectArray) {
            this.plugTo(object);
        }
    }

    public void plugTo(Object object) {
        if (!(object instanceof PApplet)) {
            this.controlP5.controlbroadcaster().plug(object, this, this._myName);
            this.controlP5.controlbroadcaster().plug(object, this, this.controlP5.controlbroadcaster().getEventMethod());
        }
    }

    public void unplugFrom(Object[] objectArray) {
        for (Object object : objectArray) {
            this.unplugFrom(object);
        }
    }

    public void unplugFrom(Object object) {
        Iterator<ControllerPlug> iterator = this._myControllerPlugList.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().object().equals(object)) continue;
            iterator.remove();
        }
    }

    public abstract void setValue(float var1);

    public void setArrayValue(float[] fArray) {
        this._myArrayValue = fArray;
    }

    public final void changeValue(float f) {
        boolean bl = this.isBroadcast;
        this.isBroadcast = false;
        this.setValue(f);
        this.isBroadcast = bl;
    }

    @Override
    public void update() {
    }

    @Override
    public void setUpdate(boolean bl) {
        this.isUpdate = bl;
    }

    @Override
    public boolean isUpdate() {
        return this.isUpdate;
    }

    public void trigger() {
        this.setValue(this.value());
    }

    @Override
    public float value() {
        return this._myValue;
    }

    @Override
    public String stringValue() {
        return this._myStringValue;
    }

    public float[] arrayValue() {
        return this._myArrayValue;
    }

    @Override
    public int getPickingColor() {
        return this._myPickingColor;
    }

    @Override
    public CColor color() {
        return this.color;
    }

    public CColor getColor() {
        return this.color;
    }

    @Override
    public void setLabel(String string) {
        this._myCaptionLabel.setFixedSize(false);
        this._myCaptionLabel.set(string);
        this._myCaptionLabel.setFixedSize(true);
    }

    public void setCaptionLabel(String string) {
        this._myCaptionLabel.setFixedSize(false);
        this._myCaptionLabel.set(string);
        this._myCaptionLabel.setFixedSize(true);
    }

    public void setValueLabel(String string) {
        this._myValueLabel.setFixedSize(false);
        this._myValueLabel.set(string);
        this._myValueLabel.setFixedSize(true);
    }

    public String label() {
        return this._myCaptionLabel.toString();
    }

    public void addListener(ControlListener controlListener) {
        this._myControlListener.add(controlListener);
    }

    public void removeListener(ControlListener controlListener) {
        this._myControlListener.remove(controlListener);
    }

    public int listenerSize() {
        return this._myControlListener.size();
    }

    protected void broadcast(int n) {
        n = this.myBroadcastType;
        ControlEvent controlEvent = new ControlEvent(this);
        for (ControlListener controlListener : this._myControlListener) {
            controlListener.controlEvent(controlEvent);
        }
        if (this.isBroadcast && this.isInit) {
            this.controlP5.controlbroadcaster().broadcast(controlEvent, n);
        }
        this.isInit = true;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
        if (!bl) {
            this.isActive = false;
        }
    }

    @Override
    public void hide() {
        this.isVisible = false;
        this.isActive = false;
    }

    @Override
    public void show() {
        this.isVisible = true;
    }

    public void setColor(CColor cColor) {
        this.color.set(cColor);
        this.setColorLabel(cColor.getCaptionLabel());
        this.setColorValueLabel(cColor.getValueLabel());
    }

    @Override
    public void setColorActive(int n) {
        this.color.colorActive = n;
    }

    @Override
    public void setColorForeground(int n) {
        this.color.colorForeground = n;
    }

    @Override
    public void setColorBackground(int n) {
        this.color.colorBackground = n;
    }

    @Override
    public void setColorLabel(int n) {
        this.setColorCaptionLabel(n);
    }

    public void setColorCaptionLabel(int n) {
        this.color.colorCaptionLabel = n;
        this._myCaptionLabel.set(this._myCaptionLabel.toString(), this.color.colorCaptionLabel);
    }

    @Override
    public void setColorValue(int n) {
        this.setColorValueLabel(n);
    }

    public void setColorValueLabel(int n) {
        this.color.colorValueLabel = n;
        if (this._myValueLabel != null) {
            this._myValueLabel.set(this._myValueLabel.toString(), this.color.colorValueLabel);
        }
    }

    public Controller setImages(PImage pImage, PImage pImage2, PImage pImage3) {
        this.setImage(pImage, 0);
        this.setImage(pImage2, 1);
        this.setImage(pImage3, 2);
        this.setImage(pImage3, 3);
        return this;
    }

    public Controller setImages(PImage pImage, PImage pImage2, PImage pImage3, PImage pImage4) {
        this.setImage(pImage, 0);
        this.setImage(pImage2, 1);
        this.setImage(pImage3, 2);
        this.setImage(pImage4, 3);
        return this;
    }

    public PImage setImage(PImage pImage) {
        return this.setImage(pImage, 0);
    }

    public PImage setImage(PImage pImage, int n) {
        if (pImage != null) {
            this.images[n] = pImage;
            this.availableImages[n] = true;
            this.updateDisplayMode(1);
            return pImage;
        }
        return null;
    }

    public Controller updateSize() {
        if (this.images[0] != null) {
            this.setSize(this.images[0]);
        }
        return this;
    }

    public void setSize(PImage pImage) {
        if (pImage != null) {
            this.setSize(pImage.width, pImage.height);
        }
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    protected void updateDisplayMode(int n) {
        if (n != 0) {
            ControlP5.logger().warning("Image-based or custom displays are not yet implemented for this type of controller. (" + this.getClass().getName() + ")");
        }
    }

    public void setDisplay(ControllerDisplay controllerDisplay) {
        this.setDisplay(controllerDisplay, 3);
    }

    public void setDisplay(ControllerDisplay controllerDisplay, int n) {
        this._myDisplayMode = n;
        this._myDisplay = controllerDisplay;
    }

    public Label captionLabel() {
        return this._myCaptionLabel;
    }

    public Label valueLabel() {
        return this._myValueLabel;
    }

    public float max() {
        return this._myMax;
    }

    public float min() {
        return this._myMin;
    }

    public void setMin(float f) {
        this._myMin = f;
    }

    public void setMax(float f) {
        this._myMax = f;
    }

    public Controller setWidth(int n) {
        this.width = n;
        return this;
    }

    public Controller setHeight(int n) {
        this.height = n;
        return this;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setDecimalPrecision(int n) {
        this._myDecimalPoints = n;
        this._myValueLabel = new Label("" + (this.adjustValue(this._myMax).length() > this.adjustValue(this._myMin).length() ? this.adjustValue(this._myMax) : this.adjustValue(this._myMin)), this.color.colorValueLabel);
        this._myValueLabel.set("" + this.adjustValue(this._myValue));
    }

    protected String adjustValue(float f) {
        return this.adjustValue(f, this._myDecimalPoints);
    }

    protected String adjustValue(float f, int n) {
        Object object;
        block6: {
            int n2;
            block5: {
                int n3;
                int n4;
                n2 = n + 1;
                if (this.getControllerPlugList().size() > 0) {
                    object = this.getControllerPlugList().iterator();
                    while (object.hasNext()) {
                        ControllerPlug controllerPlug = object.next();
                        if (controllerPlug.classType() != Integer.TYPE) continue;
                        n2 = 0;
                    }
                }
                if ((n4 = ((String)(object = "" + f)).indexOf(46)) <= 0) break block5;
                if (n == 0) {
                    --n4;
                }
                if ((n3 = ((String)(object = ((String)object).substring(0, Math.min(((String)object).length(), n4 + n2)))).length() - n4) >= n2) break block6;
                for (int i = 0; i < n2 - n3; ++i) {
                    object = (String)object + "0";
                }
                break block6;
            }
            object = (String)object + ".";
            for (int i = 0; i < n2; ++i) {
                object = (String)object + "0";
            }
        }
        return object;
    }

    public ControlWindow controlWindow() {
        return this._myControlWindow;
    }

    public void setSprite(ControllerSprite controllerSprite) {
        this.sprite = controllerSprite;
        this.width = this.sprite.width();
        this.height = this.sprite.height();
        this.enableSprite();
    }

    public ControllerSprite getSprite() {
        return this.sprite;
    }

    public void enableSprite() {
        if (this.sprite != null) {
            this.isSprite = true;
            this.updateDisplayMode(2);
        }
    }

    public void disableSprite() {
        this.isSprite = false;
        this.updateDisplayMode(0);
    }

    public void lock() {
        this.isLock = true;
    }

    public void unlock() {
        this.isLock = false;
    }

    public boolean isLock() {
        return this.isLock;
    }

    public void setLock(boolean bl) {
        this.isLock = bl;
    }

    public void setUserInteraction(boolean bl) {
        this.isUserInteraction = bl;
    }

    public boolean isUserInteraction() {
        return this.isUserInteraction;
    }

    @Override
    public boolean isXMLsavable() {
        return this.isXMLsavable;
    }

    public Controller linebreak() {
        this.controlP5.linebreak(this, true, this.autoWidth, this.autoHeight, this.autoSpacing);
        return this;
    }

    @Override
    public ControlP5XMLElement getAsXML() {
        ControlP5XMLElement controlP5XMLElement = new ControlP5XMLElement(new Hashtable(), true, false);
        controlP5XMLElement.setName("controller");
        controlP5XMLElement.setAttribute("name", this.name());
        controlP5XMLElement.setAttribute("label", this._myCaptionLabel.toString());
        controlP5XMLElement.setAttribute("id", new Integer(this.id()));
        controlP5XMLElement.setAttribute("value", new Float(this.value()));
        controlP5XMLElement.setAttribute("x", new Float(this.position().x()));
        controlP5XMLElement.setAttribute("y", new Float(this.position().y()));
        controlP5XMLElement.setAttribute("width", new Integer(this.width));
        controlP5XMLElement.setAttribute("height", new Integer(this.height));
        controlP5XMLElement.setAttribute("visible", new Float(this.isVisible ? 1.0f : 0.0f));
        controlP5XMLElement.setAttribute("moveable", new Float(this.isMoveable ? 1.0f : 0.0f));
        this.addToXMLElement(controlP5XMLElement);
        return controlP5XMLElement;
    }

    public String toString() {
        return "\ntype:\t" + this.getClass() + "\nname:\t" + this._myName + "\n" + "label:\t" + this._myCaptionLabel.getText() + "\n" + "id:\t" + this._myId + "\n" + "value:\t" + this._myValue + "\n" + "position:\t" + this.position + "\n" + "absolute:\t" + this.absolutePosition + "\n" + "width:\t" + this.getWidth() + "\n" + "height:\t" + this.getHeight() + "\n" + "color:\t" + this.getColor() + "\n" + "visible:\t" + this.isVisible + "\n" + "moveable:\t" + this.isMoveable + "\n";
    }

    class DebugDisplay
    implements ControllerDisplay {
        DebugDisplay() {
        }

        public void display(PApplet pApplet, Controller controller) {
            pApplet.pushStyle();
            if (Controller.this.inside()) {
                pApplet.fill(255.0f, 0.0f, 0.0f, 50.0f);
                pApplet.stroke(255.0f, 0.0f, 0.0f);
            } else {
                pApplet.fill(255, 50.0f);
                pApplet.stroke(255);
            }
            pApplet.pushMatrix();
            pApplet.translate(Controller.this.position.x(), Controller.this.position.y());
            pApplet.rect(0.0f, 0.0f, (float)Controller.this.width, (float)Controller.this.height);
            pApplet.popMatrix();
            pApplet.pushStyle();
        }
    }
}

