/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.ControlP5XMLElement;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.Label;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import processing.core.PApplet;

public class Textfield
extends Controller {
    protected ArrayList<String> myTextList = new ArrayList();
    int myIndex = 1;
    int myPosition = 0;
    StringBuffer myTextline = new StringBuffer();
    private boolean isTexfieldActive = false;
    private boolean isPasswordMode = false;
    protected boolean isAutoClear = true;
    protected boolean isKeepFocus = false;

    public Textfield(ControlP5 controlP5, ControllerGroup controllerGroup, String string, String string2, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2, n3, n4);
        this._myCaptionLabel = new Label(string.toUpperCase(), this.color.colorCaptionLabel);
        this._myCaptionLabel.setFixedSize(false);
        this.myBroadcastType = 3;
        this._myValueLabel.setWidth(this.width - 10);
        this._myValueLabel.setHeight(15);
        this._myValueLabel.set("|");
        this._myValueLabel.setColor(this.color.colorValueLabel);
        this._myValueLabel.toUpperCase(false);
        this._myValueLabel.setFixedSize(true);
        this._myValueLabel.setFont(1);
    }

    public void setValue(float f) {
    }

    public void setPasswordMode(boolean bl) {
        this.isPasswordMode = bl;
    }

    public void setFocus(boolean bl) {
        if (bl) {
            this.mousePressed();
        } else {
            this.mouseReleasedOutside();
        }
    }

    public void keepFocus(boolean bl) {
        this.isKeepFocus = bl;
        if (this.isKeepFocus) {
            this.setFocus(true);
        }
    }

    public boolean isFocus() {
        return this.isTexfieldActive;
    }

    public void setValue(String string) {
        this.myTextline = new StringBuffer(string);
        this._myStringValue = string;
        this.myPosition = this.myTextline.length();
        this._myValueLabel.setWithCursorPosition(this.myTextline.toString(), this.myPosition);
        this.broadcast(this.myBroadcastType);
    }

    public void setText(String string) {
        this.myTextline = new StringBuffer(string);
        this._myStringValue = string;
        this.myPosition = this.myTextline.length();
        this._myValueLabel.setWithCursorPosition(this.myTextline.toString(), this.myPosition);
    }

    public void update() {
        this._myStringValue = this.myTextline.toString();
        this.setValue(this._myStringValue);
    }

    protected void mousePressed() {
        this.isActive = true;
        this.isTexfieldActive = true;
    }

    protected void mouseReleasedOutside() {
        if (!this.isKeepFocus) {
            this.isActive = false;
            this.isTexfieldActive = false;
        }
    }

    public void draw(PApplet pApplet) {
        if (this.isTexfieldActive && this.isActive) {
            pApplet.stroke(this.color.colorActive);
        } else {
            pApplet.stroke(this.color.colorForeground);
        }
        pApplet.fill(this.color.colorBackground);
        pApplet.pushMatrix();
        pApplet.translate(this.position().x(), this.position().y());
        pApplet.rect(0.0f, 0.0f, (float)this.width, (float)this.height);
        pApplet.noStroke();
        this._myValueLabel.draw(pApplet, 4, 7);
        this._myCaptionLabel.draw(pApplet, 0, this.height + 4);
        pApplet.noFill();
        pApplet.popMatrix();
    }

    public void keyEvent(KeyEvent keyEvent) {
        if (!ControlP5.keyHandler.isAltDown && this.isUserInteraction && this.isTexfieldActive && this.isActive && keyEvent.getID() == 401) {
            if (ControlP5.keyHandler.keyCode == 38) {
                if (this.myTextList.size() > 0 && this.myIndex > 0) {
                    --this.myIndex;
                    this.myTextline = new StringBuffer(this.myTextList.get(this.myIndex));
                    this.adjust();
                }
            } else if (ControlP5.keyHandler.keyCode == 40) {
                ++this.myIndex;
                if (this.myIndex >= this.myTextList.size()) {
                    this.myIndex = this.myTextList.size();
                    this.myTextline = new StringBuffer();
                } else {
                    this.myTextline = new StringBuffer(this.myTextList.get(this.myIndex));
                }
                this.adjust();
            } else if (ControlP5.keyHandler.keyCode == 37) {
                if (this.myPosition > 0) {
                    --this.myPosition;
                }
            } else if (ControlP5.keyHandler.keyCode == 39) {
                if (this.myPosition < this.myTextline.length()) {
                    ++this.myPosition;
                }
            } else if (ControlP5.keyHandler.keyCode == 127 || ControlP5.keyHandler.keyCode == 8) {
                if (this.myTextline.length() > 0 && this.myPosition > 0) {
                    this.myTextline.deleteCharAt(this.myPosition - 1);
                    --this.myPosition;
                }
            } else if (ControlP5.keyHandler.keyCode == 10) {
                this.submit();
            } else if (ControlP5.keyHandler.keyCode != 16 && ControlP5.keyHandler.keyCode != 18 && ControlP5.keyHandler.keyCode != 9 && ControlP5.keyHandler.keyCode != 17 && ControlP5.keyHandler.key > '\u001f' && ControlP5.keyHandler.key < '\u007f') {
                this.myTextline.insert(this.myPosition, ControlP5.keyHandler.key);
                ++this.myPosition;
            }
            this.updateField();
        }
    }

    private void updateField() {
        if (this.isPasswordMode) {
            String string = "";
            for (int i = 0; i < this.myTextline.length(); ++i) {
                string = string + "*";
            }
            this._myValueLabel.setWithCursorPosition(string, this.myPosition);
        } else {
            int n = 0;
            int n2 = Label.bitFontRenderer.getWidth(this.myTextline.toString(), this._myValueLabel, this.myPosition);
            n = n2 > this._myValueLabel.width() ? this._myValueLabel.width() - n2 : 0;
            this._myValueLabel.setWithCursorPosition(this.myTextline.toString(), this.myPosition, n);
        }
    }

    public String getText() {
        return this.myTextline.toString();
    }

    public String[] getTextList() {
        String[] stringArray = new String[this.myTextList.size()];
        this.myTextList.toArray(stringArray);
        return stringArray;
    }

    public void clear() {
        this.myTextline = new StringBuffer();
        this.myIndex = this.myTextList.size();
        this.myPosition = 0;
        this.updateField();
    }

    protected void checkClear() {
        if (this.isAutoClear) {
            this.myTextline = new StringBuffer();
            this.myIndex = this.myTextList.size();
            this.myPosition = 0;
            this.updateField();
        }
    }

    public void setAutoClear(boolean bl) {
        this.isAutoClear = bl;
    }

    public boolean isAutoClear() {
        return this.isAutoClear;
    }

    public void submit() {
        if (this.myTextline.length() > 0) {
            this.myTextList.add(this.myTextline.toString());
            this.update();
            this.checkClear();
        }
    }

    protected void adjust() {
        this.myPosition = this.myTextline.length();
        if (this.myPosition < 0) {
            this.myPosition = 0;
        }
    }

    public void addToXMLElement(ControlP5XMLElement controlP5XMLElement) {
        controlP5XMLElement.setAttribute("type", "textfield");
        controlP5XMLElement.setAttribute("value", "" + this.stringValue());
    }
}

