/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import toxi.geom.ReadonlyVec2D;
import toxi.geom.Shape2D;
import toxi.geom.Triangle2D;
import toxi.geom.Vec2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polygon2D
implements Shape2D {
    public List<Vec2D> vertices = new ArrayList<Vec2D>();

    public Polygon2D() {
    }

    public Polygon2D(List<Vec2D> list) {
        for (Vec2D vec2D : list) {
            this.add(vec2D.copy());
        }
    }

    public Polygon2D(Vec2D ... vec2DArray) {
        for (Vec2D vec2D : vec2DArray) {
            this.add(vec2D.copy());
        }
    }

    public Polygon2D add(Vec2D vec2D) {
        if (!this.vertices.contains(vec2D)) {
            this.vertices.add(vec2D);
        }
        return this;
    }

    @Override
    public boolean containsPoint(ReadonlyVec2D readonlyVec2D) {
        int n = this.vertices.size();
        int n2 = n - 1;
        boolean bl = false;
        float f = readonlyVec2D.x();
        float f2 = readonlyVec2D.y();
        int n3 = 0;
        while (n3 < n) {
            Vec2D vec2D = this.vertices.get(n3);
            Vec2D vec2D2 = this.vertices.get(n2);
            if ((vec2D.y < f2 && vec2D2.y >= f2 || vec2D2.y < f2 && vec2D.y >= f2) && vec2D.x + (f2 - vec2D.y) / (vec2D2.y - vec2D.y) * (vec2D2.x - vec2D.x) < f) {
                bl = !bl;
            }
            n2 = n3++;
        }
        return bl;
    }

    public Polygon2D flipVertexOrder() {
        Collections.reverse(this.vertices);
        return this;
    }

    @Override
    public float getArea() {
        float f = 0.0f;
        int n = this.vertices.size();
        for (int i = 0; i < n; ++i) {
            Vec2D vec2D = this.vertices.get(i);
            Vec2D vec2D2 = this.vertices.get((i + 1) % n);
            f += vec2D.x * vec2D2.y;
            f -= vec2D.y * vec2D2.x;
        }
        return f *= 0.5f;
    }

    public Vec2D getCentroid() {
        Vec2D vec2D = new Vec2D();
        int n = this.vertices.size();
        for (int i = 0; i < n; ++i) {
            Vec2D vec2D2 = this.vertices.get(i);
            Vec2D vec2D3 = this.vertices.get((i + 1) % n);
            float f = vec2D2.x * vec2D3.y - vec2D3.x * vec2D2.y;
            vec2D.x += (vec2D2.x + vec2D3.x) * f;
            vec2D.y += (vec2D2.y + vec2D3.y) * f;
        }
        return vec2D.scale(1.0f / (this.getArea() * 6.0f));
    }

    @Override
    public float getCircumference() {
        float f = 0.0f;
        int n = this.vertices.size();
        for (int i = 0; i < n; ++i) {
            f += this.vertices.get(i).distanceTo(this.vertices.get((i + 1) % n));
        }
        return f;
    }

    public int getNumPoints() {
        return this.vertices.size();
    }

    public boolean isClockwise() {
        if (this.vertices.size() > 2) {
            return Triangle2D.isClockwise(this.vertices.get(0), this.vertices.get(1), this.vertices.get(2));
        }
        return false;
    }

    @Deprecated
    public Polygon2D reverseOrientation() {
        return this.flipVertexOrder();
    }

    public Polygon2D smooth(float f, float f2) {
        Vec2D vec2D = this.getCentroid();
        int n = this.vertices.size();
        ArrayList<Vec2D> arrayList = new ArrayList<Vec2D>(n);
        int n2 = n - 1;
        int n3 = 1;
        for (int i = 0; i < n; ++i) {
            Vec2D vec2D2 = this.vertices.get(i);
            Vec2D vec2D3 = this.vertices.get(n2).sub(vec2D2).addSelf(this.vertices.get(n3).sub(vec2D2)).addSelf(vec2D2.sub(vec2D).scaleSelf(f2));
            arrayList.add(vec2D2.add(vec2D3.scaleSelf(f)));
            if (++n2 == n) {
                n2 = 0;
            }
            if (++n3 != n) continue;
            n3 = 0;
        }
        this.vertices.clear();
        this.vertices.addAll(arrayList);
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Vec2D> iterator = this.vertices.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }
}

