/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom.mesh;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import toxi.geom.Vec3D;
import toxi.geom.mesh.Mesh3D;
import toxi.geom.mesh.TriangleMesh;
import toxi.geom.mesh.WETriangleMesh;
import toxi.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STLReader {
    public static final Class<? extends Mesh3D> TRIANGLEMESH = TriangleMesh.class;
    public static final Class<? extends Mesh3D> WEMESH = WETriangleMesh.class;
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private byte[] buf = new byte[12];

    private final float bufferToFloat() {
        return Float.intBitsToFloat(this.bufferToInt());
    }

    private final int bufferToInt() {
        return this.byteToInt(this.buf[0]) | this.byteToInt(this.buf[1]) << 8 | this.byteToInt(this.buf[2]) << 16 | this.byteToInt(this.buf[3]) << 24;
    }

    private final int byteToInt(byte n) {
        return n < 0 ? 256 + n : n;
    }

    public Mesh3D loadBinary(InputStream inputStream, String string, Class<? extends Mesh3D> clazz) {
        return this.loadBinary(inputStream, string, 32768, clazz);
    }

    public Mesh3D loadBinary(InputStream inputStream, String string, int n, Class<? extends Mesh3D> clazz) {
        Mesh3D mesh3D = null;
        try {
            int n2;
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream, n));
            for (n2 = 0; n2 < 80; ++n2) {
                dataInputStream.read();
            }
            dataInputStream.read(this.buf, 0, 4);
            n2 = this.bufferToInt();
            mesh3D = clazz.newInstance();
            mesh3D.init(string, n2, n2);
            Vec3D vec3D = new Vec3D();
            Vec3D vec3D2 = new Vec3D();
            Vec3D vec3D3 = new Vec3D();
            for (int i = 0; i < n2; ++i) {
                dataInputStream.read(this.buf, 0, 12);
                this.readVector(dataInputStream, vec3D);
                this.readVector(dataInputStream, vec3D2);
                this.readVector(dataInputStream, vec3D3);
                mesh3D.addFace(vec3D, vec3D3, vec3D2);
                dataInputStream.read(this.buf, 0, 2);
            }
            mesh3D.computeVertexNormals();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return mesh3D;
    }

    public Mesh3D loadBinary(String string, Class<? extends Mesh3D> clazz) {
        return this.loadBinary(string, 32768, clazz);
    }

    public Mesh3D loadBinary(String string, int n, Class<? extends Mesh3D> clazz) {
        Mesh3D mesh3D = null;
        try {
            mesh3D = this.loadBinary(FileUtils.createInputStream(new File(string)), string.substring(string.lastIndexOf(47) + 1), n, clazz);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return mesh3D;
    }

    private Vec3D readVector(DataInputStream dataInputStream, Vec3D vec3D) throws IOException {
        dataInputStream.read(this.buf, 0, 4);
        vec3D.x = this.bufferToFloat();
        dataInputStream.read(this.buf, 0, 4);
        vec3D.y = this.bufferToFloat();
        dataInputStream.read(this.buf, 0, 4);
        vec3D.z = this.bufferToFloat();
        return vec3D;
    }
}

