/*
 * Decompiled with CFR 0.152.
 */
package toxi.util.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import toxi.math.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericSet<T>
implements Iterable<T> {
    protected ArrayList<T> items;
    protected int currID = -1;
    protected T current;
    protected Random random = new Random();

    public GenericSet(Collection<T> collection) {
        this.items = new ArrayList<T>(collection);
        this.pickRandom();
    }

    public GenericSet(T ... TArray) {
        this.items = new ArrayList(TArray.length);
        for (int i = 0; i < TArray.length; ++i) {
            this.items.add(TArray[i]);
        }
        if (this.items.size() > 0) {
            this.pickRandom();
        }
    }

    public boolean add(T t) {
        boolean bl = this.items.add(t);
        if (this.items.size() == 1) {
            this.pickRandom();
        }
        return bl;
    }

    public boolean addAll(Collection<T> collection) {
        return this.items.addAll(collection);
    }

    public void clear() {
        this.items.clear();
    }

    public boolean contains(T t) {
        return this.items.contains(t);
    }

    public GenericSet<T> copy() {
        GenericSet<T> genericSet = new GenericSet<T>(this.items);
        genericSet.current = this.current;
        genericSet.currID = this.currID;
        genericSet.random = this.random;
        return genericSet;
    }

    public T getCurrent() {
        return this.current;
    }

    public ArrayList<T> getItems() {
        return this.items;
    }

    @Override
    public Iterator<T> iterator() {
        return this.items.iterator();
    }

    public T pickRandom() {
        this.currID = MathUtils.random(this.random, this.items.size());
        this.current = this.items.get(this.currID);
        return this.current;
    }

    public T pickRandomUnique() {
        int n = this.items.size();
        if (n > 1) {
            int n2 = this.currID;
            while (n2 == this.currID) {
                n2 = MathUtils.random(this.random, n);
            }
            this.currID = n2;
        } else {
            this.currID = 0;
        }
        this.current = this.items.get(this.currID);
        return this.current;
    }

    public GenericSet<T> seed(long l) {
        this.random.setSeed(l);
        return this;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public int size() {
        return this.items.size();
    }
}

