/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.x11;

import com.jogamp.common.util.VersionNumber;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import jogamp.newt.MonitorModeProps;
import jogamp.newt.driver.x11.RandR;
import jogamp.newt.driver.x11.ScreenDriver;

class RandR11
implements RandR {
    private static final boolean DEBUG = ScreenDriver.DEBUG;
    private static final int SINGLE_CRT_ID = 1;
    private final VersionNumber version;
    private int widthMM = 0;
    private int heightMM = 0;
    private int modeCount = 0;
    private int resolutionCount = 0;
    private int[][] nrates = null;
    private int[] idx_rate = null;
    private int[] idx_res = null;
    volatile int set_screen_idx;
    volatile int set_mode_idx;
    volatile int set_freq;
    volatile int set_rot;
    volatile boolean set_done;

    RandR11(VersionNumber versionNumber) {
        this.version = versionNumber;
    }

    @Override
    public final VersionNumber getVersion() {
        return this.version;
    }

    @Override
    public String toString() {
        return "RandR11[version " + this.version + "]";
    }

    @Override
    public void dumpInfo(long l, int n) {
    }

    @Override
    public boolean beginInitialQuery(long l, ScreenDriver screenDriver) {
        int n;
        int n2 = screenDriver.getIndex();
        this.resolutionCount = RandR11.getNumScreenResolutions0(l, n2);
        if (0 == this.resolutionCount) {
            this.endInitialQuery(l, screenDriver);
            return false;
        }
        this.nrates = new int[this.resolutionCount][];
        for (n = 0; n < this.resolutionCount; ++n) {
            this.nrates[n] = RandR11.getScreenRates0(l, n2, n);
            if (null != this.nrates[n] && 0 != this.nrates[n].length) continue;
            this.endInitialQuery(l, screenDriver);
            return false;
        }
        for (n = 0; n < this.resolutionCount; ++n) {
            this.modeCount += this.nrates[n].length;
        }
        this.idx_rate = new int[this.modeCount];
        this.idx_res = new int[this.modeCount];
        n = 0;
        for (int i = 0; i < this.resolutionCount; ++i) {
            int n3 = 0;
            while (n3 < this.nrates[i].length) {
                this.idx_rate[n] = n3++;
                this.idx_res[n] = i;
                ++n;
            }
        }
        return true;
    }

    @Override
    public void endInitialQuery(long l, ScreenDriver screenDriver) {
        this.idx_rate = null;
        this.idx_res = null;
        this.nrates = null;
    }

    @Override
    public int[] getMonitorDeviceIds(long l, ScreenDriver screenDriver) {
        return new int[]{1};
    }

    @Override
    public int[] getAvailableRotations(long l, ScreenDriver screenDriver, int n) {
        if (1 != n) {
            return null;
        }
        int n2 = screenDriver.getIndex();
        int[] nArray = RandR11.getAvailableScreenRotations0(l, n2);
        if (null == nArray || 0 == nArray.length) {
            return null;
        }
        return nArray;
    }

    @Override
    public int[] getMonitorModeProps(long l, ScreenDriver screenDriver, int n) {
        int n2;
        if (n >= this.modeCount) {
            return null;
        }
        int n3 = screenDriver.getIndex();
        int n4 = this.idx_res[n];
        int n5 = this.idx_rate[n];
        int[] nArray = RandR11.getScreenResolution0(l, n3, n4);
        if (null == nArray || 0 == nArray.length) {
            return null;
        }
        if (0 >= nArray[0] || 0 >= nArray[1]) {
            throw new InternalError("invalid resolution: " + nArray[0] + "x" + nArray[1] + " for res idx " + n4 + "/" + this.resolutionCount);
        }
        if (nArray[2] > this.widthMM) {
            this.widthMM = nArray[2];
        }
        if (nArray[3] > this.heightMM) {
            this.heightMM = nArray[3];
        }
        if (0 >= (n2 = this.nrates[n4][n5])) {
            n2 = 60;
            if (DEBUG) {
                System.err.println("Invalid rate: " + n2 + " at index " + n5 + "/" + this.nrates.length + ", using default: " + 60);
            }
        }
        int[] nArray2 = new int[8];
        int n6 = 0;
        nArray2[n6++] = 8;
        nArray2[n6++] = nArray[0];
        nArray2[n6++] = nArray[1];
        nArray2[n6++] = 32;
        nArray2[n6++] = n2 * 100;
        nArray2[n6++] = 0;
        nArray2[n6++] = n4;
        nArray2[n6++] = -1;
        if (8 != n6) {
            throw new InternalError("XX");
        }
        return nArray2;
    }

    @Override
    public int[] getMonitorDeviceProps(long l, ScreenDriver screenDriver, MonitorModeProps.Cache cache, int n) {
        if (1 != n) {
            return null;
        }
        int[] nArray = this.getCurrentMonitorModeProps(l, screenDriver, n);
        if (null == nArray) {
            return null;
        }
        MonitorMode monitorMode = MonitorModeProps.streamInMonitorMode(null, cache, nArray, 0);
        int n2 = cache.monitorModes.size();
        int[] nArray2 = new int[16 + n2];
        int n3 = 0;
        nArray2[n3++] = nArray2.length;
        nArray2[n3++] = 1;
        nArray2[n3++] = 0;
        nArray2[n3++] = 0 == n ? 1 : 0;
        nArray2[n3++] = this.widthMM;
        nArray2[n3++] = this.heightMM;
        nArray2[n3++] = 0;
        nArray2[n3++] = 0;
        nArray2[n3++] = monitorMode.getRotatedWidth();
        nArray2[n3++] = monitorMode.getRotatedHeight();
        nArray2[n3++] = 0;
        nArray2[n3++] = 0;
        nArray2[n3++] = monitorMode.getRotatedWidth();
        nArray2[n3++] = monitorMode.getRotatedHeight();
        nArray2[n3++] = monitorMode.getId();
        nArray2[n3++] = monitorMode.getRotation();
        for (int i = 0; i < n2; ++i) {
            nArray2[n3++] = cache.monitorModes.get(i).getId();
        }
        return nArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getMonitorDeviceViewport(long l, ScreenDriver screenDriver, int n) {
        int[] nArray;
        if (1 != n) {
            return null;
        }
        int n2 = screenDriver.getIndex();
        long l2 = RandR11.getScreenConfiguration0(l, n2);
        if (0L == l2) {
            return null;
        }
        try {
            int n3 = RandR11.getNumScreenResolutions0(l, n2);
            if (0 == n3) {
                int[] nArray2 = null;
                return nArray2;
            }
            int n4 = RandR11.getCurrentScreenResolutionIndex0(l2);
            if (0 > n4) {
                int[] nArray3 = null;
                return nArray3;
            }
            if (n4 >= n3) {
                throw new RuntimeException("Invalid resolution index: ! " + n4 + " < " + n3);
            }
            nArray = RandR11.getScreenResolution0(l, n2, n4);
            if (null == nArray || 0 == nArray.length) {
                int[] nArray4 = null;
                return nArray4;
            }
            if (0 >= nArray[0] || 0 >= nArray[1]) {
                throw new InternalError("invalid resolution: " + nArray[0] + "x" + nArray[1] + " for res idx " + n4 + "/" + n3);
            }
        }
        finally {
            RandR11.freeScreenConfiguration0(l2);
        }
        int[] nArray5 = new int[4];
        int n5 = 0;
        nArray5[n5++] = 0;
        nArray5[n5++] = 0;
        nArray5[n5++] = nArray[0];
        nArray5[n5++] = nArray[1];
        return nArray5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getCurrentMonitorModeProps(long l, ScreenDriver screenDriver, int n) {
        int n2;
        int n3;
        int[] nArray;
        int n4;
        if (1 != n) {
            return null;
        }
        int n5 = screenDriver.getIndex();
        long l2 = RandR11.getScreenConfiguration0(l, n5);
        if (0L == l2) {
            return null;
        }
        try {
            int n6 = RandR11.getNumScreenResolutions0(l, n5);
            if (0 == n6) {
                int[] nArray2 = null;
                return nArray2;
            }
            n4 = RandR11.getCurrentScreenResolutionIndex0(l2);
            if (0 > n4) {
                int[] nArray3 = null;
                return nArray3;
            }
            if (n4 >= n6) {
                throw new RuntimeException("Invalid resolution index: ! " + n4 + " < " + n6);
            }
            nArray = RandR11.getScreenResolution0(l, n5, n4);
            if (null == nArray || 0 == nArray.length) {
                int[] nArray4 = null;
                return nArray4;
            }
            if (0 >= nArray[0] || 0 >= nArray[1]) {
                throw new InternalError("invalid resolution: " + nArray[0] + "x" + nArray[1] + " for res idx " + n4 + "/" + n6);
            }
            n3 = RandR11.getCurrentScreenRate0(l2);
            if (0 > n3) {
                int[] nArray5 = null;
                return nArray5;
            }
            n2 = RandR11.getCurrentScreenRotation0(l2);
            if (0 > n2) {
                int[] nArray6 = null;
                return nArray6;
            }
        }
        finally {
            RandR11.freeScreenConfiguration0(l2);
        }
        int[] nArray7 = new int[8];
        int n7 = 0;
        nArray7[n7++] = 8;
        nArray7[n7++] = nArray[0];
        nArray7[n7++] = nArray[1];
        nArray7[n7++] = 32;
        nArray7[n7++] = n3 * 100;
        nArray7[n7++] = 0;
        nArray7[n7++] = n4;
        nArray7[n7++] = n2;
        if (8 != n7) {
            throw new InternalError("XX");
        }
        return nArray7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setCurrentMonitorModeStart(long l, ScreenDriver screenDriver, MonitorDevice monitorDevice, MonitorMode monitorMode) {
        int n = screenDriver.getIndex();
        long l2 = RandR11.getScreenConfiguration0(l, n);
        if (0L == l2) {
            return false;
        }
        boolean bl = false;
        try {
            int n2 = monitorMode.getId();
            if (0 > n2 || n2 >= this.resolutionCount) {
                throw new RuntimeException("Invalid resolution index: ! 0 < " + n2 + " < " + this.resolutionCount + ", " + monitorDevice + ", " + monitorMode);
            }
            int n3 = (int)monitorMode.getRefreshRate();
            int n4 = monitorMode.getRotation();
            this.set_screen_idx = n;
            this.set_mode_idx = n2;
            this.set_freq = n3;
            this.set_rot = n4;
            this.set_done = false;
            bl = RandR11.setCurrentScreenModeStart0(l, n, l2, n2, n3, n4);
            if (!bl) {
                this.clearSetModeState();
            }
        }
        finally {
            RandR11.freeScreenConfiguration0(l2);
        }
        return bl;
    }

    @Override
    public boolean setCurrentMonitorModeWait(ScreenDriver screenDriver) {
        long l = System.currentTimeMillis();
        boolean bl = false;
        while (!bl && System.currentTimeMillis() - l < 10000L) {
            bl = this.set_done;
            if (bl) continue;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.clearSetModeState();
        return bl;
    }

    @Override
    public void sendRRScreenChangeNotify(long l, long l2) {
        this.set_done = RandR11.sendRRScreenChangeNotify0(l, this.set_screen_idx, l2, this.set_mode_idx, this.set_freq, this.set_rot);
    }

    private void clearSetModeState() {
        this.set_screen_idx = -1;
        this.set_mode_idx = -1;
        this.set_freq = 0;
        this.set_rot = 0;
        this.set_done = false;
    }

    @Override
    public final void updateScreenViewport(long l, ScreenDriver screenDriver, RectangleImmutable rectangleImmutable) {
    }

    private static native int[] getAvailableScreenRotations0(long var0, int var2);

    private static native int getNumScreenResolutions0(long var0, int var2);

    private static native int[] getScreenResolution0(long var0, int var2, int var3);

    private static native int[] getScreenRates0(long var0, int var2, int var3);

    private static native long getScreenConfiguration0(long var0, int var2);

    private static native void freeScreenConfiguration0(long var0);

    private static native int getCurrentScreenResolutionIndex0(long var0);

    private static native int getCurrentScreenRate0(long var0);

    private static native int getCurrentScreenRotation0(long var0);

    private static native boolean setCurrentScreenModeStart0(long var0, int var2, long var3, int var5, int var6, int var7);

    private static native boolean sendRRScreenChangeNotify0(long var0, int var2, long var3, int var5, int var6, int var7);
}

