/*
 * Decompiled with CFR 0.152.
 */
package ro.licj.magnus;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ro.licj.magnus.ui.Color;
import ro.licj.magnus.ui.ColorGenerator;

public class ColorPallette {
    public static float difference(Color c1, Color c2) {
        float rez = Math.max(Math.max(Math.abs(c1.r - c2.r), Math.abs(c1.g - c2.g)), Math.abs(c1.b - c2.b));
        return rez;
    }

    public static void main(String[] args) {
        final JFrame frame = new JFrame();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowevent) {
                frame.dispose();
            }
        });
        JPanel colorsPanel = new JPanel(new GridBagLayout());
        frame.getContentPane().add((Component)colorsPanel, "Center");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.insets = new Insets(10, 10, 10, 10);
        colorsPanel.setBackground(new java.awt.Color(0.0f, 1.0f, 1.0f));
        for (int i = 0; i < 2; ++i) {
            int j = 0;
            while (j < 7) {
                constraints.gridx = j++;
                constraints.gridy = i;
                Color col = ColorGenerator.getInstance().next();
                JLabel label = new JLabel("  " + ColorGenerator.getInstance().getCurrentColorIndex() + "  ");
                label.setBackground(new java.awt.Color(col.r, col.g, col.b));
                label.setOpaque(true);
                colorsPanel.add((Component)label, constraints);
            }
        }
        colorsPanel.repaint();
        colorsPanel.revalidate();
        frame.pack();
        frame.setVisible(true);
    }
}

