/*
 * Decompiled with CFR 0.152.
 */
package ro.licj.magnus;

import ro.licj.magnus.util.Point;
import ro.licj.magnus.util.Vector;

public class Mobile {
    private double mass;
    private Point position;
    private double angle;
    private double frequency;
    private Vector speed;
    private Vector size;

    public Mobile(Point initialPosition, double mass, Vector size) {
        this.position = initialPosition;
        this.mass = mass;
        this.size = size;
        this.angle = 0.0;
        this.speed = new Vector(0.0, 0.0);
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    public Point getPosition() {
        return this.position;
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public double getAngle() {
        return this.angle;
    }

    public Vector getSpeed() {
        return this.speed;
    }

    public void setSpeed(Vector speed) {
        this.speed = speed;
    }

    public Vector getSize() {
        return this.size;
    }

    public void update() {
        this.updateAngle();
        this.updatePosition();
    }

    private void updateAngle() {
        this.angle += this.frequency * 2.0 * Math.PI * 0.025;
        while (this.angle > Math.PI * 2) {
            this.angle -= Math.PI * 2;
        }
    }

    private void updatePosition() {
        this.position.x += this.speed.x * 0.025;
        this.position.y += this.speed.y * 0.025;
    }

    public void applyForce(Vector force) {
        this.speed.x += force.x / this.mass * 0.025;
        this.speed.y += force.y / this.mass * 0.025;
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
    }

    public double getFrequency() {
        return this.frequency;
    }
}

