/*
 * Decompiled with CFR 0.152.
 */
package ro.licj.magnus.ui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import ro.licj.magnus.ui.Columnifier;

public class GenericTableModel<T>
extends AbstractTableModel {
    private List<T> elements = new ArrayList<T>();
    private Columnifier<T> columnifier;

    public GenericTableModel(Columnifier<T> columnifier) {
        this.columnifier = columnifier;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public int getRowCount() {
        return this.elements.size();
    }

    @Override
    public int getColumnCount() {
        String[] columnNames = this.columnifier.getColumnNames();
        return columnNames.length;
    }

    public Class getColumnClass(int columnIndex) {
        Class[] columnTypes = this.columnifier.getColumnTypes();
        return columnTypes[columnIndex];
    }

    @Override
    public String getColumnName(int columnIndex) {
        String[] columnNames = this.columnifier.getColumnNames();
        return columnNames[columnIndex];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        T item = this.elements.get(rowIndex);
        return this.columnifier.getColumnOfElement(item, columnIndex);
    }

    public void addElement(T item) {
        int index = this.elements.size();
        this.elements.add(item);
        this.fireTableRowsInserted(index, index);
    }

    public void removeAllElements() {
        int size = this.elements.size();
        if (size > 0) {
            this.elements.clear();
            this.fireTableRowsDeleted(0, size - 1);
        }
    }

    public T getElement(int rowIndex) {
        return this.elements.get(rowIndex);
    }

    public void refreshCell(int rowIndex, int columnIndex) {
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }
}

