/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow;

import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.VisualIDHolder;

public class Capabilities
implements CapabilitiesImmutable,
Cloneable {
    protected static final String na_str = "----";
    private int redBits = 8;
    private int greenBits = 8;
    private int blueBits = 8;
    private int alphaBits = 0;
    private boolean backgroundOpaque = true;
    private int transparentValueRed = 0;
    private int transparentValueGreen = 0;
    private int transparentValueBlue = 0;
    private int transparentValueAlpha = 0;
    private boolean onscreen = true;
    private boolean isBitmap = false;
    protected static final String ESEP = "/";
    protected static final String CSEP = ", ";

    @Override
    public Object cloneMutable() {
        return this.clone();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new NativeWindowException(cloneNotSupportedException);
        }
    }

    public Capabilities copyFrom(CapabilitiesImmutable capabilitiesImmutable) {
        this.redBits = capabilitiesImmutable.getRedBits();
        this.greenBits = capabilitiesImmutable.getGreenBits();
        this.blueBits = capabilitiesImmutable.getBlueBits();
        this.alphaBits = capabilitiesImmutable.getAlphaBits();
        this.backgroundOpaque = capabilitiesImmutable.isBackgroundOpaque();
        this.onscreen = capabilitiesImmutable.isOnscreen();
        this.isBitmap = capabilitiesImmutable.isBitmap();
        this.transparentValueRed = capabilitiesImmutable.getTransparentRedValue();
        this.transparentValueGreen = capabilitiesImmutable.getTransparentGreenValue();
        this.transparentValueBlue = capabilitiesImmutable.getTransparentBlueValue();
        this.transparentValueAlpha = capabilitiesImmutable.getTransparentAlphaValue();
        return this;
    }

    @Override
    public int hashCode() {
        int n = 31 + this.redBits;
        n = (n << 5) - n + (this.onscreen ? 1 : 0);
        n = (n << 5) - n + (this.isBitmap ? 1 : 0);
        n = (n << 5) - n + this.greenBits;
        n = (n << 5) - n + this.blueBits;
        n = (n << 5) - n + this.alphaBits;
        n = (n << 5) - n + (this.backgroundOpaque ? 1 : 0);
        n = (n << 5) - n + this.transparentValueRed;
        n = (n << 5) - n + this.transparentValueGreen;
        n = (n << 5) - n + this.transparentValueBlue;
        n = (n << 5) - n + this.transparentValueAlpha;
        return n;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl;
        if (this == object) {
            return true;
        }
        if (!(object instanceof CapabilitiesImmutable)) {
            return false;
        }
        CapabilitiesImmutable capabilitiesImmutable = (CapabilitiesImmutable)object;
        boolean bl2 = bl = capabilitiesImmutable.getRedBits() == this.redBits && capabilitiesImmutable.getGreenBits() == this.greenBits && capabilitiesImmutable.getBlueBits() == this.blueBits && capabilitiesImmutable.getAlphaBits() == this.alphaBits && capabilitiesImmutable.isBackgroundOpaque() == this.backgroundOpaque && capabilitiesImmutable.isOnscreen() == this.onscreen && capabilitiesImmutable.isBitmap() == this.isBitmap;
        if (bl && !this.backgroundOpaque) {
            bl = capabilitiesImmutable.getTransparentRedValue() == this.transparentValueRed && capabilitiesImmutable.getTransparentGreenValue() == this.transparentValueGreen && capabilitiesImmutable.getTransparentBlueValue() == this.transparentValueBlue && capabilitiesImmutable.getTransparentAlphaValue() == this.transparentValueAlpha;
        }
        return bl;
    }

    @Override
    public int compareTo(CapabilitiesImmutable capabilitiesImmutable) {
        int n = this.redBits * this.greenBits * this.blueBits * (this.alphaBits + 1);
        int n2 = capabilitiesImmutable.getRedBits() * capabilitiesImmutable.getGreenBits() * capabilitiesImmutable.getBlueBits() * (capabilitiesImmutable.getAlphaBits() + 1);
        if (n > n2) {
            return 1;
        }
        if (n < n2) {
            return -1;
        }
        return 0;
    }

    @Override
    public int getVisualID(VisualIDHolder.VIDType vIDType) throws NativeWindowException {
        switch (vIDType) {
            case INTRINSIC: 
            case NATIVE: {
                return 0;
            }
        }
        throw new NativeWindowException("Invalid type <" + (Object)((Object)vIDType) + ">");
    }

    @Override
    public final int getRedBits() {
        return this.redBits;
    }

    public void setRedBits(int n) {
        this.redBits = n;
    }

    @Override
    public final int getGreenBits() {
        return this.greenBits;
    }

    public void setGreenBits(int n) {
        this.greenBits = n;
    }

    @Override
    public final int getBlueBits() {
        return this.blueBits;
    }

    public void setBlueBits(int n) {
        this.blueBits = n;
    }

    @Override
    public final int getAlphaBits() {
        return this.alphaBits;
    }

    public void setAlphaBits(int n) {
        this.alphaBits = n;
    }

    public void setBackgroundOpaque(boolean bl) {
        this.backgroundOpaque = bl;
        if (!bl && this.getAlphaBits() == 0) {
            this.setAlphaBits(1);
        }
    }

    @Override
    public final boolean isBackgroundOpaque() {
        return this.backgroundOpaque;
    }

    public void setOnscreen(boolean bl) {
        this.onscreen = bl;
    }

    @Override
    public final boolean isOnscreen() {
        return this.onscreen;
    }

    public void setBitmap(boolean bl) {
        if (bl) {
            this.setOnscreen(false);
        }
        this.isBitmap = bl;
    }

    @Override
    public boolean isBitmap() {
        return this.isBitmap;
    }

    @Override
    public final int getTransparentRedValue() {
        return this.transparentValueRed;
    }

    @Override
    public final int getTransparentGreenValue() {
        return this.transparentValueGreen;
    }

    @Override
    public final int getTransparentBlueValue() {
        return this.transparentValueBlue;
    }

    @Override
    public final int getTransparentAlphaValue() {
        return this.transparentValueAlpha;
    }

    public void setTransparentRedValue(int n) {
        this.transparentValueRed = n;
    }

    public void setTransparentGreenValue(int n) {
        this.transparentValueGreen = n;
    }

    public void setTransparentBlueValue(int n) {
        this.transparentValueBlue = n;
    }

    public void setTransparentAlphaValue(int n) {
        this.transparentValueAlpha = n;
    }

    @Override
    public StringBuilder toString(StringBuilder stringBuilder) {
        return this.toString(stringBuilder, true);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Caps[");
        this.toString(stringBuilder);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    protected StringBuilder onoffScreenToString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        if (this.onscreen) {
            stringBuilder.append("on-scr");
        } else {
            stringBuilder.append("offscr[");
        }
        if (this.isBitmap) {
            stringBuilder.append("bitmap");
        } else if (this.onscreen) {
            stringBuilder.append(".");
        } else {
            stringBuilder.append("auto-cfg");
        }
        stringBuilder.append("]");
        return stringBuilder;
    }

    protected StringBuilder toString(StringBuilder stringBuilder, boolean bl) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("rgba ").append(this.redBits).append(ESEP).append(this.greenBits).append(ESEP).append(this.blueBits).append(ESEP).append(this.alphaBits);
        if (this.backgroundOpaque) {
            stringBuilder.append(", opaque");
        } else {
            stringBuilder.append(", trans-rgba 0x").append(this.toHexString(this.transparentValueRed)).append(ESEP).append(this.toHexString(this.transparentValueGreen)).append(ESEP).append(this.toHexString(this.transparentValueBlue)).append(ESEP).append(this.toHexString(this.transparentValueAlpha));
        }
        if (bl) {
            stringBuilder.append(CSEP);
            this.onoffScreenToString(stringBuilder);
        }
        return stringBuilder;
    }

    protected final String toHexString(int n) {
        return Integer.toHexString(n);
    }
}

