/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.x11.glx;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.gluegen.runtime.opengl.GLProcAddressResolver;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.nativewindow.x11.X11Util;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.x11.glx.GLX;
import jogamp.opengl.x11.glx.GLXExt;
import jogamp.opengl.x11.glx.GLXExtImpl;
import jogamp.opengl.x11.glx.GLXExtProcAddressTable;
import jogamp.opengl.x11.glx.GLXUtil;
import jogamp.opengl.x11.glx.X11GLXDrawableFactory;
import jogamp.opengl.x11.glx.X11GLXGraphicsConfiguration;

public class X11GLXContext
extends GLContextImpl {
    private static final Map<String, String> extensionNameMap = new HashMap<String, String>();
    private GLXExt _glXExt;
    private GLXExtProcAddressTable glXExtProcAddressTable;
    private int hasSwapInterval = 0;
    private int hasSwapGroupNV = 0;
    protected boolean isDirect;
    protected volatile VersionNumber glXServerVersion;
    protected volatile boolean isGLXVersionGreaterEqualOneThree;
    private static final int ctx_arb_attribs_idx_major = 0;
    private static final int ctx_arb_attribs_idx_minor = 2;
    private static final int ctx_arb_attribs_idx_flags = 6;
    private static final int ctx_arb_attribs_idx_profile = 8;
    private static final int[] ctx_arb_attribs_rom;

    X11GLXContext(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        super(gLDrawableImpl, gLContext);
    }

    @Override
    protected void resetStates(boolean bl) {
        this.glXExtProcAddressTable = null;
        this.hasSwapInterval = 0;
        this.hasSwapGroupNV = 0;
        this.isDirect = false;
        this.glXServerVersion = null;
        this.isGLXVersionGreaterEqualOneThree = false;
        super.resetStates(bl);
    }

    @Override
    public final ProcAddressTable getPlatformExtProcAddressTable() {
        return this.getGLXExtProcAddressTable();
    }

    public final GLXExtProcAddressTable getGLXExtProcAddressTable() {
        return this.glXExtProcAddressTable;
    }

    @Override
    public Object getPlatformGLExtensions() {
        return this.getGLXExt();
    }

    public GLXExt getGLXExt() {
        if (this._glXExt == null) {
            this._glXExt = new GLXExtImpl(this);
        }
        return this._glXExt;
    }

    @Override
    protected Map<String, String> getFunctionNameMap() {
        return null;
    }

    @Override
    protected Map<String, String> getExtensionNameMap() {
        return extensionNameMap;
    }

    protected final boolean isGLXVersionGreaterEqualOneThree() {
        if (null != this.glXServerVersion) {
            return this.isGLXVersionGreaterEqualOneThree;
        }
        this.glXServerVersion = ((X11GLXDrawableFactory)this.drawable.getFactoryImpl()).getGLXVersionNumber(this.drawable.getNativeSurface().getGraphicsConfiguration().getScreen().getDevice());
        this.isGLXVersionGreaterEqualOneThree = null != this.glXServerVersion ? this.glXServerVersion.compareTo(X11GLXDrawableFactory.versionOneThree) >= 0 : false;
        return this.isGLXVersionGreaterEqualOneThree;
    }

    protected final void forceGLXVersionOneOne() {
        this.glXServerVersion = X11GLXDrawableFactory.versionOneOne;
        this.isGLXVersionGreaterEqualOneThree = false;
        if (DEBUG) {
            System.err.println("X11GLXContext.forceGLXVersionNumber: " + this.glXServerVersion);
        }
    }

    @Override
    public final boolean isGLReadDrawableAvailable() {
        return this.isGLXVersionGreaterEqualOneThree();
    }

    private final boolean glXMakeContextCurrent(long l, long l2, long l3, long l4) {
        boolean bl;
        block4: {
            bl = false;
            try {
                if (this.isGLXVersionGreaterEqualOneThree()) {
                    bl = GLX.glXMakeContextCurrent(l, l2, l3, l4);
                    break block4;
                }
                if (l2 == l3) {
                    bl = GLX.glXMakeCurrent(l, l2, l4);
                    break block4;
                }
                throw new InternalError("Given readDrawable but no driver support");
            }
            catch (RuntimeException runtimeException) {
                if (!DEBUG_TRACE_SWITCH) break block4;
                System.err.println(X11GLXContext.getThreadName() + ": Warning: X11GLXContext.glXMakeContextCurrent failed: " + runtimeException + ", with " + "dpy " + X11GLXContext.toHexString(l) + ", write " + X11GLXContext.toHexString(l2) + ", read " + X11GLXContext.toHexString(l3) + ", ctx " + X11GLXContext.toHexString(l4));
                runtimeException.printStackTrace();
            }
        }
        return bl;
    }

    private final boolean glXReleaseContext(long l) {
        boolean bl;
        block2: {
            bl = false;
            try {
                bl = this.isGLXVersionGreaterEqualOneThree() ? GLX.glXMakeContextCurrent(l, 0L, 0L, 0L) : GLX.glXMakeCurrent(l, 0L, 0L);
            }
            catch (RuntimeException runtimeException) {
                if (!DEBUG_TRACE_SWITCH) break block2;
                System.err.println(X11GLXContext.getThreadName() + ": Warning: X11GLXContext.glXReleaseContext failed: " + runtimeException + ", with " + "dpy " + X11GLXContext.toHexString(l));
                runtimeException.printStackTrace();
            }
        }
        return bl;
    }

    @Override
    protected void destroyContextARBImpl(long l) {
        long l2 = this.drawable.getNativeSurface().getDisplayHandle();
        this.glXReleaseContext(l2);
        GLX.glXDestroyContext(l2, l);
    }

    @Override
    protected long createContextARBImpl(long l, boolean bl, int n, int n2, int n3) {
        long l2;
        long l3;
        block21: {
            boolean bl2;
            if (DEBUG) {
                System.err.println(X11GLXContext.getThreadName() + ": X11GLXContext.createContextARBImpl: " + X11GLXContext.getGLVersion(n2, n3, n, "@creation") + ", handle " + X11GLXContext.toHexString(this.drawable.getHandle()) + ", share " + X11GLXContext.toHexString(l) + ", direct " + bl);
            }
            boolean bl3 = 0 == (8 & n);
            boolean bl4 = 0 != (2 & n);
            boolean bl5 = 0 != (0x10 & n);
            boolean bl6 = bl2 = 0 != (0x20 & n);
            if (!bl3) {
                if (DEBUG) {
                    System.err.println(X11GLXContext.getThreadName() + ": X11GLXContext.createContextARBImpl: GL ES not avail " + X11GLXContext.getGLVersion(n2, n3, n, "@creation"));
                }
                return 0L;
            }
            GLDynamicLookupHelper gLDynamicLookupHelper = this.getGLDynamicLookupHelper(n2, n);
            if (null == gLDynamicLookupHelper) {
                if (DEBUG) {
                    System.err.println(X11GLXContext.getThreadName() + " - X11GLXContext.createContextARBImpl: Null GLDynamicLookupHelper");
                }
                return 0L;
            }
            this.updateGLXProcAddressTable(null, gLDynamicLookupHelper);
            GLXExt gLXExt = this.getGLXExt();
            if (DEBUG) {
                System.err.println(X11GLXContext.getThreadName() + ": X11GLXContext.createContextARBImpl: " + ", glXCreateContextAttribsARB: " + X11GLXContext.toHexString(this.glXExtProcAddressTable._addressof_glXCreateContextAttribsARB));
            }
            IntBuffer intBuffer = Buffers.newDirectIntBuffer(ctx_arb_attribs_rom);
            intBuffer.put(1, n2);
            intBuffer.put(3, n3);
            if (n2 > 3 || n2 == 3 && n3 >= 2) {
                intBuffer.put(8, 37158);
                if (bl4) {
                    intBuffer.put(9, 2);
                } else {
                    intBuffer.put(9, 1);
                }
            }
            if (n2 >= 3) {
                int n4 = intBuffer.get(7);
                if (!bl4 && bl5) {
                    n4 |= 2;
                }
                if (bl2) {
                    n4 |= 1;
                }
                intBuffer.put(7, n4);
            }
            X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = (X11GLXGraphicsConfiguration)this.drawable.getNativeSurface().getGraphicsConfiguration();
            AbstractGraphicsDevice abstractGraphicsDevice = x11GLXGraphicsConfiguration.getScreen().getDevice();
            l3 = abstractGraphicsDevice.getHandle();
            l2 = 0L;
            try {
                X11Util.setX11ErrorHandler(true, !DEBUG);
                X11Lib.XSync(l3, false);
                l2 = gLXExt.glXCreateContextAttribsARB(l3, x11GLXGraphicsConfiguration.getFBConfig(), l, bl, intBuffer);
            }
            catch (RuntimeException runtimeException) {
                if (!DEBUG) break block21;
                System.err.println(X11GLXContext.getThreadName() + ": Info: X11GLXContext.createContextARBImpl glXCreateContextAttribsARB failed with " + X11GLXContext.getGLVersion(n2, n3, n, "@creation"));
                ExceptionUtils.dumpThrowable("", runtimeException);
            }
        }
        if (0L != l2) {
            if (!this.glXMakeContextCurrent(l3, this.drawable.getHandle(), this.drawableRead.getHandle(), l2)) {
                if (DEBUG) {
                    System.err.println(X11GLXContext.getThreadName() + ": X11GLXContext.createContextARBImpl couldn't make current " + X11GLXContext.getGLVersion(n2, n3, n, "@creation"));
                }
                this.glXReleaseContext(l3);
                GLX.glXDestroyContext(l3, l2);
                l2 = 0L;
            } else if (DEBUG) {
                System.err.println(X11GLXContext.getThreadName() + ": createContextARBImpl: OK " + X11GLXContext.getGLVersion(n2, n3, n, "@creation") + ", share " + l + ", direct " + bl);
            }
        } else if (DEBUG) {
            System.err.println(X11GLXContext.getThreadName() + ": createContextARBImpl: NO " + X11GLXContext.getGLVersion(n2, n3, n, "@creation"));
        }
        return l2;
    }

    @Override
    protected boolean createImpl(long l) throws GLException {
        long l2;
        boolean bl;
        boolean bl2 = true;
        this.isDirect = false;
        X11GLXDrawableFactory x11GLXDrawableFactory = (X11GLXDrawableFactory)this.drawable.getFactoryImpl();
        X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = (X11GLXGraphicsConfiguration)this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = x11GLXGraphicsConfiguration.getScreen().getDevice();
        X11GLXContext x11GLXContext = (X11GLXContext)x11GLXDrawableFactory.getOrCreateSharedContext(abstractGraphicsDevice);
        long l3 = abstractGraphicsDevice.getHandle();
        if (0L != l) {
            bl2 = GLX.glXIsDirect(l3, l);
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)x11GLXGraphicsConfiguration.getChosenCapabilities();
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        boolean bl3 = this.isCreateContextARBAvail(abstractGraphicsDevice) && x11GLXGraphicsConfiguration.hasFBConfig();
        boolean bl4 = bl = null != x11GLXContext && x11GLXContext.isCreatedWithARBMethod();
        if (DEBUG) {
            System.err.println(X11GLXContext.getThreadName() + ": X11GLXContext.createImpl: START " + gLCapabilitiesImmutable + ", share " + X11GLXContext.toHexString(l));
            System.err.println(X11GLXContext.getThreadName() + ": Use ARB[avail[" + this.getCreateContextARBAvailStr(abstractGraphicsDevice) + "], fbCfg " + x11GLXGraphicsConfiguration.hasFBConfig() + " -> " + bl3 + "], shared " + bl + "]");
        }
        if (gLProfile.isGLES()) {
            throw new GLException(X11GLXContext.getThreadName() + ": Unable to create OpenGL ES context on desktopDevice " + abstractGraphicsDevice + ", config " + x11GLXGraphicsConfiguration + ", " + gLProfile + ", shareWith " + X11GLXContext.toHexString(l));
        }
        if (!x11GLXGraphicsConfiguration.hasFBConfig()) {
            this.forceGLXVersionOneOne();
            if (gLProfile.isGL3()) {
                throw new GLException(X11GLXContext.getThreadName() + ": Unable to create OpenGL >= 3.1 context w/o FBConfig");
            }
            this.contextHandle = GLX.glXCreateContext(l3, x11GLXGraphicsConfiguration.getXVisualInfo(), l, bl2);
            if (0L == this.contextHandle) {
                throw new GLException(X11GLXContext.getThreadName() + ": Unable to create context(0)");
            }
            if (!this.glXMakeContextCurrent(l3, this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
                throw new GLException(X11GLXContext.getThreadName() + ": Error making temp context(0) current: display " + X11GLXContext.toHexString(l3) + ", context " + X11GLXContext.toHexString(this.contextHandle) + ", drawable " + this.drawable);
            }
            if (!this.setGLFunctionAvailability(true, 0, 0, 2, false, null == x11GLXContext)) {
                this.glXReleaseContext(l3);
                GLX.glXDestroyContext(l3, this.contextHandle);
                this.contextHandle = 0L;
                throw new GLException("setGLFunctionAvailability !strictMatch failed.1");
            }
            this.isDirect = GLX.glXIsDirect(l3, this.contextHandle);
            if (DEBUG) {
                System.err.println(X11GLXContext.getThreadName() + ": createImpl: OK (old-1) share " + X11GLXContext.toHexString(l) + ", direct " + this.isDirect + "/" + bl2);
            }
            return true;
        }
        boolean bl5 = false;
        if (bl3 && bl) {
            this.contextHandle = this.createContextARB(l, bl2);
            bl5 = true;
            if (DEBUG && 0L != this.contextHandle) {
                System.err.println(X11GLXContext.getThreadName() + ": createImpl: OK (ARB, using sharedContext) share " + X11GLXContext.toHexString(l));
            }
        }
        if (0L == this.contextHandle) {
            l2 = GLX.glXCreateNewContext(l3, x11GLXGraphicsConfiguration.getFBConfig(), 32788, l, bl2);
            if (0L == l2) {
                throw new GLException(X11GLXContext.getThreadName() + ": Unable to create temp OpenGL context(1)");
            }
            if (!this.glXMakeContextCurrent(l3, this.drawable.getHandle(), this.drawableRead.getHandle(), l2)) {
                throw new GLException(X11GLXContext.getThreadName() + ": Error making temp context(1) current: display " + X11GLXContext.toHexString(l3) + ", context " + X11GLXContext.toHexString(l2) + ", drawable " + this.drawable);
            }
            if (!this.setGLFunctionAvailability(true, 0, 0, 2, false, null == x11GLXContext)) {
                this.glXReleaseContext(l3);
                GLX.glXDestroyContext(l3, l2);
                throw new GLException("setGLFunctionAvailability !strictMatch failed.2");
            }
            this.glXReleaseContext(l3);
            if (bl3 && !bl5) {
                boolean bl6 = this.isFunctionAvailable("glXCreateContextAttribsARB");
                boolean bl7 = this.isExtensionAvailable("GLX_ARB_create_context");
                if (bl6 && bl7) {
                    this.contextHandle = this.createContextARB(l, bl2);
                    bl5 = true;
                    if (DEBUG) {
                        if (0L != this.contextHandle) {
                            System.err.println(X11GLXContext.getThreadName() + ": createImpl: OK (ARB, initial) share " + X11GLXContext.toHexString(l));
                        } else {
                            System.err.println(X11GLXContext.getThreadName() + ": createImpl: NOT OK (ARB, initial) - creation failed - share " + X11GLXContext.toHexString(l));
                        }
                    }
                } else if (DEBUG) {
                    System.err.println(X11GLXContext.getThreadName() + ": createImpl: NOT OK (ARB, initial) - extension not available - share " + X11GLXContext.toHexString(l) + ", isProcCreateContextAttribsARBAvailable " + bl6 + ", isExtGLXARBCreateContextAvailable " + bl7);
                }
            }
        } else {
            l2 = 0L;
        }
        if (0L != this.contextHandle) {
            if (0L != l2) {
                this.glXReleaseContext(l3);
                GLX.glXDestroyContext(l3, l2);
                if (!this.glXMakeContextCurrent(l3, this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
                    throw new GLException(X11GLXContext.getThreadName() + ": Cannot make previous verified context current");
                }
            }
        } else {
            if (gLProfile.isGL3() && bl5) {
                this.glXReleaseContext(l3);
                GLX.glXDestroyContext(l3, l2);
                throw new GLException(X11GLXContext.getThreadName() + ": createImpl ARB n/a but required, profile > GL2 requested (OpenGL >= 3.1). Requested: " + gLProfile + ", current: " + this.getGLVersion());
            }
            if (DEBUG) {
                System.err.println(X11GLXContext.getThreadName() + ": createImpl ARB not used[avail " + bl3 + ", tried " + bl5 + "], fall back to !ARB context " + this.getGLVersion());
            }
            this.contextHandle = l2;
            if (!this.glXMakeContextCurrent(l3, this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
                this.glXReleaseContext(l3);
                GLX.glXDestroyContext(l3, l2);
                throw new GLException(X11GLXContext.getThreadName() + ": Error making context(1) current: display " + X11GLXContext.toHexString(l3) + ", context " + X11GLXContext.toHexString(this.contextHandle) + ", drawable " + this.drawable);
            }
            if (DEBUG) {
                System.err.println(X11GLXContext.getThreadName() + ": createImpl: OK (old-2) share " + X11GLXContext.toHexString(l));
            }
        }
        this.isDirect = GLX.glXIsDirect(l3, this.contextHandle);
        if (DEBUG) {
            System.err.println(X11GLXContext.getThreadName() + ": createImpl: OK direct " + this.isDirect + "/" + bl2);
        }
        return true;
    }

    @Override
    protected void makeCurrentImpl() throws GLException {
        long l = this.drawable.getNativeSurface().getDisplayHandle();
        if (!this.glXMakeContextCurrent(l, this.drawable.getHandle(), this.drawableRead.getHandle(), this.contextHandle)) {
            throw new GLException("Error making context " + X11GLXContext.toHexString(this.contextHandle) + " current on Thread " + X11GLXContext.getThreadName() + " with display " + X11GLXContext.toHexString(l) + ", drawableWrite " + X11GLXContext.toHexString(this.drawable.getHandle()) + ", drawableRead " + X11GLXContext.toHexString(this.drawableRead.getHandle()) + " - " + this);
        }
    }

    @Override
    protected void releaseImpl() throws GLException {
        long l = this.drawable.getNativeSurface().getDisplayHandle();
        if (!this.glXReleaseContext(l)) {
            throw new GLException(X11GLXContext.getThreadName() + ": Error freeing OpenGL context");
        }
    }

    @Override
    protected void destroyImpl() throws GLException {
        this.destroyContextARBImpl(this.contextHandle);
    }

    @Override
    protected void copyImpl(GLContext gLContext, int n) throws GLException {
        long l = this.getHandle();
        long l2 = gLContext.getHandle();
        long l3 = this.drawable.getNativeSurface().getDisplayHandle();
        if (0L == l3) {
            throw new GLException(X11GLXContext.getThreadName() + ": Connection to X display not yet set up");
        }
        GLX.glXCopyContext(l3, l2, l, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void updateGLXProcAddressTable(String string, GLDynamicLookupHelper gLDynamicLookupHelper) {
        if (null == gLDynamicLookupHelper) {
            throw new GLException("No GLDynamicLookupHelper for " + this);
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        String string2 = "GLX-" + abstractGraphicsDevice.getUniqueID();
        if (DEBUG) {
            System.err.println(X11GLXContext.getThreadName() + ": Initializing GLX extension address table: " + string2);
        }
        ProcAddressTable procAddressTable = null;
        Object object = mappedContextTypeObjectLock;
        synchronized (object) {
            procAddressTable = (ProcAddressTable)mappedGLXProcAddress.get(string2);
        }
        if (null != procAddressTable) {
            this.glXExtProcAddressTable = (GLXExtProcAddressTable)procAddressTable;
            if (DEBUG) {
                System.err.println(X11GLXContext.getThreadName() + ": GLContext GLX ProcAddressTable reusing key(" + string2 + ") -> " + X11GLXContext.toHexString(procAddressTable.hashCode()));
            }
        } else {
            this.glXExtProcAddressTable = new GLXExtProcAddressTable(new GLProcAddressResolver());
            this.resetProcAddressTable(this.getGLXExtProcAddressTable(), gLDynamicLookupHelper);
            object = mappedContextTypeObjectLock;
            synchronized (object) {
                mappedGLXProcAddress.put(string2, this.getGLXExtProcAddressTable());
                if (DEBUG) {
                    System.err.println(X11GLXContext.getThreadName() + ": GLContext GLX ProcAddressTable mapping key(" + string2 + ") -> " + X11GLXContext.toHexString(this.getGLXExtProcAddressTable().hashCode()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final StringBuilder getPlatformExtensionsStringImpl() {
        NativeSurface nativeSurface = this.drawable.getNativeSurface();
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)nativeSurface.getGraphicsConfiguration().getScreen().getDevice();
        StringBuilder stringBuilder = new StringBuilder();
        x11GraphicsDevice.lock();
        try {
            if (DEBUG) {
                System.err.println("GLX Version client " + GLXUtil.getClientVersionNumber() + ", server: " + GLXUtil.getGLXServerVersionNumber(x11GraphicsDevice));
            }
            if (((X11GLXDrawableFactory)this.drawable.getFactoryImpl()).isGLXVersionGreaterEqualOneOne(x11GraphicsDevice)) {
                String string = GLX.glXGetClientString(x11GraphicsDevice.getHandle(), 3);
                if (DEBUG) {
                    System.err.println("GLX extensions (glXGetClientString): " + string);
                }
                stringBuilder.append(string).append(" ");
                string = GLX.glXQueryExtensionsString(x11GraphicsDevice.getHandle(), nativeSurface.getScreenIndex());
                if (DEBUG) {
                    System.err.println("GLX extensions (glXQueryExtensionsString): " + string);
                }
                stringBuilder.append(string).append(" ");
                string = GLX.glXQueryServerString(x11GraphicsDevice.getHandle(), nativeSurface.getScreenIndex(), 3);
                if (DEBUG) {
                    System.err.println("GLX extensions (glXQueryServerString): " + string);
                }
                stringBuilder.append(string).append(" ");
            }
        }
        finally {
            x11GraphicsDevice.unlock();
        }
        return stringBuilder;
    }

    @Override
    protected final Integer setSwapIntervalImpl2(int n) {
        block27: {
            long l;
            block26: {
                if (!this.drawable.getChosenGLCapabilities().isOnscreen()) {
                    return null;
                }
                l = this.drawable.getNativeSurface().getDisplayHandle();
                if (0 == this.hasSwapInterval) {
                    try {
                        if (this.isExtensionAvailable("GLX_EXT_swap_control")) {
                            block25: {
                                this.hasSwapInterval = 1;
                                if (this.isExtensionAvailable("GLX_EXT_swap_control_tear")) {
                                    try {
                                        IntBuffer intBuffer = Buffers.newDirectIntBuffer(1);
                                        GLX.glXQueryDrawable(l, this.drawable.getHandle(), 8435, intBuffer);
                                        if (1 == intBuffer.get(0)) {
                                            this.hasSwapInterval = 2;
                                            if (DEBUG) {
                                                System.err.println("X11GLXContext.setSwapInterval.2 using: GLX_EXT_swap_control_tear, GLX_EXT_swap_control_tear");
                                            }
                                        } else if (DEBUG) {
                                            System.err.println("X11GLXContext.setSwapInterval.2 n/a: GLX_EXT_swap_control_tear, query: " + intBuffer.get(0));
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        if (!DEBUG) break block25;
                                        ExceptionUtils.dumpThrowable("", throwable);
                                    }
                                }
                            }
                            if (DEBUG && 1 == this.hasSwapInterval) {
                                System.err.println("X11GLXContext.setSwapInterval.1 using: GLX_EXT_swap_control");
                            }
                            break block26;
                        }
                        if (this.isExtensionAvailable("GLX_SGI_swap_control")) {
                            this.hasSwapInterval = 3;
                            if (DEBUG) {
                                System.err.println("X11GLXContext.setSwapInterval.3 using: GLX_SGI_swap_control");
                            }
                        } else {
                            this.hasSwapInterval = -1;
                            if (DEBUG) {
                                System.err.println("X11GLXContext.setSwapInterval.0 N/A");
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        this.hasSwapInterval = -1;
                        if (!DEBUG) break block26;
                        ExceptionUtils.dumpThrowable("", throwable);
                    }
                }
            }
            if (3 == this.hasSwapInterval) {
                int n2 = 0 > n ? Math.abs(n) : n;
                try {
                    GLXExt gLXExt = this.getGLXExt();
                    if (0 == gLXExt.glXSwapIntervalSGI(n2)) {
                        return n2;
                    }
                    break block27;
                }
                catch (Throwable throwable) {
                    this.hasSwapInterval = -1;
                    if (DEBUG) {
                        ExceptionUtils.dumpThrowable("", throwable);
                    }
                    break block27;
                }
            }
            if (0 < this.hasSwapInterval) {
                int n3 = 1 == this.hasSwapInterval && 0 > n ? Math.abs(n) : n;
                try {
                    GLX.glXSwapIntervalEXT(l, this.drawable.getHandle(), n3);
                    return n3;
                }
                catch (Throwable throwable) {
                    this.hasSwapInterval = -1;
                    if (!DEBUG) break block27;
                    ExceptionUtils.dumpThrowable("", throwable);
                }
            }
        }
        return null;
    }

    private final int initSwapGroupImpl(GLXExt gLXExt) {
        if (0 == this.hasSwapGroupNV) {
            try {
                this.hasSwapGroupNV = gLXExt.isExtensionAvailable("GLX_NV_swap_group") ? 1 : -1;
            }
            catch (Throwable throwable) {
                this.hasSwapGroupNV = 1;
            }
            if (DEBUG) {
                System.err.println("initSwapGroupImpl: GLX_NV_swap_group: " + this.hasSwapGroupNV);
            }
        }
        return this.hasSwapGroupNV;
    }

    @Override
    protected final boolean queryMaxSwapGroupsImpl(int[] nArray, int n, int[] nArray2, int n2) {
        boolean bl = false;
        GLXExt gLXExt = this.getGLXExt();
        if (this.initSwapGroupImpl(gLXExt) > 0) {
            NativeSurface nativeSurface = this.drawable.getNativeSurface();
            try {
                IntBuffer intBuffer = Buffers.newDirectIntBuffer(nArray.length - n);
                IntBuffer intBuffer2 = Buffers.newDirectIntBuffer(nArray2.length - n2);
                if (gLXExt.glXQueryMaxSwapGroupsNV(nativeSurface.getDisplayHandle(), nativeSurface.getScreenIndex(), intBuffer, intBuffer2)) {
                    intBuffer.get(nArray, n, intBuffer.remaining());
                    intBuffer2.get(nArray, n, intBuffer2.remaining());
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                this.hasSwapGroupNV = -1;
            }
        }
        return bl;
    }

    @Override
    protected final boolean joinSwapGroupImpl(int n) {
        boolean bl = false;
        GLXExt gLXExt = this.getGLXExt();
        if (this.initSwapGroupImpl(gLXExt) > 0) {
            try {
                if (gLXExt.glXJoinSwapGroupNV(this.drawable.getNativeSurface().getDisplayHandle(), this.drawable.getHandle(), n)) {
                    this.currentSwapGroup = n;
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                this.hasSwapGroupNV = -1;
            }
        }
        return bl;
    }

    @Override
    protected final boolean bindSwapBarrierImpl(int n, int n2) {
        boolean bl = false;
        GLXExt gLXExt = this.getGLXExt();
        if (this.initSwapGroupImpl(gLXExt) > 0) {
            try {
                if (gLXExt.glXBindSwapBarrierNV(this.drawable.getNativeSurface().getDisplayHandle(), n, n2)) {
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                this.hasSwapGroupNV = -1;
            }
        }
        return bl;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(" [");
        super.append(stringBuilder);
        stringBuilder.append(", direct ");
        stringBuilder.append(this.isDirect);
        stringBuilder.append("] ");
        return stringBuilder.toString();
    }

    static {
        extensionNameMap.put("GL_ARB_pbuffer", "GLX_SGIX_pbuffer");
        extensionNameMap.put("GL_ARB_pixel_format", "GLX_SGIX_pbuffer");
        ctx_arb_attribs_rom = new int[]{8337, 0, 8338, 0, 32785, 32788, 8340, 0, 0, 0, 0};
    }
}

