/*
 * Decompiled with CFR 0.152.
 */
package ro.licj.magnus.util;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;

public enum PNGTexture {
    FOOTBALL("res/football.png", 6408, 6408);

    private int width;
    private int height;
    private int internalFormat;
    private int format;
    private ByteBuffer byteBuffer;

    private PNGTexture(String filename, int internalFormat, int format) {
        this.internalFormat = internalFormat;
        this.format = format;
        try {
            BufferedImage bufferedImage = ImageIO.read(new File("res/football.png"));
            this.width = bufferedImage.getWidth();
            this.height = bufferedImage.getHeight();
            Raster raster = bufferedImage.getData();
            DataBufferByte data = (DataBufferByte)raster.getDataBuffer();
            this.byteBuffer = ByteBuffer.allocate(this.width * this.height * 4);
            for (int i = 0; i < bufferedImage.getWidth() * bufferedImage.getHeight() * 4; i += 4) {
                this.byteBuffer.put(data.getData()[i + 1]);
                this.byteBuffer.put(data.getData()[i + 2]);
                this.byteBuffer.put(data.getData()[i + 3]);
                this.byteBuffer.put(data.getData()[i]);
            }
            this.byteBuffer.flip();
        }
        catch (IOException e) {
            throw new RuntimeException("An exception occured when loading the texture \"" + filename + "\".", e);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public int getInternalFormat() {
        return this.internalFormat;
    }

    public int getFormat() {
        return this.format;
    }
}

